static char rcsid[] = "$Id: deftbl.c,v 1.8 1992/04/12 02:10:04 waite Exp $";
/* Property list module */
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <malloc.h>
#include "err.h"
#include "deftbl.h"

#define false 0
#define true 1

/***/
DefTableKey
NewKey()
/* Establish a new definition
 *    On exit-
 *       NewKey=Unique definition table key
 ***/
{
   DefTableKey CurrDef;

   if (CurrDef = (DefTableKey)malloc(sizeof(Entry))) {
      if (CurrDef->PropList = (Entry)malloc(sizeof(struct PropElt))) {
         CurrDef->PropList->selector = 0;
         return CurrDef;
      }
   }
   message(DEADLY, "NewKey: malloc failure", 0, (POSITION *)0);
   return NoKey;
}

/***/
int
find(key, p, r, add)
DefTableKey key; int p; Entry *r; unsigned add;
/* Obtain a relation for a specific property of a definition
 * On entry-
 *    key=definition whose property relation is to be obtained
 *    p=selector for the desired property
 * If the definition does not have the desired property then on exit-
 *    find=false
 *    if add != 0 then r points to a new entry of size add for the property
 *    else r points to the entry following the entry for the property
 * Else on exit-
 *    find=true
 *    r points to the current entry for the property
 ***/
{
   register Entry *b,t;

   if (key == NoKey) return false;
   b = &key->PropList; t = *b;
   while (t->selector > p) { b = &t->next; t = *b; }
   *r = t;
   if (t->selector == p) return true;
   if (add) {
      register Entry new;
      if (!(new = (Entry)malloc(add)))
         message(DEADLY, "find: malloc failure", 0, (POSITION *)0);
      new->next = t; new->selector = p;
      *r = *b = new;
   }
   return false;
}
