/* $Id: SymComp.c,v 3.4 1992/03/26 14:35:25 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#include "Lido.head"

#define LOWER(p)	(p == 0)
#define UPPER(p)	(p > 0)

/* global variables for substitution: */
DefTableKey	tosymkey;
Environment	toscope;
int		tosympos, prodlhsdid, isterm, totailpos;
POSITION	*tocoord, fromcoord;
SEQAttrrule	allcomps;


static
Expr TransExpr ();

static
SEQExpr TransSEQExpr (src)
	SEQExpr		src;
{	
	Expr		ex;

if (src) {
	retrievefirstSEQExpr (src, ex);
	return (AppFrontSEQExpr (
			TransExpr (ex),
			TransSEQExpr (tailSEQExpr (src)))
	);
} else	return (nullSEQExpr ());
}/*TransSEQExp*/

static
Expr TransExpr (src)
	Expr		src;
{	
switch (typeof(src)) {

case KCall:
{	Call	ca;
	SEQExpr	seq;

ca = ExprToCall (src);
seq = TransSEQExpr (paramsOfCall (ca));
ca = MkCall (nameOfCall (ca), seq, rowOfCall (ca), colOfCall (ca));
src = CallToExpr (ca);
return (src);
}

case KAttracc:
{	Attracc		ac;
	int		atid;
	DefTableKey	tokey;
	int		todid;

ac = ExprToAttracc (src);
atid = attridOfAttracc (ac);
tokey = KeyInScope (toscope, atid);
if (tokey == NoKey) 
	tokey = DeclareImplAttr (tosymkey,  atid, ATCLUNKN, &fromcoord);
todid = GetDid (tokey, DIDNON);
ac = MkAttracc (tosympos, todid,
		fromcoord.line, fromcoord.col);
src = AttraccToExpr (ac);
return (src);
};

case KChainacc: {
	Chainacc	ca;
ca = ExprToChainacc (src);
if ((totailpos == 0) && (symbnoOfChainacc(ca) != 0))
	message (ERROR, "HEAD or TAIL inherited to empty production",
	0, tocoord);
if (symbnoOfChainacc(ca) < 0)
	return (ChainaccToExpr (MkChainacc (
		totailpos, chainidOfChainacc (ca),
		fromcoord.line, fromcoord.col)));
else	return (CpExpr(src));
}

case KConstit:
if (UPPER (tosympos)) {
	Constit		c;

	c = CpConstit (ExprToConstit (src));
	subtreeOfConstit (c) = tosympos;
	return (ConstitToExpr (c));
} else	return (CpExpr(src));

case KIncluding: 
if (UPPER (tosympos)) {
	SEQSymbattr	symats;
	Symbattr	symat;
	Attracc		ac;

	foreachinSEQSymbattr 
		(inclattrsOfIncluding (ExprToIncluding (src)), symats, symat) {
	if (prodlhsdid == symbdefOfSymbattr (symat)) {
		ac = MkAttracc (0, 
				attrdefOfSymbattr (symat), 
				fromcoord.line, fromcoord.col);
		src = AttraccToExpr (ac);
		return (src);
	}
	}/*foreach*/
}
return (CpExpr(src));

default:
	return (CpExpr(src));
}

}/*TransExpr*/

int ToBeAdded (new)
	 Attrrule	new;
/* yields true if 
	new is a plain computation or
	there is no computation for the attribute computed by new
		in the list of computations collected so far or
	new is a ChainStart not yet in the list of computations
*/
{	SEQAttrrule	cmps;
	Attrrule	cmp;
	Call		ca, newcall;
	Expr		lhsex, newlhsex;
	ChainStart	newchst, chst;
	int 		newid, newdid, did, gotpos, newpos;
	DefTableKey	newkey;

switch (typeof (new)) {

case KCall:
newcall = AttrruleToCall (new);
if (strcmp (ASSIGNFCT, nameOfCall (newcall)) != 0)
	return (true); /* plain computation */
else {
	retrievefirstSEQExpr (paramsOfCall (newcall), newlhsex);
	if (typeof (newlhsex) == KAttracc) {
		newid = attridOfAttracc (ExprToAttracc (newlhsex));
		newkey = KeyInScope (toscope, newid);
		if (newkey == NoKey) {
		message (ERROR, 
		"inherited to a symbol that does not define this attribute",
		0, &fromcoord);
		message (ERROR, 
		"inherits an undefined attribute use", 0, tocoord);
		return (false);
		}
		newdid = GetDid (newkey, DIDNON);
		newpos = tosympos;
	} else if (typeof (newlhsex) == KChainacc) {
		newdid = chainidOfChainacc (ExprToChainacc (newlhsex));
		newpos = symbnoOfChainacc(ExprToChainacc (newlhsex));
	} else	return (false);
}

foreachinSEQAttrrule (allcomps, cmps, cmp) 
	if (typeof (cmp) == KCall) {
	ca = AttrruleToCall (cmp);
	if (strcmp (ASSIGNFCT, nameOfCall (ca)) == 0) {
		retrievefirstSEQExpr (paramsOfCall (ca), lhsex);
		if (typeof(lhsex) == KAttracc) {
			gotpos = symbnoOfAttracc(ExprToAttracc(lhsex));
			did = attridOfAttracc(ExprToAttracc(lhsex));
		} else if (typeof(lhsex) == KChainacc) {
			gotpos = symbnoOfChainacc(ExprToChainacc(lhsex));
			did = chainidOfChainacc(ExprToChainacc(lhsex));
		} else	return (false);

		if ((newdid == did) && (gotpos == newpos))
			return (false);
	}
}
break;

case KChainStart:
newchst = AttrruleToChainStart (new);
newdid = chainidOfChainStart (newchst);

foreachinSEQAttrrule (allcomps, cmps, cmp) {
	if (typeof (cmp) == KChainStart) {
		chst = AttrruleToChainStart (cmp);
		if (chainidOfChainStart (chst) == newdid)
			return (false);
	}
}/*foreachinSEQAttrrule*/
break;

default:
return (false);

}/*switch*/
return (true);
}/*ToBeAdded*/


/*static*/
void AddSymComps (symcomps)
	SEQAttrrule	symcomps;
{	SEQAttrrule	ars;
	Attrrule	symcomp, ar;
	Call		symcall;
	Expr		ex;
	ChainStart	symcst;

foreachinSEQAttrrule (symcomps, ars, symcomp) 
if (ToBeAdded (symcomp))
switch (typeof (symcomp)) {

case KCall:
	symcall = AttrruleToCall (symcomp);
	fromcoord.line = rowOfCall (symcall);
	fromcoord.col = colOfCall (symcall);
	ex = CallToExpr (symcall);
	ex = TransExpr (ex);
	ar = CallToAttrrule (ExprToCall(ex));
	allcomps = AppFrontSEQAttrrule (ar, allcomps);
break;

case KChainStart:
	symcst = AttrruleToChainStart (symcomp);
	fromcoord.line = rowOfChainStart (symcst);
	fromcoord.col = colOfChainStart (symcst);
	allcomps = AppFrontSEQAttrrule (CpAttrrule (symcomp), allcomps);
break;

default:;

}/*switch, if ToBeAdded, for each comp */
}/*AddSymComps*/

static
void AllSymInhComps (fromkey)
	DefTableKey	fromkey;
{	SEQAttrrule	symcomps;
	TList		inhsyms;

if (LOWER (tosympos))
	symcomps = GetLowAttrib (fromkey, nullSEQAttrrule ());
else {
	if (isterm) {
		symcomps = 
		GetLowAttrib (fromkey, nullSEQAttrrule ());
		AddSymComps (symcomps);
	}
	symcomps = GetUpAttrib (fromkey, nullSEQAttrrule ());
}
AddSymComps (symcomps);

inhsyms = GetInhFrom (fromkey, NullList);
while (inhsyms != NullList) {
	AllSymInhComps ((DefTableKey)HeadList (inhsyms));
	inhsyms = TailList (inhsyms);
}
}/*AllSymInhComps*/

void MakeInhComps (rulekey, symkey, topos, lhsdid, coord)
	DefTableKey	rulekey, symkey;
	int		topos, lhsdid;
	POSITION *	coord;
{	TList		prodlist;
	ProdElem	pel;

tosymkey = symkey;

toscope = GetAttrScope (symkey, NoEnv);
if (toscope == NoEnv) return;

prodlhsdid = lhsdid;
tosympos = topos;
tocoord = coord;
fromcoord.line = coord->line;
fromcoord.col = coord->col;
isterm = (GetSymClass (symkey, SYMBNONT) == SYMBTERM);
allcomps = GetAttrib (rulekey, nullSEQAttrrule());

prodlist = TailList (GetRuleProd (rulekey, NullList));
totailpos = 0;
while (prodlist != NullList) {
	pel = (ProdElem) HeadList (prodlist);
	if (pel->IsSymbol) totailpos++;
	prodlist = TailList (prodlist);
}

AllSymInhComps (symkey);

SetAttrib (rulekey, allcomps, allcomps);
}/*MakeInhComps*/
