# $Id: src.expand.Makefile.cpp,v 1.3 1991/12/18 16:39:38 cogito Exp $
# 
# Makefile of the directory expand
# 
# make the executables of the expand pass
# 

SHELL		= /bin/sh

# IDL
IDL		= ../idl

# option handler
OPTHANDLER	= ../option

DISTRIB		= /tmp

# directory with global definitions for LIGA
SCEL		= ../ligascel

CFLAGS		= -I$(IDL) -I$(OPTHANDLER) -I$(SCEL)
COFLAGS		= -q
SRCS		= expand.c exp_io.c expidl.c expref.c expclass.c exptrav.c \
		exptransfer.c expincl.c expchain.c expconstit.c
HDRS		= expconst.h exp_types.h expidl.h expand.h exp_io.h \
		expchain.h expclass.h expconstit.h expincl.h expref.h \
		exptransfer.h exptrav.h 
RCS		= $(SRCS) $(HDRS)
OBJS		= expand.o exp_io.o expidl.o expref.o expclass.o exptrav.o \
		exptransfer.o expincl.o expchain.o expconstit.o
LIBS		= $(OPTHANDLER)/opt_input.o $(IDL)/IDL.a  $(SCEL)/err.o $(SCEL)/source.o
EXE		= ../ligaExp.exe

TIDY		= *.o a.out core
CLEAN		= $(TIDY) $(EXE) $(IEXE)
CLOBBER		= $(CLEAN) Makefile
RCS		= $(SRCS) $(HDRS)
 
# MAKE

all : $(EXE)

$(EXE): $(OBJS)
	$(CC) $(CFLAGS) -o $(EXE) $(OBJS) $(LIBS)

# checkout
checkout:
	co $(COFLAGS) $(RCS)
	co $(COFLAGS) src.expand.README; mv src.expand.README README

# installation
install:
	rm -f $(DESTDIR)/Tool/liga/ligaExp.exe
	cp $(EXE) $(DESTDIR)/Tool/liga
	chmod 755 $(DESTDIR)/Tool/liga/ligaExp.exe

SourceDistr:	$(SRCS) $(HDRS)

# distribution
distrib:	$(SRCS) $(HDRS)
	- rm -rf $(DISTRIB)/expand
	mkdir $(DISTRIB)/expand
	cp $(SRCS) $(HDRS) Makefile.cpp README $(DISTRIB)/expand
	cd $(DISTRIB)/expand; chmod 0644 $(SRCS) $(HDRS) Makefile.cpp README

# cleaning targets

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

clobber:
	rm -rf $(CLOBBER)

rcsclean:
	rm -rf $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(RCS) Makefile.cpp

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(RCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(RCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(RCS)

exp_io.o: $(IDL)/LIGA.h $(IDL)/global.h $(OPTHANDLER)/option_enums.h \
	$(OPTHANDLER)/option_types.h expconst.h exp_types.h expand.h exp_io.h
expand.o: $(IDL)/LIGA.h $(IDL)/global.h $(SCEL)/err.h \
	$(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
	$(OPTHANDLER)/opt_input.h expconst.h exp_types.h expref.h \
	expidl.h exp_io.h expclass.h exptransfer.h expincl.h expchain.h \
	expconstit.h expand.h
expchain.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h exp_io.h expref.h \
	expidl.h expand.h exptrav.h expchain.h
expclass.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h expref.h \
	expidl.h expand.h expclass.h
expconstit.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h exp_io.h expref.h \
	expidl.h expand.h exptrav.h expconstit.h
expidl.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h exp_io.h expand.h \
	expref.h expidl.h
expincl.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h expref.h expidl.h \
	expand.h exptrav.h expincl.h
expref.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h expconst.h \
	exp_types.h expand.h expref.h expidl.h
exptransfer.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h expand.h expref.h \
	expidl.h exptransfer.h
exptrav.o: $(IDL)/LIGA.h $(IDL)/global.h $(IDL)/LIGAMacros.h \
	$(OPTHANDLER)/option_enums.h $(OPTHANDLER)/option_types.h \
	$(SCEL)/ligaconsts.h expconst.h exp_types.h expref.h \
	expidl.h expand.h expincl.h expchain.h expconstit.h exptrav.h
