/* $Id: attrdecl.c,v 3.1 1992/03/04 17:10:19 uwe Exp $ */

/* LIGA backend module		*/
/* attribute declarations	*/

#include "global.h"
/*
#include "LIGA.h"
#include "LIGAMacros.h"
*/
#include "ligaconsts.h"
#include "lookup_idl.h"
#include "backptg_gen.h"

#include "idn.h"
/* for identification of variable identifiers */

#include "attrdecl.h"
#include "bool.h"

Def	tmpDef;

#define GENTREEATTR     "GENTREE"
#define IsGenAttr(aname) (strcmp (nameOfAttrdef (aname), GENTREEATTR) == 0)


bool IsVoidAttr (ad)
	Attrdef	ad;
{	int	tpdid;

tpdid = typeidOfAttrdef (ad);
return ((tpdid == DIDVOID) || (tpdid == DIDVOLI));
}

PTGNode TreeAttrDecls (aseq)
	SEQAttrdef	aseq;
{	Attrdef		ad;
	SEQAttrdef	as;
	PTGNode		res1, res2, res3;

res1 = PTGEmpty ();
res2 = PTGEmpty ();
res3 = PTGEmpty ();

foreachinSEQAttrdef (aseq, as, ad) {
	if ((storeOfAttrdef (ad) == STORTRAT) &&
	    (! IsVoidAttr (ad)) && 
	    (! IsGenAttr (ad))) {
		tmpDef = lookup_def(typeidOfAttrdef (ad));
		if (classOfAttrdef (ad) == ATCLSYNT)
/* synt tree attr */
			res1 = PTGSeq (res1,
			PTGDecl (
				PTGAsIs (dnameOfDef (tmpDef)),
				PTGTreeAttrName (
					PTGAsIs (nameOfAttrdef (ad)))));
		else
/* inh tree attr */
			res2 = PTGSeq (res2,
			PTGDecl (
				PTGAsIs (dnameOfDef (tmpDef)),
				PTGTreeAttrName (
					PTGAsIs (nameOfAttrdef (ad)))));
	}
}

res1 = PTGSeq (res1, PTGSeq (res2, res3));
return (res1);
}/*TreeAttrDecls*/


static int varcnt = 1;

PTGNode VarAttrDecls (aseq)
	SEQAttrdef	aseq;
{	Attrdef		ad;
	SEQAttrdef	as;
	PTGNode		res;
	char		*tp;
	int		cmp, lg, dummy;

res = PTGEmpty ();

foreachinSEQAttrdef (aseq, as, ad) {
	tmpDef = lookup_def (typeidOfAttrdef (ad));
	tp = dnameOfDef (tmpDef);
	if ((storeOfAttrdef (ad) == STORGLVA) &&
	    (! IsVoidAttr (ad)) && 
	    (! IsGenAttr (ad))) {
		cmp = varcnt;
		lg = strlen (globnameOfAttrdef (ad));
		mkidn (globnameOfAttrdef (ad), lg, &cmp, &dummy);
		if (cmp == varcnt) {/* new identifier */
			varcnt++;
			res = PTGSeq (res,
			PTGDecl (
				PTGAsIs (tp),
				PTGVarAttrName (
					PTGAsIs (globnameOfAttrdef (ad)))));
		}
	}
}
return (res);
}/*VarAttrDecls*/

			 
PTGNode StackAttrDecls (aseq, visit, sympos)
	SEQAttrdef	aseq;
	int		visit, sympos;
{	Attrdef		ad;
	SEQAttrdef	as;
	PTGNode		res, attrname;
	char		*tp;

res = PTGEmpty ();

foreachinSEQAttrdef (aseq, as, ad) {
	if ((storeOfAttrdef (ad) == STORGLST) &&
	    (! IsVoidAttr (ad)) &&
	    (! IsGenAttr (ad)) ) {
		attrname = PTGRhsStackAttrName (
			PTGNumb (sympos),
			PTGAsIs (nameOfAttrdef (ad)));

		tmpDef = lookup_def (typeidOfAttrdef (ad));
		tp = dnameOfDef (tmpDef);

		res = PTGSeq (res, PTGDecl (PTGAsIs (tp), attrname));
	}
}
return (res);
}/*StackAttrDecls*/

			 
PTGNode StackAttrParamSpecs (aseq, visit)
	SEQAttrdef	aseq;
	int		visit;
{	Attrdef		ad;
	SEQAttrdef	as;
	PTGNode		res, attrname;
	char		*tp;

res = PTGEmpty ();

foreachinSEQAttrdef (aseq, as, ad) {
	if ((storeOfAttrdef (ad) == STORGLST) &&
	    (partOfAttrdef (ad) <= visit) &&
		/* all visits after lifetime begin */
	    (! IsVoidAttr (ad)) &&
	    (! IsGenAttr (ad)) ) {
		attrname = PTGLhsStackAttrName (
				PTGAsIs (nameOfAttrdef (ad)));

		tmpDef = lookup_def (typeidOfAttrdef (ad));
		tp = dnameOfDef (tmpDef);
		res = PTGSeq (res, PTGDecl (PTGPtrTo (PTGAsIs (tp)), attrname));
	}
}
return (res);
}/*StackAttrParamSpecs*/
			 
PTGNode StackAttrNames (aseq, visit)
	SEQAttrdef	aseq;
	int		visit;
{	Attrdef		ad;
	PTGNode		res;
	SEQAttrdef	as;

res = PTGEmpty ();

foreachinSEQAttrdef (aseq, as, ad) {
	if ((storeOfAttrdef (ad) == STORGLST) &&
	    (partOfAttrdef (ad) <= visit) &&
		/* all visits after lifetime begin */
	    (! IsVoidAttr (ad)) &&
	    (! IsGenAttr (ad)) ) {
		res = PTGComSeq (PTGLhsStackAttrName (
				PTGAsIs (nameOfAttrdef (ad))),
				res);
	}
}
return (res);
}/*StackAttrNames*/
			 
PTGNode StackArgs (aseq, visit, sympos)
	SEQAttrdef	aseq;
	int		visit, sympos;
{	Attrdef		ad;
	SEQAttrdef	as;
	PTGNode		res;

res = PTGEmpty ();

foreachinSEQAttrdef (aseq, as, ad) {
	if ((storeOfAttrdef (ad) == STORGLST) &&
	    (partOfAttrdef (ad) <= visit) &&
		/* all visits after lifetime begin */
	    (! IsVoidAttr (ad)) &&
	    (! IsGenAttr (ad)) ) {
		res = PTGComSeq (PTGAddr (
			PTGRhsStackAttrName (
				PTGNumb (sympos),
				PTGAsIs (nameOfAttrdef (ad)))),
			res);
	}
}
return (res);
}/*StackArgs*/
