
#include <stdio.h>
#include <malloc.h>
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: output file can't be open.\n");
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGInteger *_PPTGInteger;
struct _SPTGInteger{
  _PTGProc _print;
  int _t0;
};

typedef struct _SPTGString *_PPTGString;
struct _SPTGString{
  _PTGProc _print;
  char *_t0;
};

void _PrPTGNonLit(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (":\t", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
  fputs ("\n", f);
}

void _PrPTGRegExp(n)
_PPTG1 n;
{
  fputs ("$", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGInteger(n)
_PPTGInteger n;
{
  fprintf (f, "%d",n->_t0);
}

void _PrPTGString(n)
_PPTGString n;
{
  fprintf (f, "%s",n->_t0);
}

void _PrPTGSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGCommaSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (",", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGSemiSeq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (";", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

PTGNode PTGNonLit(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGNonLit;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGRegExp(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGRegExp;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGInteger(_t0)
  int _t0;
{
  _PPTGInteger n;

  if ((n = (_PPTGInteger) malloc (sizeof (struct _SPTGInteger)))  ==  (_PPTGInteger)NULL)
	MEMERR
  n->_print = _PrPTGInteger;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGString(_t0)
  char *_t0;
{
  _PPTGString n;

  if ((n = (_PPTGString) malloc (sizeof (struct _SPTGString)))  ==  (_PPTGString)NULL)
	MEMERR
  n->_print = _PrPTGString;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGCommaSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGCommaSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGSemiSeq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGSemiSeq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

