SHELL	= /bin/sh

#ifdef _AIX
CC	= cc -qlanglvl=ansi
#endif

CFLAGS	= 

OBJS    = driver.o parse.o err.o source.o glahead.o pascalCom.o \
	auxScanEOL.o idn.o csm.o str.o int.o pgs_gen.o treecon.o visitprocs.o \
	ptg_gen.o filter.o can.o obstack.o treestack.o attrmain.o dfltclp.o

EXE	= kwfilter.exe

$(EXE):	$(OBJS)
	$(CC) -o $(EXE) $(CFLAGS) $(OBJS)

objects: $(OBJS)

clean:
	rm -f a.out *.o *.a *~ core ERRS $(EXE)

tidy:
	rm -f core a.out *.o *~ *.a ERRS

driver.o:       driver.c HEAD.h INIT.h FINL.h treecon.h ptg_gen.h \
filter.h csm.h treestack.h ptg_gen.h 
parse.o:        parse.c parse.h pgs_gen.h err.h gla.h 
err.o:  err.c err.h source.h 
source.o:       source.c source.h 
glahead.o:      glahead.c err.h source.h xtables.h xcode.h 
pascalCom.o:    pascalCom.c err.h gla.h source.h 
auxScanEOL.o:   auxScanEOL.c err.h gla.h source.h 
idn.o:  idn.c err.h idn.h csm.h idntbl.h 
csm.o:  csm.c csm.h err.h csmtbl.h 
str.o:  str.c str.h csm.h 
int.o:  int.c int.h 
pgs_gen.o:      pgs_gen.c parse.h treecon.h err.h gla.h treestack.h 
treecon.o:      treecon.c HEAD.h node.h visitprocs.h gsdescr.h \
obstack.h treecon.h ptg_gen.h filter.h csm.h treestack.h ptg_gen.h \
err.h 
visitprocs.o:   visitprocs.c HEAD.h err.h node.h visitprocs.h glattr.h \
attrpredef.h treecon.h ptg_gen.h filter.h csm.h treestack.h ptg_gen.h \
err.h 
ptg_gen.o:      ptg_gen.c ptg_gen.h 
filter.o:       filter.c csm.h err.h can.h filter.h ptg_gen.h 
can.o:  can.c can.h 
obstack.o:      obstack.c obstack.h 
treestack.o:    treestack.c err.h treecon.h treestack.h treestack.h 
attrmain.o:     attrmain.c treecon.h visitprocs.h treestack.h 
dfltclp.o:      dfltclp.c source.h 
