# $Id: Makefile.cpp,v 1.14 1992/08/04 22:37:42 kadhim Exp $
# Copyright (c) 1991, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Default master cache location
DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/kwd

EXE	= kwfilter.exe
AUX	= kwd.dg
SYS	= kwd.c match.c match.h
CMD	= kwd.cmd kw.exe.cmd kwd_gen.cmd kwd_out.cmd

TIDY	= *.o core a.out ELI
CLEAN	= $(TIDY) *.exe
CLOBBER	= $(CLEAN) Makefile

all:	$(EXE) $(AUX) $(SYS) $(CMD)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done

install:
	@for f in $(EXE); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/kwd; \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 755 $(DESTDIR)/$(DIR)/$$f; \
	done
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SYS); do \
		echo install -c -m 644 $$f $(DESTDIR)/$(DIR); \
		rm -f $(DESTDIR)/$(DIR)/$$f; \
		cp $$f $(DESTDIR)/$(DIR)/$$f; \
		chmod 644 $(DESTDIR)/$(DIR)/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(AUX) src kw.exe.cmd.cpp

tidy:
	rm -rf $(TIDY)
	cd src; make tidy

clean:
	rm -rf $(CLEAN)
	cd src; make clean

kwfilter.exe:
	cd src; make
	ln src/kwfilter.exe .
