# $Id: Makefile.cpp,v 1.29 1991/07/17 17:21:25 waite Exp $
# make file for "flex" tool

SHELL	= /bin/sh

# the first time around use "make first_flex"
DESTDIR= .

SKEL =		flex.skel flex.fastskel
SKELETON_FILE = \"$(DESTDIR)/Tool/gla/flex.skel\"
F_SKELETON_FILE = \"$(DESTDIR)/Tool/gla/flex.fastskel\"
SKELFLAGS = -DDEFAULT_SKELETON_FILE=$(SKELETON_FILE) \
	    -DFAST_SKELETON_FILE=$(F_SKELETON_FILE)

CFLAGS =
LDFLAGS =

FLEX_FLAGS = -ist
FLEX = flex

HDR=	fastskeldef.h flexdef.h flexskelcom.h flexskeldef.h
FLEXOBJS = \
	ccl.o \
	dfa.o \
	ecs.o \
	main.o \
	misc.o \
	nfa.o \
	parse.o \
	scan.o \
	sym.o \
	tblcmp.o \
	yylex.o

FLEX_C_SOURCES = \
	ccl.c \
	dfa.c \
	ecs.c \
	main.c \
	misc.c \
	nfa.c \
	scan.c \
	sym.c \
	tblcmp.c \
	yylex.c

ALL_SOURCES=	parse.y $(FLEX_C_SOURCES) $(HDR) $(SKEL)
TIDY=	$(OBJS) *.o parse.c *.lint parse.h *ex.yy.c
CLEAN=	$(TIDY) flex
CLOBBER= $(CLEAN) Makefile

all:	flex

flex:	$(FLEXOBJS)
	$(CC) $(CFLAGS) -o flex $(LDFLAGS) $(FLEXOBJS)
	rm -f ../flex
	ln flex ..

install:
	rm -f $(DESTDIR)/Tool/gla/flex
	cp flex $(DESTDIR)/Tool/gla/flex
	chmod 755 $(DESTDIR)/Tool/gla/flex

executable:
	rm -rf $(TIDY) parse.y $(FLEX_C_SOURCES) $(HDR) Makefile Makefile.cpp

SourceDistr:	$(ALL_SOURCES)

# first_flex:
# 	cp scan.c.dist scan.c
# 	make DESTDIR=${DESTDIR} flex

parse.h parse.c : parse.y
	yacc -d parse.y
	@mv y.tab.c parse.c
	@mv y.tab.h parse.h

main.o : main.c
	$(CC) $(CFLAGS) -c $(SKELFLAGS) main.c

lint : $(FLEX_C_SOURCES) parse.c $(HDR)
	@echo "Expect a \"may be used before set\" and 2 \"unused\"'s
	lint $(FLEX_C_SOURCES) parse.c 2>&1 | grep -v RCS


tidy:
	rm -rf $(TIDY)
 
clean:
	rm -rf $(CLEAN)
 
clobber:
	rm -rf $(CLOBBER)
 
rcsclean:
	-rcsclean -q $(ALL_SOURCES) Makefile.cpp
	rm -f $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(ALL_SOURCES)
	-rcs -bOriginal.1 -q Makefile.cpp $(ALL_SOURCES)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(ALL_SOURCES)

test :
	$(FLEX) $(FLEX_FLAGS) scan.l | diff scan.c -
# scan.c : scan.l
# 	$(FLEX) $(FLEX_FLAGS) scan.l >scan.c

$(FLEXOBJS): $(HDR)
scan.o:	scan.c parse.h $(HDR)
