static char RCSid[] = "$Id: misc.c,v 1.4 1992/07/26 20:57:06 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

#include <stdlib.h>
#include "dj.h"
#define MAXLINE 200

/* allocate_array - allocate memory for an integer array of the given size */

char *allocate_array( size, element_size )
int size, element_size;

    {
    register char *mem = (char *)malloc( (unsigned) (element_size * size) );
 
    if ( mem == NULL )
        flexfatal( "memory allocation failed in allocate_array()" );
 
    return ( mem );
    }


/* reallocate_array - increase the size of a dynamic array */

char *reallocate_array( array, size, element_size )
char *array;
int size, element_size;

    {        
    register char *new_array;

    new_array = (char *)realloc( array, (unsigned) (size * element_size ));
 
    if ( new_array == NULL )
        flexfatal( "attempt to increase array size failed" );

    return ( new_array );                                     
    }
 



/* lerrif - report an error message formatted with one integer argument
 *
 * synopsis
 *    char msg[];
 *    int arg;
 *    lerrif( msg, arg );
 */

void lerrif( msg, arg)
char *msg;
int arg;

    {   
    char errmsg[MAXLINE];
    (void) sprintf( errmsg, msg, arg );
    flexerror( errmsg );
    }


/* lerrsf - report an error message formatted with one string argument
 *
 * synopsis
 *    char msg[], arg[];
 *    lerrsf( msg, arg );
 */
 
void lerrsf( msg, arg )
char *msg;
char *arg;
 
    {
    char errmsg[MAXLINE];
     
    (void) sprintf( errmsg, msg, arg );
    flexerror( errmsg );
    }
 
/* flexerror - report an error message and terminate
 *
 * synopsis
 *    char msg[];
 *    flexerror( msg );
 */
     
void flexerror( msg )
char *msg;
 
    {
    fprintf( stderr, "glagen: %s\n", msg );
    /*flexend( 1 );*/
    exit(1);
    }
 
 
/* flexfatal - report a fatal error message and terminate
 *
 * synopsis
 *    char msg[];
 *    flexfatal( msg );
 */
 
void flexfatal( msg )
char *msg;
 
    {
    fprintf( stderr, "glagen: fatal internal error %s\n", msg );
    /* flexend( 1 );*/
    exit(1);
    }
