# $Id: Makefile.cpp,v 1.34 1992/07/26 21:46:55 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado 

SHELL	= /bin/sh
CFLAGS	=

DESTDIR	= ELISYS

# Relative pathname for the current directory
DIR	= Tool/gla

COFLAGS	= -q

SUBDIR=	nflex frontend backend

SYS	= gla.h gla.err separator dfltscan.c CchStr.c Ccomment.c \
	  M2chStr.c M2int.c M3comment.c auxScanEOL.c \
	  pascalCom.c pascalStr.c
AUX	= gla.dg lit.dg lex.tnf
CMD	= dflt_codes.cmd gla_be.cmd gla_out.cmd flex_out.cmd gla_fe.cmd \
	  scan.c.cmd scan_c.cmd scan_spec.cmd lit_out.cmd lit_gen.cmd
SRCS	= $(SYS) $(AUX) $(CMD)
EXE	= gla_fe gla_be flex

TIDY	= core a.out *.o ELI
CLEAN	= $(TIDY) gla_fe gla_be flex glahead.c glaDriver.c
CLOBBER = $(CLEAN) Makefile

all:	$(SRCS)
	@for f in $(CMD); do \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/$(DIR)/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SUBDIR); do echo; echo Making Tool/gla/$$f; (cd $$f; \
		make COFLAGS=$(COFLAGS) CC="$(CC)"); done 

install:
	@for f in $(CMD); do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/gla; \
		rm -f $(DESTDIR)/Tool/gla/$$f; \
		cp $$f $(DESTDIR)/Tool/gla/$$f; \
		chmod 644 $(DESTDIR)/Tool/gla/$$f; \
		rm -f $(DESTDIR)/Cmd/$$f; \
		ln -s $(DESTDIR)/Tool/gla/$$f $(DESTDIR)/Cmd/$$f; \
	done
	@for f in $(SYS) glahead.c; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/gla; \
		rm -f $(DESTDIR)/Tool/gla/$$f; \
		cp $$f $(DESTDIR)/Tool/gla/$$f; \
		chmod 644 $(DESTDIR)/Tool/gla/$$f; \
	done
	@for f in $(EXE); do \
		echo install -c -m 755 $$f $(DESTDIR)/Tool/gla; \
		rm -f $(DESTDIR)/Tool/gla/$$f; \
		cp $$f $(DESTDIR)/Tool/gla/$$f; \
		chmod 755 $(DESTDIR)/Tool/gla/$$f; \
	done

executable:
	rm -rf $(TIDY) Makefile Makefile.cpp $(SUBDIR) $(AUX)

SourceDistr:	$(SRCS)
	for i in $(SUBDIR); do echo; echo Source Tool/gla/$$i; mkdir $$i; \
		cd $$i; ln -s $(ELI)/$$i/RCS; co $(COFLAGS) Makefile.cpp; \
		make -u -f Makefile.cpp ELI=$(ELI)/$$i COFLAGS=$(COFLAGS) \
			SourceDistr; \
		rm RCS; cd ..; done

distr:	clean
	tar cf ../GLA.tar C* Makefile.cpp README T* bootstrap \
	    doc examples include lib misc nflex frontend backend 
	compress ../GLA.tar

tidy:
	rm -rf $(TIDY)
	-@for i in $(SUBDIR); do echo; echo Tidying Tool/gla/$$i; cd $$i; \
		make tidy; cd ..; done

clean:
	rm -rf $(CLEAN)
	-@for i in $(SUBDIR); do echo; echo Cleaning Tool/gla/$$i; cd $$i; \
		make clean; cd ..; done

clobber:
	rm -rf $(CLOBBER)
	-@for i in $(SUBDIR); do echo; echo Clobbering Tool/gla/$$i; cd $$i; \
		make clobber; cd ..; done

rcsclean:
	-@for i in $(SUBDIR); do echo; echo RCScleaning Tool/gla/$$i; (cd $$i; \
		make COFLAGS=$(COFLAGS) rcsclean); done
	rm -rf $(CLEAN) Makefile
	-rcsclean $(COFLAGS) $(SRCS) Makefile.cpp

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp $(SRCS)
	-rcs -bOriginal.1 -q Makefile.cpp $(SRCS)
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q $(SRCS)

.PRECIOUS:	$(SRCS)
