/*
 * scan Modula-2 strings
 * Martin Husemann, 04.05.90
 */

#include "err.h"
#include "source.h"
#include "gla.h"

extern char* malloc();
static char *auxM2StringGeneric( );


/*
 * auxM2StringDQ
 * 
 * handle double quoted Modula-2 strings by calling auxM2StringGeneric
 */

char *auxM2StringDQ( start, len )
char *start;
int  len;
{
 return auxM2StringGeneric(start, len, '"');
}



/*
 * auxM2StringSQ
 * 
 * handle double quoted Modula-2 strings by calling auxM2StringGeneric
 */

char *auxM2StringSQ( start, len )
char *start;
int  len;
{
  return auxM2StringGeneric(start, len, '\'');
}


/*
 * auxM2StringGeneric
 *
 * Scan a string literal after the opening quote.
 *
 * On entry, start points to the opening quote, len should be 1.
 * On exit, we return the position after the closing quote.
 */
static char *auxM2StringGeneric( start, len, quote )
char *start;	/* used subtly - see below */
int  len;
char quote;
{
        register char c ;
        register char *p = start + len;

	/* three possible conditions can stop the loop */
top:	while( (c = *p++) && c != quote && c != '\n' )
		;

	/*
	** String is finished
	*/
	if(c == quote) return p;

	/*
	** We hit end of line
	*/
	else if(c == '\n') {
		LineNum++;
		StartLine = p - 1;
		message(ERROR, "illegal newline in string literal", 0, &curpos);
		return p;
	}


	/*
	** We hit EOB or EOF and still have not finished finding string -
	*/
	else /* if (c == '\0') */ {
		refillBuf( p-1 );
		start = p = TokenEnd; /* reset start so next copy will work */
		if (*p == '\0') {
			message(ERROR,"file ends in literal string",0,&curpos);
			return p;
			}
		else
			goto top;	/* continue scanning string */
        }/*end else*/
}/*auxM2StringGeneric*/


