# $Id: Makefile.cpp,v 1.15 1992/06/25 23:18:05 waite Exp $
# Scanner example

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR = ../../..

COFLAGS	= -q

SPECS	= token.specs c.gla
DERIVE  = derive
EXTRAS  = $(DERIVE) input

TIDY	= ERRS a.out core *.o *.a ELI
CLEAN	= $(TIDY) *.exe

all:	scan.exe 

scan.exe:	ELI $(SPECS) $(EXTRAS)
	if test '$(DESTDIR)' = ''; \
	then (DUMPCORE=yes ../../../bin/eli -c ELI <$(DERIVE)); \
	else (DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <$(DERIVE)); \
	fi

install:
	@for f in $(SPECS) $(EXTRAS) Makefile; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/examples/scanner ; \
		rm -f $(DESTDIR)/Tool/examples/scanner/$$f; \
		cp $$f $(DESTDIR)/Tool/examples/scanner ; \
		chmod 644 $(DESTDIR)/Tool/examples/scanner/$$f; \
		done

executable:
	rm -rf $(CLEAN) Makefile.cpp

test:	scan.exe input
	./scan.exe input

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

ELI:
	if test '$(DESTDIR)' = ''; \
	then ../../../bin/eli -c ../../.. -n ELI -q; \
	else $(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q; \
	fi
