# $Id: Makefile.cpp,v 1.18 1992/06/24 23:28:19 waite Exp $
# Scoping of identifiers in LIGA.

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR = ../../..

SPECS 	= lscope.head lscope.pdl lscope.sym lscope.c lscope.gla lscope.specs \
	lscope.con lscope.lido lscope.h
EXTRAS	= derive input result lscope.tex

TIDY	= ERRS a.out core *.o *.a ELI
CLEAN	= $(TIDY) *.exe

all:	ELI $(SPECS) $(EXTRAS)
	if test '$(DESTDIR)' = ''; \
	then (DUMPCORE=yes ../../../bin/eli -c ELI <derive); \
	else (DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <derive); \
	fi

install:
	@for f in $(SPECS) $(EXTRAS) Makefile; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/examples/liga-scope; \
		rm -f $(DESTDIR)/Tool/examples/liga-scope/$$f; \
		cp $$f $(DESTDIR)/Tool/examples/liga-scope; \
		chmod 644 $(DESTDIR)/Tool/examples/liga-scope/$$f; \
		done

executable:
	rm -rf $(CLEAN) Makefile.cpp

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

ELI:
	if test '$(DESTDIR)' = ''; \
	then ../../../bin/eli -c ../../.. -n ELI -q; \
	else $(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q; \
	fi
