# $Id: Makefile.cpp,v 1.4 1992/06/24 23:28:19 waite Exp $
# Pascal scanner/parser example

SHELL	= /bin/sh
CFLAGS	=

# Location of the master cache
DESTDIR = ../../..

SPECS	= pascal.con pascal.gla pident.gla struct.specs
EXTRAS	= derive input

TIDY	= ERRS a.out core *.o *.a ELI pcode
CLEAN	= $(TIDY) *.exe src

all:	ELI $(SPECS) $(EXTRAS) src
	if test '$(DESTDIR)' = ''; \
	then (DUMPCORE=yes ../../../bin/eli -c ELI <derive); \
	else (DUMPCORE=yes $(DESTDIR)/bin/eli -c ELI <derive); \
	fi
	cd src; make; ./*.exe ../input

install:
	@for f in $(SPECS) $(EXTRAS) Makefile; do \
		echo install -c -m 644 $$f $(DESTDIR)/Tool/examples/ignorecase ; \
		rm -f $(DESTDIR)/Tool/examples/ignorecase/$$f; \
		cp $$f $(DESTDIR)/Tool/examples/ignorecase ; \
		chmod 644 $(DESTDIR)/Tool/examples/ignorecase/$$f; \
		done

executable:
	rm -rf $(CLEAN) Makefile.cpp

tidy:
	rm -rf $(TIDY)

clean:
	rm -rf $(CLEAN)

ELI:
	if test '$(DESTDIR)' = ''; \
	then ../../../bin/eli -c ../../.. -n ELI -q; \
	else $(DESTDIR)/bin/eli -c $(DESTDIR) -n ELI -q; \
	fi

src:
	mkdir src
