# $Id: Makefile.cpp,v 1.41 1992/07/06 19:18:09 waite Exp $
# Copyright (c) 1989, The Regents of the University of Colorado

SHELL	= /bin/sh
CFLAGS	=

# Default to the current directory as the master cache
DESTDIR	=

# Programs that live in subdirectories, and have makefiles of their own.
SUBDIR  = digitcalc ignorecase intgcalc liga-opid liga-postfix liga-scope \
	normexp parenexp scanner wordcount clp genlido

# Make the default co quiet.
COFLAGS = -q

TIDY	= core a.out *.o ERRS
CLEAN	= $(TIDY) *.exe
CLOBBER	= $(CLEAN) Makefile

all:
	@for i in $(SUBDIR); do echo; echo Making Tool/examples/$$i; \
		DESTDIR='$(DESTDIR)' export; \
		(cd $$i; make CC='$(CC)' DESTDIR="$$DESTDIR" all); \
		done

install:
	-@for i in $(SUBDIR); do \
		if test ! -d $(DESTDIR)/Tool/examples/$$i; \
			then umask 002; mkdir $(DESTDIR)/Tool/examples/$$i; \
			else :; \
			fi; \
		done
	@for i in $(SUBDIR); do echo; echo Installing Tool/examples/$$i; \
		DESTDIR=$(DESTDIR) export; \
		(cd $$i; make DESTDIR=$$DESTDIR install); \
		done
	rm -f $(DESTDIR)/Tool/examples/Makefile
	cp Makefile $(DESTDIR)/Tool/examples/Makefile
	chmod 644 $(DESTDIR)/Tool/examples/Makefile

executable:
	@for i in $(SUBDIR); do \
		echo " "; echo Making Tool/examples/$$i executable; \
		(cd $$i; make executable); done
	rm -rf $(TIDY) $(PASDLT) Makefile.cpp

SourceDistr:
	@for i in $(SUBDIR); do echo; echo Source Tool/examples/$$i; \
		mkdir $$i; (cd $$i; \
		ln -s $(ELI)/$$i/RCS; co $(COFLAGS) Makefile.cpp; \
		make -u -f Makefile.cpp ELI=$(ELI)/$$i COFLAGS=$(COFLAGS) \
			SourceDistr; \
		rm RCS); done

tidy:
	rm -rf $(TIDY)
	@for i in $(SUBDIR); do echo; echo Tidying Tool/examples/$$i; \
		(cd $$i; make tidy); done

clean:
	rm -rf $(CLEAN)
	@for i in $(SUBDIR); do echo; echo Cleaning Tool/examples/$$i; \
		(cd $$i; make clean); done

clobber:
	rm -rf $(CLOBBER)
	@for i in $(SUBDIR); do echo; echo Clobbering Tool/examples/$$i; \
		(cd $$i; make clobber); done

rcsclean:
	@for i in $(SUBDIR); do echo; echo RCScleaning Tool/examples/$$i; \
		(cd $$i; make rcsclean COFLAGS=$(COFLAGS)); done
	-rcsclean $(COFLAGS) Makefile.cpp
	rm -rf $(CLEAN) Makefile

save:
	-mkdir RCS
	-ci -k -t/dev/null -nOriginal -u -q Makefile.cpp
	-rcs -bOriginal.1 -q Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q -u Makefile.cpp
	-ci -fOriginal.1 -m/dev/null -q
	@for i in $(SUBDIR); do echo; echo Saving Tool/examples/$$i; \
		cd $$i; make save; cd ..; done
