static char rcsid[] = "$Id: rdsymb.c,v 1.5 1992/06/22 21:20:50 waite Exp $";
/* a.out module */

#include "symbinfo.h"
#include "system.h"

/***/
void
read_symbols(file_name)
char *file_name;
/* Obtain symbol information
 *    On entry-
 *       file_name=file from which to obtain the symbols
 *    On exit-
 *       SymbolInfo(symbol,external) has been invoked for each symbol
 ***/
{
#ifdef mips
  int i;
  SYMR sym;
  LDFILE *ex_file;
  
  ex_file = ldopen (file_name, NULL);
  if (ex_file == NULL) {
    (void)fprintf (stderr, "Cannot open file %s to read symbol table\n",
       file_name);
    exit (1);
  }
  
  for (i = 0; i < SYMHEADER (ex_file).isymMax + SYMHEADER (ex_file).iextMax;
       i++) {
    if (ldtbread (ex_file, i, &sym)) {
      if ((sym.st == stGlobal || sym.st == stProc ||
          sym.st == stStatic || sym.st == stStaticProc ||
          sym.st == stLabel) && (sym.sc != scNil))
        SymbolInfo(ldgetname (ex_file, &sym),
              sym.sc == scUndefined ||
              sym.sc == scSUndefined);
    } else
      (void)fprintf (stderr, "Cannot read symbol %d\n", i);
  }
  ldclose (ex_file);
#endif

#ifdef _AIX
  int i;
  SYMENT sym;
  LDFILE *ex_file;
  
  ex_file = ldopen (file_name, NULL);
  if (ex_file == NULL) {
    (void)fprintf (stderr, "Cannot open file %s to read symbol table\n",
           file_name);
    exit(1);
  }
  
  for (i = 0; i < HEADER (ex_file).f_nsyms; i++) {
    if (ldtbread (ex_file, i, &sym) == SUCCESS) {
      if (sym.n_sclass == C_EXT) {
        extern char *ldgetname ();
        char *s = ldgetname (ex_file, &sym); 
        if (*s == '.') s++;
        SymbolInfo(s, !sym.n_value);
      }
    } else
      (void)fprintf (stderr, "Cannot read symbol %d\n", i);
  }
  ldclose (ex_file);
#endif

#if defined(sun)
  int fd;
  struct exec header;
  struct nlist *symbol_table;
  int number_symbols;
  int string_table_size;
  char *string_table;
  int i;
    
  if ((fd = open (file_name, O_RDONLY, 0)) == -1) {
    (void)fprintf (stderr, "Cannot open executable: %s\n", file_name);
    exit(1);
  }
  if (read (fd, (char *)&header, sizeof (struct exec)) != sizeof (struct exec))
    (void)fprintf (stderr, "Cannot read exec header: %s\n", file_name);
  if (lseek (fd, (long)N_SYMOFF (header), L_SET) == -1)
    (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
  symbol_table = (struct nlist *) malloc ((unsigned)header.a_syms);
  if (read (fd, (char *)symbol_table, (int)header.a_syms) != header.a_syms)
    (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
  if (read (fd, (char *)&string_table_size, sizeof (int)) != sizeof (int))
    (void)fprintf (stderr, "Cannot read string table: %s\n", file_name);
  string_table = (char *) malloc ((unsigned)string_table_size);
  if (read (fd, (char *)string_table + sizeof(int), string_table_size - sizeof(int))
      != string_table_size - sizeof (int))
    (void)fprintf (stderr, "Cannot read string table: %s\n", file_name);
  
  number_symbols = header.a_syms / sizeof (struct nlist);
  for (i = 0; i < number_symbols; i++) {
    if (symbol_table[i].n_type & N_EXT)
      SymbolInfo(string_table + symbol_table[i].n_un.n_strx,
        (symbol_table[i].n_type == N_EXT)
        && !symbol_table[i].n_value);
  }
  free ((char *)symbol_table);
  free ((char *)string_table);
  (void)close (fd);
#endif

#if defined(vax)
  int fd;
  struct exec header;
  struct nlist *symbol_table;
  int number_symbols;
  int string_table_size;
  char *string_table;
  int i;
    
  if ((fd = open (file_name, O_RDONLY, 0)) == -1) {
    (void)fprintf (stderr, "Cannot open executable: %s\n", file_name);
    exit(1);
  }
  if (read (fd, (char *)&header, sizeof (struct exec)) != sizeof (struct exec))
    (void)fprintf (stderr, "Cannot read exec header: %s\n", file_name);
  if (lseek (fd, (off_t)N_SYMOFF (header), SEEK_SET) == -1)
    (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
  symbol_table = (struct nlist *) malloc ((unsigned)header.a_syms);
  if (read (fd, (char *)symbol_table, (int)header.a_syms) != header.a_syms)
    (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
  if (read (fd, (char *)&string_table_size, sizeof (int)) != sizeof (int))
    (void)fprintf (stderr, "Cannot read string table: %s\n", file_name);
  string_table = (char *) malloc ((unsigned)string_table_size);
  if (read (fd, (char *)string_table + sizeof(int), string_table_size - sizeof(int))
      != string_table_size - sizeof (int))
    (void)fprintf (stderr, "Cannot read string table: %s\n", file_name);
  
  number_symbols = header.a_syms / sizeof (struct nlist);
  for (i = 0; i < number_symbols; i++) {
    if (symbol_table[i].n_type & N_EXT)
      SymbolInfo(string_table + symbol_table[i].n_un.n_strx,
        (symbol_table[i].n_type == N_EXT)
        && !symbol_table[i].n_value);
  }
  free ((void *)symbol_table);
  free ((void *)string_table);
  (void)close (fd);
#endif

#if defined(hpux)
#ifdef __hp9000s800
  int fd;
  FILHDR head;
  SYMENT symbol;
  char *symbol_strings;
  int count;
    
  if ((fd = open (file_name, O_RDONLY, 0)) == -1) {
    (void)fprintf (stderr, "Cannot open executable: %s\n", file_name);
    exit(1);
  }
  if (read (fd, (char *)&head, FILHSZ) != FILHSZ) {
    (void)fprintf (stderr, "Cannot read header: %s\n", file_name);
    exit(1);
  }

  if (lseek (fd, (off_t)(head.symbol_strings_location), SEEK_SET) == -1) {
    (void)fprintf (stderr, "Cannot find symbol strings: %s\n", file_name);
    exit(1);
  }
  symbol_strings = (char *) malloc ((unsigned)head.symbol_strings_size);
  if (read (fd, (char *)symbol_strings, (size_t)head.symbol_strings_size) != head.symbol_strings_size) {
    (void)fprintf (stderr, "Cannot read symbol strings: %s\n", file_name);
    exit(1);
  }
  
  if (lseek (fd, (off_t)(head.symbol_location), SEEK_SET) == -1) {
    (void)fprintf (stderr, "Cannot find symbol table: %s\n", file_name);
    exit(1);
  }
  for (count = 1; count <= head.symbol_total; count++) {
    if (read (fd, (char *)&symbol, SYMESZ) != SYMESZ) {
      (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
      exit(1);
    }
    if (symbol.symbol_type == ST_CODE ||
        symbol.symbol_type == ST_DATA ||
        symbol.symbol_type == ST_ENTRY) {
      if (symbol.symbol_scope == SS_UNSAT)
        SymbolInfo(symbol_strings+symbol.name.n_strx, 1);
      if (symbol.symbol_scope == SS_UNIVERSAL)
        SymbolInfo(symbol_strings+symbol.name.n_strx, 0);
    }
  }
    
  free ((void *)symbol_strings);
  (void)close (fd);
#else
  int fd;
  struct exec header;
  char *symbol_table, *syms, *symbol_limit;
  struct nlist_ *nl;
  char buf[257];
    
  if ((fd = open (file_name, O_RDONLY, 0)) == -1)
    (void)fprintf (stderr, "Cannot open executable: %s\n", file_name);
  if (read (fd, (char *)&header, sizeof (struct exec)) != sizeof (struct exec))
    (void)fprintf (stderr, "Cannot read exec header: %s\n", file_name);
  if (lseek (fd, (off_t)(LESYM_OFFSET(header)), SEEK_SET) == -1)
    (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
  symbol_table = (char *) malloc ((unsigned)header.a_lesyms);
  if (read (fd, (char *)symbol_table, (size_t)header.a_lesyms) != header.a_lesyms)
    (void)fprintf (stderr, "Cannot read symbol table: %s\n", file_name);
  symbol_limit = symbol_table + header.a_lesyms;
  
  for (syms = symbol_table; syms < symbol_limit;) {
    nl = (struct nlist_ *)syms;
    (void)strncpy (buf, ((char *)nl) + sizeof (struct nlist_), 
       (size_t)(nl->n_length));
    buf[nl->n_length] = '\0';
    SymbolInfo(buf, (nl->n_type == N_EXT) && !nl->n_value); 
    syms += sizeof (struct nlist_) + nl->n_length;
  }
    
  free ((void *)symbol_table);
  (void)close (fd);
#endif
#endif
}
