static char rcsid[] = "$Id: deftbl.c,v 1.2 1992/08/01 17:16:10 waite Exp $";
/* Property list module */

#include <stdlib.h>
#include "err.h"
#include "deftbl.h"

#define false 0
#define true 1

/***/
DefTableKey
NewKey()
/* Establish a new definition
 *    On exit-
 *       NewKey=Unique definition table key
 ***/
{
   DefTableKey CurrDef;

   if (CurrDef = (DefTableKey)malloc(sizeof(Entry))) {
      if (CurrDef->PropList = (Entry)malloc(sizeof(struct PropElt))) {
         CurrDef->PropList->selector = 0;
         return CurrDef;
      }
   }
   message(DEADLY, "NewKey: malloc failure", 0, (POSITION *)NULL);
   return NoKey;
}

/***/
int
find(key, p, r, add)
DefTableKey key; int p; Entry *r; int add;
/* Obtain a relation for a specific property of a definition
 * On entry-
 *    key=definition whose property relation is to be obtained
 *    p=selector for the desired property
 * If the definition does not have the desired property then on exit-
 *    find=false
 *    if add != 0 then r points to a new entry of size add for the property
 *    else r points to the entry following the entry for the property
 * Else on exit-
 *    find=true
 *    r points to the current entry for the property
 ***/
{
   register Entry *b,t;

   if (key == NoKey) return false;
   b = &key->PropList; t = *b;
   while (t->selector > p) { b = &t->next; t = *b; }
   *r = t;
   if (t->selector == p) return true;
   if (add) {
      register Entry new;
      if (!(new = (Entry)malloc((unsigned)add)))
         message(DEADLY, "find: malloc failure", 0, (POSITION *)NULL);
      new->next = t; new->selector = p;
      *r = *b = new;
   }
   return false;
}
