#!/bin/sh
# $Id: cpp_specs.cmd,v 1.12 1992/07/02 22:08:06 kadhim Exp $
# Copyright, 1989, The Regents of the University of Colorado

#cpp_specs <
#  definition(.none) "Complete set of files making up a definition"
#  lib.dir(.none) "Directly included libraries"*
#  > "Specification file after pre-processing"* :
#	USER
#		: specs
#		: (:specs :incl.all)

# This script runs in the user's directory.  Cpp should also search the Tool
# directory of the cache.  The result of cpp has to be cleaned up by:
#	1) Removing all white space
#	2) Prefixing the name of each specification file by the name of the
#		directory containing the file introducing it
#	3) Removing all remaining cpp information

/lib/cpp -I(|$/Tool|) (|<specs|) \
	| (|$/Tool/cpp_specs.exe|) (|$|) \
	> (|<RUNDIR|)/names

# The files making up the definition have names NOT ending in ".lib"

grep -v '\.lib$' (|<RUNDIR|)/names > (|>definition|)
echo (|<specs|) >> (|>definition|)
cat (|<(:specs :incl.all)|) >> (|>definition|)

# Extract the library specifications, throw away any path name associated
# with them, and construct the name of the corresponding specification
# file.

cp /dev/null (|>lib.dir|)
for f in `grep '\.lib$' (|<RUNDIR|)/names`
do
	name=`basename $f .lib`
	echo '(|$/Tool|)/'$name/$name'.specs' >> (|>lib.dir|)
done

exit 0
