#define	DUMMY	0

typedef	enum {	P_CODE, P_STOP, P_SEPA, P_BRACKET, P_SKIP,  /*for terminals*/
		P_GRAMMAR, P_CONNECT, P_REDUCE, P_NOREDUCE  /*for others*/
} proptype;

typedef	enum {	ALT, OPT, PLUS, STAR, DELREP
} ebnftype;

/* the following functions can be classified in four categories. Three
 * of them are associated with one CHAIN (symb, unknown, list):
 *	0. Associated with no chain: functions for output and others
 *
 *	1. CHAIN symb: It collects all Symbols and is used to build up
 *		the COMAR symbol table.
 *	2. CHAIN unknown: Starting with the initialization of the internal
 *		symbol table TAB it collects all objects with their
 *		properties. At the end all objects are classified in
 *		terminals, nonterminals and others and inserted in the
 *		COMAR-definitiontable.
 *	3. CHAIN list: It inserts the productions in the
 *		COMAR-definitiontable.
 */


/*--------------------------------------------------------------------*/
/* CATEGORIE 0: functions for inserting property names and for output */
/*--------------------------------------------------------------------*/

#define	get_str(id)	(string[id])
extern	void	write_results();


/*---------------------------------------------------*/
/* CATEGORIE 1: functions used to compute CHAIN symb */
/*---------------------------------------------------*/

extern	SID	ins_property_name(/* proptype prop */);
extern	SID	ins_symbol(/* String str */);

/*------------------------------------------------------*/
/* CATEGORIE 2: functions used to compute CHAIN unknown */
/*------------------------------------------------------*/

extern	void	init_internal_sid_tab();

extern	void	ins_term(/*SID symb, POSITION pos*/);

extern	void	ins_nonterm(/*SID symb, POSITION pos*/);

extern	void	ins_unknown(/*SID symb*/);

extern	void	ins_meta(/*SID symb, POSITION pos, SEQunit list*/);

extern	void	ins_termlist(/*void list*/);

extern	void	ins_term_with_prop(/*SID symb, POSITION pos,
						proptype prop, int propval*/);

extern	void	ins_other_with_prop(/*SID symb, POSITION pos, proptype prop*/);



/*---------------------------------------------------*/
/* CATEGORIE 3: functions used to compute CHAIN list */
/*---------------------------------------------------*/

extern	SEQunit	ins_prod(/* SID name, lhs; SEQunit rhs */);

extern	SEQunit	make_list(/* SEQunit l1, l2; ebnftype opr */);

extern	SEQunit	make_elem_for_others(/* SID symb; proptype el_mode */);

extern	SEQunit	make_elem(/* SID symb */);


#define	nullMETAunit()	((SEQunit)NULL)
#define	creatMETAunit(a)	(a)
extern	SEQunit   concatMETAunit(/* SEQunit l1, l2 */);
