
#include <stdio.h>
#ifndef MACH
#include <malloc.h>
#else
extern void *malloc(unsigned);
extern void free(void *);
#endif
#include "ptg_gen.h"

void _PrPTGNULL(n)
_PPTG0 n;{/* function printing nothing */}

static struct _SPTG0   _PTGNULL = { _PrPTGNULL };
PTGNode PTGNULL =  & _PTGNULL;

#define MEMERR\
	{ fprintf(stderr, "Fatal ERROR: no memory available.\n"); exit(1); }

static FILE *f;

PTGNode PTGOut (r)
PTGNode r;
{
  f = stdout;
  if (r) (* (r->_print)) (r);
  return (r);
}

PTGNode PTGOutFile (fn, r)
char * fn; PTGNode r;
{
  if ((f = fopen(fn, "w"))  == (FILE *)NULL)
  {
	fprintf(stderr, "ERROR: PTGOutFile: output file '%s' can't be opened.\n",fn);
	exit(1);
  }
  if (r) (* (r->_print)) (r);
  fclose(f);
  return (r);
}

PTGNode PTGOutFPtr(fptr, r)
FILE * fptr; PTGNode r;
{
  if ((f = fptr) == (FILE *)NULL)
  {
    fprintf(stderr, "ERROR: PTGOutFPtr: output file not open.\n");
    exit(1);
  }
  if (r) (* (r->_print)) (r);
  return (r);
}

typedef struct _SPTG2 *_PPTG2;
struct _SPTG2{
  _PTGProc _print;
  PTGNode _desc [2];
};

typedef struct _SPTG1 *_PPTG1;
struct _SPTG1{
  _PTGProc _print;
  PTGNode _desc [1];
};

typedef struct _SPTGzahl *_PPTGzahl;
struct _SPTGzahl{
  _PTGProc _print;
  int _t0;
};

void _PrPTGhbl(n)
_PPTG0 n;
{
  fputs ("-hbl", f);
}

void _PrPTGdgd(n)
_PPTG0 n;
{
  fputs ("-dgd", f);
}

void _PrPTGmp(n)
_PPTG0 n;
{
  fputs ("-mp", f);
}

void _PrPTGcre(n)
_PPTG0 n;
{
  fputs ("-cre", f);
}

void _PrPTGlp(n)
_PPTG0 n;
{
  fputs ("-lp", f);
}

void _PrPTGnoc(n)
_PPTG1 n;
{
  fputs ("-noc ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGnosa(n)
_PPTG1 n;
{
  fputs ("-nosa ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGdfs(n)
_PPTG0 n;
{
  fputs ("-dfs", f);
}

void _PrPTGscc(n)
_PPTG0 n;
{
  fputs ("-scc", f);
}

void _PrPTGcc(n)
_PPTG0 n;
{
  fputs ("-cc", f);
}

void _PrPTGdum(n)
_PPTG0 n;
{
  fputs ("-dum", f);
}

void _PrPTGsrc(n)
_PPTG0 n;
{
  fputs ("-src", f);
}

void _PrPTGirc(n)
_PPTG0 n;
{
  fputs ("-irc", f);
}

void _PrPTGdsc(n)
_PPTG0 n;
{
  fputs ("-dsc", f);
}

void _PrPTGlo(n)
_PPTG1 n;
{
  fputs ("-lo ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGaec(n)
_PPTG0 n;
{
  fputs ("-aec", f);
}

void _PrPTGcl(n)
_PPTG0 n;
{
  fputs ("-cl", f);
}

void _PrPTGqz(n)
_PPTG1 n;
{
  fputs ("-qz ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGsz(n)
_PPTG1 n;
{
  fputs ("-sz ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGzahl(n)
_PPTGzahl n;
{
  fprintf (f, "%d",n->_t0);
}

void _PrPTGseq(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs (" ", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGoptinfo(n)
_PPTG0 n;
{
  fputs ("OPT_INFO", f);
}

void _PrPTGttab(n)
_PPTG1 n;
{
  fputs ("T_TAB ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGntab(n)
_PPTG1 n;
{
  fputs ("N_TAB ", f);
  (* (n->_desc [0]->_print))(n->_desc[0]);
}

void _PrPTGmode_gcsa(n)
_PPTG0 n;
{
  fputs ("GCSA", f);
}

void _PrPTGmode_gcsb(n)
_PPTG0 n;
{
  fputs ("GCSB", f);
}

void _PrPTGmode_lesa(n)
_PPTG0 n;
{
  fputs ("LESA", f);
}

void _PrPTGmode_lesb(n)
_PPTG0 n;
{
  fputs ("LESB", f);
}

void _PrPTGmode_rcsa(n)
_PPTG0 n;
{
  fputs ("RCSA", f);
}

void _PrPTGmode_rcsb(n)
_PPTG0 n;
{
  fputs ("RCSB", f);
}

void _PrPTGmode_sds(n)
_PPTG0 n;
{
  fputs ("SDS", f);
}

void _PrPTGmode_rds(n)
_PPTG0 n;
{
  fputs ("RDS", f);
}

void _PrPTGline(n)
_PPTG2 n;
{
  (* (n->_desc [0]->_print))(n->_desc[0]);
  fputs ("\n", f);
  (* (n->_desc [1]->_print))(n->_desc[1]);
}

void _PrPTGinfo(n)
_PPTG0 n;
{
  fputs ("ALL_STATES", f);
}

void _PrPTGfreepos(n)
_PPTG0 n;
{
  fputs ("FREE_POS", f);
}

void _PrPTGaecfile(n)
_PPTG0 n;
{
  fputs ("#ifndef _ERROR_OFF\n", f);
  fputs ("#define _ERROR_OFF\n", f);
  fputs ("#endif\n", f);
}

PTGNode PTGhbl()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGhbl;
  return ((PTGNode) n);
}

PTGNode PTGdgd()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGdgd;
  return ((PTGNode) n);
}

PTGNode PTGmp()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmp;
  return ((PTGNode) n);
}

PTGNode PTGcre()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGcre;
  return ((PTGNode) n);
}

PTGNode PTGlp()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGlp;
  return ((PTGNode) n);
}

PTGNode PTGnoc(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGnoc;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGnosa(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGnosa;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGdfs()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGdfs;
  return ((PTGNode) n);
}

PTGNode PTGscc()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGscc;
  return ((PTGNode) n);
}

PTGNode PTGcc()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGcc;
  return ((PTGNode) n);
}

PTGNode PTGdum()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGdum;
  return ((PTGNode) n);
}

PTGNode PTGsrc()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGsrc;
  return ((PTGNode) n);
}

PTGNode PTGirc()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGirc;
  return ((PTGNode) n);
}

PTGNode PTGdsc()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGdsc;
  return ((PTGNode) n);
}

PTGNode PTGlo(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGlo;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGaec()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGaec;
  return ((PTGNode) n);
}

PTGNode PTGcl()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGcl;
  return ((PTGNode) n);
}

PTGNode PTGqz(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGqz;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGsz(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGsz;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGzahl(_t0)
  int _t0;
{
  _PPTGzahl n;

  if ((n = (_PPTGzahl) malloc (sizeof (struct _SPTGzahl)))  ==  (_PPTGzahl)NULL)
	MEMERR
  n->_print = _PrPTGzahl;
  n->_t0=_t0;
  return ((PTGNode) n);
}

PTGNode PTGseq(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGseq;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGoptinfo()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGoptinfo;
  return ((PTGNode) n);
}

PTGNode PTGttab(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGttab;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGntab(_t0)
PTGNode _t0;
{
  _PPTG1 n;

  if ((n = (_PPTG1) malloc (sizeof (struct _SPTG1)))  ==  (_PPTG1)NULL)
	MEMERR
  n->_print = _PrPTGntab;
  n->_desc[0]=_t0;
  return ((PTGNode) n);
}

PTGNode PTGmode_gcsa()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_gcsa;
  return ((PTGNode) n);
}

PTGNode PTGmode_gcsb()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_gcsb;
  return ((PTGNode) n);
}

PTGNode PTGmode_lesa()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_lesa;
  return ((PTGNode) n);
}

PTGNode PTGmode_lesb()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_lesb;
  return ((PTGNode) n);
}

PTGNode PTGmode_rcsa()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_rcsa;
  return ((PTGNode) n);
}

PTGNode PTGmode_rcsb()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_rcsb;
  return ((PTGNode) n);
}

PTGNode PTGmode_sds()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_sds;
  return ((PTGNode) n);
}

PTGNode PTGmode_rds()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGmode_rds;
  return ((PTGNode) n);
}

PTGNode PTGline(_t0,_t1)
PTGNode _t0,_t1;
{
  _PPTG2 n;

  if ((n = (_PPTG2) malloc (sizeof (struct _SPTG2)))  ==  (_PPTG2)NULL)
	MEMERR
  n->_print = _PrPTGline;
  n->_desc[0]=_t0;
  n->_desc[1]=_t1;
  return ((PTGNode) n);
}

PTGNode PTGinfo()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGinfo;
  return ((PTGNode) n);
}

PTGNode PTGfreepos()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGfreepos;
  return ((PTGNode) n);
}

PTGNode PTGaecfile()
{
  _PPTG0 n;

  if ((n = (_PPTG0) malloc (sizeof (struct _SPTG0)))  ==  (_PPTG0)NULL)
	MEMERR
  n->_print = _PrPTGaecfile;
  return ((PTGNode) n);
}

