/*
** $Id: propoutp.c,v 1.2 90/10/23 14:43:43 cogito Exp $
*/
static char rcs_id[]= "$Id: propoutp.c,v 1.2 90/10/23 14:43:43 cogito Exp $";

#include <stdio.h>
#include "ccomar.h"
#include "ccomarl.h"
#include "propoutp.h"

#define BLANKS(f,l) { int i; \
		      for (i=0; i<l; i++) \
			fprintf(f, " "); }

int cmrtl_write_property(f, c, did, sid)
FILE *f;
tCOMAR *c;
DID did;
SID sid;
{
tCOMAR *prop;
SID sidofdid;
int stat;

  if ((prop = cmr_get_prop(c, did, sid)) == (tCOMAR *)NULL)
	return(CMR_UNKERR);

  sidofdid = cmr_get_def_entry_sid(c, did);
  if (cmr_get_symb_entry_tag(c, sidofdid) == P_NAME)
    /*then */ 
    fprintf(f, "%s %s :\n", cmrl_didtosymb(c,did), cmrl_sidtosymb(c,sid));
  else
    fprintf(f, "\'%s\' %s :\n", cmrl_didtosymb(c,did), cmrl_sidtosymb(c,sid));

  if (cmr_get_prop_tag(prop) == P_PROP_VAL)
  {
    if ((stat = cmrtl_write_prop_tree(f, c, cmr_get_prop_val(prop), 0))
	 != CMR_SUCCESS)
      return(stat);
    fprintf(f, "\n\n\n");
  }

  return(CMR_SUCCESS);
}


int cmrtl_write_prop_tree(f, c, tree, l)
FILE *f;
tCOMAR *c, *tree;
int l;
{
SID sid;
DID did;

  if (tree == (tCOMAR *)NULL)
    return(CMRTL_WRTPROPERR);

  else
    switch (cmr_get_tag(tree)) {

    case P_LVAL  : 

#ifdef SINGLE
		   BLANKS(f,l);
		   fprintf(f, "(\n");
                   l += 2;
#else
		   fprintf(f, "( ");
#endif
                   return(cmrtl_write_prop_list(f, c, cmr_get_lval_list(tree), l));

    case P_DVAL  : did = cmr_get_dval_did(tree);
		   sid = cmr_get_def_entry_sid(c, did);
		   if (cmr_get_symb_entry_tag(c, sid) == P_STRING)
		   {

#ifdef SINGLE
		     BLANKS(f,l);
		     fprintf(f, "\'%s\'\n", cmrl_didtosymb(c, did));
#else
                     fprintf(f, "\'%s\' ", cmrl_didtosymb(c, did));
#endif
		   }
                   else
		   {

#ifdef SINGLE
		     BLANKS(f,l);
		     fprintf(f, "%s\n", cmrl_didtosymb(c, did));
#else
                     fprintf(f, "%s ", cmrl_didtosymb(c, did));
#endif
		   }
                   return(CMR_SUCCESS);
    case P_SVAL  : sid = cmr_get_sval_sid(tree);
		   if (cmr_get_symb_entry_tag(c, sid) == P_STRING)
		   {

#ifdef SINGLE
		     BLANKS(f,l);
		     fprintf(f, "\'%s\'\n", cmrl_sidtosymb(c,sid));
#else
		     fprintf(f, "\'%s\' ", cmrl_sidtosymb(c,sid));
#endif
		   }
                   else
		   {

#ifdef SINGLE
		     BLANKS(f,l);
		     fprintf(f, "%s\n", cmrl_sidtosymb(c,sid));
#else
		     fprintf(f, "%s ", cmrl_sidtosymb(c,sid));
#endif
		   }
                   return(CMR_SUCCESS);
    case P_NVAL  : 

#ifdef SINGLE
		   BLANKS(f,l);
		   fprintf(f, "%d\n", cmr_get_nval_val(tree));
#else
		   fprintf(f, "%d ", cmr_get_nval_val(tree));
#endif
		   return(CMR_SUCCESS);
    default      : return(CMRTL_WRTPROPERR);
    }

}



int cmrtl_write_prop_list(f, c, list, l)
FILE *f;
tCOMAR *c, *list;
int l;
{
  int stat;

  if (list == (tCOMAR *)NULL)
  {
#ifdef SINGLE
     l -= 2;
     BLANKS(f,l);
     fprintf(f, ")\n");
#else
     fprintf(f, ")");
#endif
    
    return(CMR_SUCCESS);
  }

  else
  {
    if ((stat = cmrtl_write_prop_tree(f, c, cmr_list_head(list), l))
	 != CMR_SUCCESS)
      return(stat);
    return(cmrtl_write_prop_list(f, c, cmr_list_tail(list), l));
  }
}

