/*
** $Id: first.h,v 1.2 90/10/23 14:41:52 cogito Exp $
*/

/******************************************************************/
/*                  FIRST and FOLLOW evaluation                   */
/******************************************************************/

#include "old_to_newcmr.h"

/* Definition of the property names that are appended to
 * first and followevaluation
 */

#define FIRST           "first"
#define FIRSTTRANSCLOS  "firsttransclos"
#define FOLLOW          "follow"
#define FOLTRANSCLOS    "followtransclos"
#define EOFSYMBOL       "$"
#define EOFPROP         "endofinput"


/* Errorcodes for the initialization of FOLLOW 
 * CMRTL_NOFOLINIT indicates that the followsets can not be initialized
 *            because the endmarker '$' already exists in the
 *            grammar
 */


#define CMRTL_NOFOLINIT  -12


/* Section 1 : Evaluation of FIRST */

/* Section 1.1 : primitive evaluation of a firstset */

/* cmrtl_first_on_dlist - returns the firstlist of list
 * on entry  : datastructure c,
 *             delimited list list
 * on exit   : if list does not begin with begin-node
 *               then ((tCOMAR *)NULL)
 *               else undelimited firstlist of list
 */
extern tCOMAR *cmrtl_first_on_dlist( /* tCOMAR *c, tCOMAR *list */ );


/* cmrtl_first_on_list - returns the firstlist of list
 * on entry  : datastructure c,
 *             undeliminted list list
 * on exit   : FIRST(1) of this list
 *             if list == (tCOMAR *)NULL then epsilon is returned
 */
extern tCOMAR *cmrtl_first_on_list( /* tCOMAR *c, tCOMAR *list */ ); 


/* cmrtl_first_on_subtr returns the firstlist of subtree subtr
 * on entry  : datastructure c,
 *             subtree of a production subtree
 * on exit   : if subtr == (tCOMAR *)NULL an empty list is returned
 *               else the firstlist of alt, opt, star, delrep or plus
 *               is evaluated
 *               the firstlist of a nonterminal will be evaluated
 *               unless it is evaluated
 */
extern tCOMAR *cmrtl_first_on_subtr( /* tCOMAR *c, tCOMAR *subtr */ );


/* cmrtl_first_for_nterm - returns the firstlist of nt
 * on entry  : datastructure c,
 *             nonterminal nt
 * on exit   : returns a pointer to the FIRST-propertylist
 *             of this nonterminal
 *             if the firstlist is not yet evaluated then
 *               the firstlist is processed and returned
 *             if there are no productions with lhs nt
 *               then (tCOMAR *)NULL is returned
 */
extern tCOMAR *cmrtl_first_for_nterm( /* tCOMAR *c, DID nt */ );


/* cmrtl_first_for_term - returns the firstproperty of term
 * on entry  : datastructure c,
 *             terminal term
 * on exit   : returns a pointer to the FIRST-property
 *             if there is no firstproperty for this term
 *               then it is evaluated
 */
extern tCOMAR *cmrtl_first_for_term( /* tCOMAR *c, DID term */ );


/* cmrtl_first_for_grammar - produces the firstlists for the whole grammar
 * on entry  : datastructure c
 * on exit   : processes the firstlists for all nonterminals and
 *             terminals
 *             returns CMR_SUCCESS if all firstlists could be 
 *             evaluated.
 *             otherwise return CMR_UNKERR
 */
extern int cmrtl_first_for_grammar( /* tCOMAR *c */ );


/* Section 1.2 : evaluation of the transitive closure of a
 *               firstset for a nonterminal
 */

/* cmrtl_first_trans_closure_for_nt - computes the transitive 
 *                   closure of the firstlist for the nonterminal nt
 * on entry  : datastructure c,
 *             nonterminal nt
 * on exit   : returns a pointer to the transitive closure
 *             firstlist.
 *             returns (tCOMAR *)NULL on error
 *               or if the transitive closure is being evaluated
 *             if FIRST is not yet evaluated for nt
 *               then it is invoked to be processed
 */
extern tCOMAR *cmrtl_first_trans_closure_for_nt( /* tCOMAR *c,
						    DID nt */ );


/* Section 1.3 : evaluation of a terminalized firstset for a
 *               nonterminal and for production trees
 */

/* cmrtl_first_for_nt_terminalized - computes the terminalized firstset for a 
 *                                           nonterminal
 * on entry : datastructure c
 *            nonterminal nt
 * on exit  : returns a pointer to a list with the terminalized firstset
 *            returns (tCOMAR *)NULL on error
 *            if FIRSTtransclosure is not yet evaluated for nt
 *              then it is invoked to be processed
 */
extern tCOMAR *cmrtl_first_for_nt_terminalized( /* tCOMAR *c,
                                                   DID nt */ );


/* cmrtl_first_on_dlist_terminalized - returns a firstlist containing 
 *                                     only terminalsymbols
 * on entry : datastructure c,
 *            a delimited list from a production tree
 * on exit  : the terminalized firstlist of the given dlist
 */
extern tCOMAR *cmrtl_first_on_dlist_terminalized( /* tCOMAR *c,
						     tCOMAR *dlist */ );


/* cmrtl_first_on_list_terminalized - returns a firstlist containing
 *                                    only terminalsymbols
 * on entry : datastructure c,
 *            an undelimited list from a production tree
 * on exit  : returns a terminalized firstlist of the given list
 */
extern tCOMAR *cmrtl_first_on_list_terminalized( /* tCOMAR *c,
						    tCOMAR *list */ );


/* cmrtl_first_on_subtr_terminalized - returns a firstlist containing
 *                                     only terminalsymbols
 * on entry : datastructure c,
 *            a subtree node
 * on exit  : returns a terminalized firstlist for this subtree
 */
extern tCOMAR *cmrtl_first_on_subtr_terminalized( /* tCOMAR *c,
						     tCOMAR *subtr */ );


/* Section 2 : evaluation of a new local followlist for some
 *             special subtree kinds
 */

/* cmrtl_new_localfollow_for_list - computes the local follow set for
 *                                  the given position in the list
 * on entry : datastructure c,
 *            an undelimited list list
 *            the actual localfollow locfol for this list
 * on exit  : returns a pointer to a terminalized firstlist
 *              the localfollowlist for the position list is computed
 */
extern tCOMAR *cmrtl_new_localfollow_for_list( /* tCOMAR *c,
					          tCOMAR *list,
						  tCOMAR *locfol */ );


/* cmrtl_new_localfollow_for_plus - computes the localfollowlist for plus
 * on entry : datastructure c, 
 *            subtree plus,
 *            the actual localfollow for this subtree
 * on exit  : returns a pointer to the terminalized localfollowlist for this
 *            subtree plus
 *            (tCOMAR *)NULL if subtree is not a plus subtree
 */
extern tCOMAR *cmrtl_new_localfollow_for_plus( /* tCOMAR *c,
						  tCOMAR *plus,
						  tCOMAR *locfol */ );


/* cmrtl_new_localfollow_for_star - computes the localfollowlist for star
 * on entry : datastructure c, 
 *            subtree star,
 *            the actual localfollow for this subtree 
 * on exit  : returns a pointer to the terminalized localfollowlist for this
 *            subtree star
 *            (tCOMAR *)NULL if subtree is not a star subtree
 */
extern tCOMAR *cmrtl_new_localfollow_for_star( /* tCOMAR *c, 
						  tCOMAR *star,
						  tCOMAR *locfol */ );


/* cmrtl_new_localfollow_for_delrep_units1 - computes the localfollowlist for 
 *                           delrep-units1
 * on entry : datastructure c,
 *            subtree delrep,
 *            the actual localfollow for this subtree 
 * on exit  : returns a pointer to the terminalized localfollowlist for
 *              the first component units1 of a delrep subtree
 *            (tCOMAR *)NULL if subtree is not a delrep subtree
 */
extern tCOMAR *cmrtl_new_localfollow_for_delrep_units1( /* tCOMAR *c,
							   tCOMAR *delrep,
							   tCOMAR *locfol */ );



/* cmrtl_new_localfollow_for_delrep_units2 - computes the localfollowlist for
 *                           delrep-units2
 * on entry : datastructure c, 
 *            subtree delrep,
 *            the actual localfollow for this subtree
 * on exit  : returns a pointer to the terminalized localfollowlist for 
 *              the second component units2 of a delrep subtree
 *            (tCOMAR *)NULL if subtree is not a delrep subtree
 */
extern tCOMAR *cmrtl_new_localfollow_for_delrep_units2( /* tCOMAR *c,
							   tCOMAR *delrep, 
							   tCOMAR *locfol */ );


/* Section 3 : evaluation of Follow  */

/* Section 3.1 : primitive evaluation of the followset for
 *               one special nonterminal
 */

/* cmrtl_follow_for_nterm - computes the local followlist for a nonterminal
 * on entry : datastructure c,
 *            (DID) nonterminal nt
 * on exit  : returns a pointer to the followlist of this nt
 *            returns((tCOMAR *)NULL)
 *              if an error occurs during computation
 *                or if the followlist is being computed
 */
extern tCOMAR *cmrtl_follow_for_nterm( /* tCOMAR *c, DID nt */ );



/* cmrtl_follow_on_prod_for_nt - computes the followlist for a nonterminal
 *                               in the specified production
 * on entry : datastructure c, 
 *            production prod,
 *            (DID) nonterminal nt
 * on exit  : if nt is not a member of the production-tree of prod
 *              then it returns((tCOMAR *)NULL)
 *            else it will return an undelimited local followlist
 *                 for the nonterminal nt
 */
extern void cmrtl_follow_on_prod_for_nt( /* tCOMAR *c, DID prod,
					       DID nt */ );


/* cmrtl_follow_on_dlist_for_nt - returns the local followlist for the
 *                                nonterminal nt in a deliminted list
 * on entry : datastructure c,
 *            delimited list dlist,
 *            (DID) nonterminal nt,
 * on exit  : if dlist does not begin with a begin node
 *              then it returns((tCOMAR *)NULL)
 *            else it will return the local followlist for the nonterminal
 *                 nt
 */
extern void cmrtl_follow_on_dlist_for_nt( /* tCOMAR *c, tCOMAR *dlist,
						DID nt */ );



/* cmrtl_follow_on_list_for_nt - returns the local followlist for the
 *                               nonterminal nt in an undelimited list
 * on entry : datastructure c, 
 *            undelimited list list,
 *            (DID) nonterminal nt, 
 * on exit  : if list is empty
 *              then it returns((tCOMAR *)NULL) 
 *            else it will return the local followlist for the nonterminal
 *                 nt in this list
 */
extern void cmrtl_follow_on_list_for_nt( /* tCOMAR *c, tCOMAR *list,
					       DID nt */ );


/* cmrtl_follow_on_subtr_for_nt - returns the local followlist for the
 *                                nonterminal nt in the subtree subtr
 * on entry : datastructure c,
 *            subtree subtr,
 *            (DID) nonterminal nt,
 * on exit  : if subtr is empty 
 *              then it returns((tCOMAR *)NULL)
 *            else it will return the local followlist for the nonterminal
 *                 nt in this subtree
 */
extern void cmrtl_follow_on_subtr_for_nt( /* tCOMAR *c, tCOMAR *subtr,
						DID nt */ );


/* cmrtl_follow_init - initializes the computation of the Follow-sets
 * on entry : datastructure c
 * on exit  : if no startsymbol can be found
 *              then CMRL_NOSTART 
 *            if the startsymbol is ambiguous
 *              then CMRL_AMBSTART
 *            if the startsymbol cannot be initialized with a followset
 *              then CMRTL_NOFOLINIT
 *            if there is another error 
 *              then CMR_UNKERR
 *            CMR_SUCCESS if everything is ok
 *            action:
 *              sets followlist for the root of the grammar
 */
extern int cmrtl_follow_init( /* tCOMAR *c */ );


/* cmrtl_follow_for_grammar - computes the followsets for all nonterminals
 *                            in the grammar
 * on entry : datastructure c
 * on exit  : if an error occurs
 *              then CMR_UNKERR
 *            else CMR_SUCCESS
 */
extern int cmrtl_follow_for_grammar( /* tCOMAR *c */ ); 


/* Section 3.2 : evaluation of the transitive closure of a
 *               followset for one nonterminal and terminalzation
 *               of a followset for a nonterminal
 */

/* cmrtl_follow_trans_closure_for_nt - computes the transitive 
 *              closure of the followset for nonterminal nt
 * on entry : datastructure c,
 *            nonterminal (DID) nt
 * on exit  : (tCOMAR *)NULL if the transitive closure is being
 *               evaluated or if an error occurs
 *            pointer to the list which contains the transitive
 *              closure of the followset for nonterminal nt
 *            if FOLLOW is not yet evaluated
 *              then it is invoked to be evaluated
 */
extern tCOMAR *cmrtl_follow_trans_closure_for_nt( /* tCOMAR *c,
						     DID nt */ );


/* cmrtl_follow_for_nt_terminalized - computes the terminalized follow
 *                               set for nonterminal nt
 * on entry : datastructure c,
 *            nonterminal (DID) nt
 * on exit  : returns an undelimited list
 *              which contains all possible terminalsymbols of the 
 *              follow set for nonterminal nt
 *            (tCOMAR *)NULL if an error occurs
 */
extern tCOMAR *cmrtl_follow_for_nt_terminalized( /* tCOMAR *c,
					            DID nt */ );


