/*
** $Id: first.c,v 1.2 90/10/23 14:41:45 cogito Exp $
*/
static char rcs_id[]= "$Id: first.c,v 1.2 90/10/23 14:41:45 cogito Exp $";

#include <stdio.h>
#include "ccomar.h"
#include "ccomarl.h"
#include "first.h"
#include "privlib.h"
#include "setop.h"

#define NEWDVALLIST(d) cmr_add_to_list(cmr_new_list(), \
                                       cmr_new_dval(d))

#define PROPLISTHEAD(l) cmr_new_lval(cmr_begin_list(l))

/**************************************************************************/
/* Section 1 :           Evaluation of FIRST                              */
/**************************************************************************/

/**************************************************************************/
/*                        private functions                               */
/**************************************************************************/


/* first_modify_for_nterm - returns the datastructure with modified
 *                          firstlists
 * on entry : datastructure c,
 *            nonterminal nt
 * on exit  : modified datastructure c
 *            this procedure should be called, if it is detected
 *            that eps appears in the firstlist of nt
 *            this procedure looks up all firstlists with the 
 *            member nt and modifies this firstlist
 */
static tCOMAR *first_modify_for_nterm(c, nt)
tCOMAR *c; 
DID nt;
{
DID currnt = cmrl_first_nterm(c);
SID firstsid = cmrl_add_name(c, FIRST);
tCOMAR *prop, *propval;
tCOMAR *l1;
boolean epsexists;

  while (currnt != -1)
  {
    if ((prop = cmr_get_prop(c, currnt, firstsid)) != 
	    (tCOMAR *)NULL)
      /* then */
      {
	propval = cmr_get_prop_val(prop);
        if (cmrl_get_dval_in_val_subtr(propval, nt) != 
                (tCOMAR *)NULL)
	  /* then this list must be changed */
	  {
          DID prod1;
	  
	    epsexists = (cmrl_get_dval_in_val_subtr(propval,
						    cmrl_get_eps_did(c))
                         != (tCOMAR *)NULL);

            prod1 = cmrl_first_prod_with_lhs(c, currnt);

	    if (prod1 != -1)
	      l1 = cmrtl_first_on_dlist(c, cmr_get_prod_units(c, prod1));

            prod1 = cmrl_next_prod_with_lhs(c, prod1, currnt);

	    while (prod1 != -1)
	    {
	    tCOMAR *l3;

	      l1 = cmrtl_union_val_lists(l1, 
					 l3 = cmrtl_first_on_dlist(c, cmr_get_prod_units(c, prod1)));

	      (void) cmr_del_list(l3);
	      prod1 = cmrl_next_prod_with_lhs(c, prod1, currnt);
            }

	    cmr_set_prop_val(c, currnt, firstsid, PROPLISTHEAD(l1));

            if ( !epsexists && cmrl_get_dval_in_val_list(l1, cmrl_get_eps_did(c)) != (tCOMAR *)NULL)
	      /* then a modification of the firstlists with 
		 currnt as a member is necessary */
              (void)first_modify_for_nterm(c, currnt);

          }
      }
    currnt = cmrl_next_nterm(c, currnt);
  }                                         /* of while */
return(c);
}                                           /* of first_modify_for_nterm */



/* first_terminalize_firstlist - computes the terminalized firstset
 *                               for a given firstset
 * on entry : datastructure c,
 *            an undelimited list firstlist containing the firstset
 * on exit  : returns a pointer to a list that contains the terminalized
 *              firstset of the given firstlist
 *            (tCOMAR *)NULL on error
 */
static tCOMAR *first_terminalize_firstlist(c, firstlist)
tCOMAR *c;
tCOMAR *firstlist;
{
tCOMAR *newlist = cmr_new_list();
tCOMAR *q;
tCOMAR *epspointer;
boolean epsexists;


  epsexists = (cmrl_get_dval_in_val_list(firstlist, cmrl_get_eps_did(c))
					!= (tCOMAR *)NULL);

  for (q = firstlist; !cmr_isempty_list(q); q = cmr_list_tail(q))
  {
  tCOMAR *head;
  tCOMAR *l3 = cmr_new_list(); 
  int tag;
  DID did1;

    if (cmr_get_tag(head = cmr_list_head(q)) != P_DVAL)
      return ((tCOMAR *)NULL);

    if ((tag = cmr_get_def_entry_tag(c, did1 = cmr_get_dval_did(head)))
	    == P_NTERM)
      newlist = cmrtl_union_val_lists(newlist, l3 = cmrtl_first_for_nt_terminalized(c, did1));
    else
      if (tag == P_TERM)
	newlist = cmrtl_union_val_lists(newlist, l3 = NEWDVALLIST(did1));
      else    /* the else part is never executed if
		 the firstlist is ok */
        return((tCOMAR *)NULL);

    (void) cmr_del_list(l3);

  }      /* of for */
  if (!epsexists
      && (epspointer = cmrl_get_dval_in_val_list(newlist,cmrl_get_eps_did(c))) != (tCOMAR *)NULL)
         newlist = cmr_list_delitem(newlist, epspointer);

  return(newlist);
}

/****************************************************************************/
/*                   exported functions                                     */
/****************************************************************************/

/* Section 1.1 : primitive evaluation of a firstset */

tCOMAR *cmrtl_first_on_dlist(c, list)
tCOMAR *c, *list;
{
  return(cmrtl_first_on_list(c, cmr_get_begin_list(list)));
}


tCOMAR *cmrtl_first_on_list(c, list)
tCOMAR *c, *list;
{
tCOMAR *sub1;
tCOMAR *q;

  if (cmr_isempty_list(list)) return(NEWDVALLIST(cmrl_get_eps_did(c)));
  
  sub1 = cmrtl_first_on_subtr(c, cmr_list_head(list));

  if ((q = cmrl_get_dval_in_val_list(sub1, cmrl_get_eps_did(c))) !=
			       (tCOMAR *)NULL)
       {
       /* then eps is in list */
       tCOMAR  *sub3;

       sub1 = cmrtl_union_val_lists(
                   sub1 = cmr_list_delitem(sub1, q), 
		   sub3 = cmrtl_first_on_list(c, cmr_list_tail(list)));
       (void) cmr_del_list(sub3);
       }

  return(sub1);
}



tCOMAR *cmrtl_first_on_subtr(c, subtr)
tCOMAR *c, *subtr;
{
tCOMAR *l1, *l2;
DID did1;
int tag;

  if (subtr == (tCOMAR *)NULL) return((tCOMAR *)NULL);

  switch (cmr_get_tag(subtr)) {
    
    case P_ALT    : l1 = cmrtl_first_on_dlist(c, cmr_get_alt_units1(subtr));
		    l2 = cmrtl_first_on_dlist(c, cmr_get_alt_units2(subtr));
                    l1 = cmrtl_union_val_lists(l1, l2);
		    (void) cmr_del_list(l2);
		    return(l1);

    case P_OPT    : l1 = cmrtl_first_on_dlist(c, cmr_get_opt_units(subtr));
		    l1 = cmrtl_union_val_lists(l1, 
					       l2 =  NEWDVALLIST(cmrl_get_eps_did(c)));
                    (void) cmr_del_list(l2);
		    return(l1); 

    case P_STAR   : l1 = cmrtl_first_on_dlist(c, cmr_get_star_units(subtr));
		    l1 = cmrtl_union_val_lists(l1,
					       l2 =  NEWDVALLIST(cmrl_get_eps_did(c)));
		    (void) cmr_del_list(l2);
		    return(l1);

    case P_DELREP : l1 = cmrtl_first_on_dlist(c, cmr_get_delrep_units1(subtr));
		    if (cmrl_get_dval_in_val_list(l1, cmrl_get_eps_did(c))
						 != (tCOMAR *)NULL)
		      {
			l2 = cmrtl_first_on_dlist(c,
						  cmr_get_delrep_units2(subtr));
			l1 = cmrtl_union_val_lists(l1, l2);
			(void) cmr_del_list(l2);
		      }
                    return(l1);

    case P_PLUS   : return(cmrtl_first_on_dlist(c, cmr_get_plus_units(subtr)));

    case P_ELUNIT : did1 = cmr_get_elunit_elem(subtr);
		    tag = cmr_get_def_entry_tag(c, did1);

		    if (tag == P_TERM) return(NEWDVALLIST(did1));

		    if (tag == P_NTERM)
		      {
			l1 = cmrtl_first_for_nterm(c, did1);
			if (cmrl_get_dval_in_val_subtr(l1, cmrl_get_eps_did(c))
                              != (tCOMAR *)NULL)
			  /* then eps is in list l1 */
			  return(cmr_cat_lists(NEWDVALLIST(did1),
                                               NEWDVALLIST(cmrl_get_eps_did(c))));
                         /* else eps is not in l1 or the the processing
			    for the firstlist of did1 is just going on */
			   
			 else return(NEWDVALLIST(did1));
                       }

		    /* treat OTHERS like an empty list */

		    return(NEWDVALLIST(cmrl_get_eps_did(c)));

    default       : return(cmr_new_list()); 

    }                      /* of switch */
}                          /* of proc   */


tCOMAR *cmrtl_first_for_nterm(c, nt)
tCOMAR *c;
DID nt;
{
tCOMAR *l1 = cmr_new_list();
DID p;
SID firstsid = cmrl_add_name(c, FIRST);
tCOMAR *prop;

  if (cmr_get_def_entry_tag(c, nt) != P_NTERM)
     return((tCOMAR *)NULL);

  if ((prop = cmr_get_prop(c, nt, firstsid))
	!= (tCOMAR *)NULL)
     return(cmr_get_prop_val(prop));

  /* mark this nt
     a property-entry for FIRST with empty valuelist 
     indicates that FIRST will be evaluated for this nonterminal */

  if (cmr_new_prop_val(c, nt, firstsid, cmr_new_list()) != nt)
     return((tCOMAR *)NULL);

  p = cmrl_first_prod_with_lhs(c, nt);

  while (p != -1) 
  {

  tCOMAR *l2;

    l1 = cmrtl_union_val_lists(l1,
			       l2 = cmrtl_first_on_dlist(c, cmr_get_prod_units(c,p)));
    (void) cmr_del_list(l2);
    p = cmrl_next_prod_with_lhs(c, p, nt);
  } 

  (void) cmr_set_prop_val(c, nt, firstsid, PROPLISTHEAD(l1));

  if (cmrl_get_dval_in_val_list(l1, cmrl_get_eps_did(c)) != (tCOMAR *)NULL)
     /* then all firstlists with member nt must be modified */
     (void) first_modify_for_nterm(c, nt);

  return(cmr_get_prop_val(cmr_get_prop(c, nt, firstsid)));
}


tCOMAR *cmrtl_first_for_term(c, term)
tCOMAR *c;
DID term;
{
SID firstsid = cmrl_add_name(c, FIRST);
tCOMAR *prop;

  if (cmr_get_def_entry_tag(c, term) != P_TERM)
     return((tCOMAR *)NULL);

  if ((prop = cmr_get_prop(c, term, firstsid)) != (tCOMAR *)NULL)
     return(cmr_get_prop_val(prop));

  if (cmr_new_prop_val(c, term, firstsid, PROPLISTHEAD(NEWDVALLIST(term))) != term)
    return((tCOMAR *)NULL);

  return(cmr_get_prop_val(cmr_get_prop(c, term, firstsid)));
}


int cmrtl_first_for_grammar(c)
tCOMAR *c;
{
DID currnt;
DID currterm;
  
  currnt = cmrl_first_nterm(c);

  while (currnt != -1)
  {
    if (cmrtl_first_for_nterm(c, currnt) == (tCOMAR *)NULL)
      return(CMR_UNKERR);

    currnt = cmrl_next_nterm(c,currnt);
  }


  currterm = cmrl_first_term(c);

  while (currterm != -1)
  {
    if (cmrtl_first_for_term(c, currterm) == (tCOMAR *)NULL)
      return(CMR_UNKERR);

    currterm = cmrl_next_term(c, currterm);
  }

  return(CMR_SUCCESS);
}


/* Section 1.2 : evaluation of the transitive closure of a
 *               firstset for a nonterminal
 */

tCOMAR *cmrtl_first_trans_closure_for_nt(c, nt)
tCOMAR *c;
DID nt;
{
SID firsttransclos = cmrl_add_name(c, FIRSTTRANSCLOS);
DID p;
tCOMAR *prop, *proplist, *sublist;
tCOMAR *newlist = cmr_new_list();
boolean epsexists;
tCOMAR *epspointer;

  if (cmr_get_def_entry_tag(c, nt) != P_NTERM)
    return((tCOMAR *)NULL);

  if ((prop = cmr_get_prop(c, nt, firsttransclos)) != (tCOMAR *)NULL)
    return(cmr_get_prop_val(prop));
    
  /* mark this node to be evaluated */
  if (cmr_new_prop_val(c, nt, firsttransclos, cmr_new_list()) != nt)
    return((tCOMAR *)NULL);

  proplist = cmrtl_first_for_nterm(c, nt);
  if (proplist == (tCOMAR *)NULL || cmr_get_tag(proplist) != P_LVAL) 
    return((tCOMAR *)NULL);

  epsexists = (cmrl_get_dval_in_val_subtr(proplist, cmrl_get_eps_did(c))
					 != (tCOMAR *)NULL);
  
  sublist = cmr_get_begin_list(cmr_get_lval_list(proplist));
  
  while (!cmr_isempty_list(sublist))
  {
    tCOMAR *head, *l3;
    DID elem; 

    if (cmr_get_tag(head = cmr_list_head(sublist)) == P_DVAL)
    {

      if (cmr_get_def_entry_tag(c, elem = cmr_get_dval_did(head)) == P_NTERM)
      /* then */
      {
	tCOMAR *proplist2;

	proplist2 = cmrtl_first_trans_closure_for_nt(c, elem);

	if (proplist2 != (tCOMAR *)NULL)
	  newlist = cmrtl_union_val_lists(newlist, cmr_get_begin_list(cmr_get_lval_list(proplist2)));
      }
      newlist =  cmrtl_union_val_lists(newlist, l3 = NEWDVALLIST(elem));
      (void) cmr_del_list(l3);
    } 
    sublist = cmr_list_tail(sublist);

  }        /* of WHILE */

  if (!epsexists)
    if ((epspointer = cmrl_get_dval_in_val_list(newlist, cmrl_get_eps_did(c)))
	   != (tCOMAR *)NULL)
	newlist = cmr_list_delitem(newlist, epspointer);

  (void) cmr_set_prop_val(c, nt, firsttransclos, PROPLISTHEAD(newlist));

  p = cmrl_first_nterm(c);

  while (p != -1)      /* modification of other lists */
  {
  tCOMAR *list2;
  tCOMAR *proptree;

    if (p != nt &&
	(prop = cmr_get_prop(c, p, firsttransclos)) != (tCOMAR *)NULL)
      if (cmrl_get_dval_in_val_subtr(
              proptree = cmr_get_prop_val(prop),
	      nt) != (tCOMAR *)NULL)
	{
	epsexists = (cmrl_get_dval_in_val_subtr(proptree, cmrl_get_eps_did(c)) != (tCOMAR *)NULL);

	list2 =  cmrtl_union_val_lists(cmrl_copy_list(cmr_get_begin_list(cmr_get_lval_list(proptree))), newlist);

	if (!epsexists &&
            (epspointer = cmrl_get_dval_in_val_list(list2, cmrl_get_eps_did(c)))
	      != (tCOMAR *)NULL)
	  list2 = cmr_list_delitem(list2, epspointer);
        
	(void) cmr_set_prop_val(c, p, firsttransclos, PROPLISTHEAD(list2));
	}
    p = cmrl_next_nterm(c, p);
  }
  
  return(cmr_get_prop_val(cmr_get_prop(c, nt, firsttransclos)));
}


/* Section 1.3 : evaluation of a terminalized firstset for a nonterminal
 *               and for production trees
 */

tCOMAR *cmrtl_first_for_nt_terminalized(c, nt)
tCOMAR *c;
DID nt;
{
int tag;
tCOMAR *newlist = cmr_new_list();
tCOMAR *q;

  if ((tag = cmr_get_def_entry_tag(c, nt)) == P_NTERM)
  {
  /* then */
    tCOMAR *proplist;
    if ((proplist = cmrtl_first_trans_closure_for_nt(c, nt)) ==
	(tCOMAR *)NULL)   return((tCOMAR *)NULL);
    if (cmr_get_tag(proplist) != P_LVAL) return((tCOMAR *)NULL);

    for (q = cmr_get_begin_list(cmr_get_lval_list(proplist));
         !cmr_isempty_list(q);
	 q = cmr_list_tail(q))
    {
      DID did1;
      tCOMAR *head;

      if (cmr_get_tag(head = cmr_list_head(q)) == P_DVAL)
	if (cmr_get_def_entry_tag(c, did1 = cmr_get_dval_did(head)) ==
				 P_TERM)
	newlist = cmr_cat_lists(newlist, NEWDVALLIST(did1));
    }
  }
  else
    if (tag == P_TERM)
      newlist = cmr_cat_lists(newlist, NEWDVALLIST(nt));
  return(newlist);
}


tCOMAR *cmrtl_first_on_dlist_terminalized(c, dlist)
tCOMAR *c, *dlist;
{
tCOMAR *l2;
tCOMAR *termlist;

  termlist = first_terminalize_firstlist(c, l2 = cmrtl_first_on_dlist(c, dlist));
  (void) cmr_del_list(l2);
  return(termlist);
}


tCOMAR *cmrtl_first_on_list_terminalized(c, list) 
tCOMAR *c, *list;
{
tCOMAR *l2;
tCOMAR *termlist; 

  termlist = first_terminalize_firstlist(c, l2 = cmrtl_first_on_list(c, list));
  (void) cmr_del_list(l2);
  return(termlist);
}


tCOMAR *cmrtl_first_on_subtr_terminalized(c, subtr)
tCOMAR *c, *subtr;
{
  tCOMAR *l2;
  tCOMAR *termlist;

  termlist = first_terminalize_firstlist(c, l2 = cmrtl_first_on_subtr(c, subtr));

  (void) cmr_del_list(l2);
  return(termlist);
}

/* Section 2 : evaluation of a new local followlist for some 
 *             special subtree kinds 
 */

tCOMAR *cmrtl_new_localfollow_for_list(c, list, locfol)
tCOMAR *c, *list, *locfol;
{
  tCOMAR *listfollow, *epspointer;

  if (list == (tCOMAR *)NULL) return((tCOMAR *)NULL);
  
  listfollow = cmrtl_first_on_list_terminalized(c, cmr_list_tail(list));

  if ((epspointer = cmrl_get_dval_in_val_list(listfollow, 
					      cmrl_get_eps_did(c)))
      != (tCOMAR *)NULL)
  {  /* then */
    listfollow = cmr_list_delitem(listfollow, epspointer);
    listfollow = cmrtl_union_val_lists(listfollow, locfol);
  }
  return(listfollow);
}

                                               
tCOMAR *cmrtl_new_localfollow_for_plus(c, plus, locfol)
tCOMAR *c, *plus, *locfol;
{
tCOMAR *newfollist;
tCOMAR *epspointer;

  if (cmr_get_tag(plus) != P_PLUS)
    return((tCOMAR *)NULL);

  newfollist = cmrtl_first_on_dlist_terminalized(c, cmr_get_plus_units(plus));

  if ((epspointer = cmrl_get_dval_in_val_list(newfollist, cmrl_get_eps_did(c)))
	!= (tCOMAR *)NULL)
    newfollist = cmr_list_delitem(newfollist, epspointer);

  newfollist = cmrtl_union_val_lists(newfollist, locfol);
  return(newfollist);
}


tCOMAR *cmrtl_new_localfollow_for_star(c, star, locfol)
tCOMAR *c, *star, *locfol; 
{
tCOMAR *newfollist; 
tCOMAR *epspointer;

  if (cmr_get_tag(star) != P_STAR)
    return((tCOMAR *)NULL); 

  newfollist = cmrtl_first_on_dlist_terminalized(c, cmr_get_star_units(star));     

  if ((epspointer = cmrl_get_dval_in_val_list(newfollist, cmrl_get_eps_did(c)))
        != (tCOMAR *)NULL) 
    newfollist = cmr_list_delitem(newfollist, epspointer);

  newfollist = cmrtl_union_val_lists(newfollist, locfol); 
  return(newfollist); 
}


tCOMAR *cmrtl_new_localfollow_for_delrep_units1(c, delrep, locfol)
tCOMAR *c, *delrep, *locfol;  
{
tCOMAR *newfollist;  
tCOMAR *epspointer;

  if (cmr_get_tag(delrep) != P_DELREP)
    return((tCOMAR *)NULL);

  newfollist = cmrtl_first_on_dlist_terminalized(c, cmr_get_delrep_units2(delrep));

  if ((epspointer = cmrl_get_dval_in_val_list(newfollist, cmrl_get_eps_did(c)))
	!= (tCOMAR *)NULL)
  {
  tCOMAR *l4;
   
    newfollist = cmr_list_delitem(newfollist, epspointer);
    l4 = cmrtl_first_on_dlist_terminalized(c, cmr_get_delrep_units1(delrep));

    newfollist = cmrtl_union_val_lists(newfollist, l4);
    (void) cmr_del_list(l4);

    if ((epspointer = cmrl_get_dval_in_val_list(newfollist, cmrl_get_eps_did(c)))
          != (tCOMAR *)NULL)
      newfollist = cmr_list_delitem(newfollist, epspointer);

  }

  newfollist = cmrtl_union_val_lists(newfollist, locfol);

  return(newfollist);
}



tCOMAR *cmrtl_new_localfollow_for_delrep_units2(c, delrep, locfol)
tCOMAR *c, *delrep, *locfol;
{
tCOMAR *l4;
tCOMAR *newfollist;
tCOMAR *epspointer;

  if (cmr_get_tag(delrep) != P_DELREP)
    return((tCOMAR *)NULL);

  newfollist = cmrtl_first_on_dlist_terminalized(c, cmr_get_delrep_units1(delrep));

  if ((epspointer = cmrl_get_dval_in_val_list(newfollist, cmrl_get_eps_did(c)))
	== (tCOMAR *)NULL)
    /* then newfollist is the local follow for units2 */
    return(newfollist);

  /* else */
  newfollist = cmr_list_delitem(newfollist, epspointer);
  l4 = cmrtl_first_on_dlist_terminalized(c, cmr_get_delrep_units2(delrep));

  newfollist = cmrtl_union_val_lists(newfollist, l4);
  (void) cmr_del_list(l4);

  if ((epspointer = cmrl_get_dval_in_val_list(newfollist, cmrl_get_eps_did(c))) 
	!= (tCOMAR *)NULL)
    newfollist = cmr_list_delitem(newfollist, epspointer);

  newfollist = cmrtl_union_val_lists(newfollist, locfol);

  return(newfollist);
}




/***********************************************************************/
/* Section 3 :          EVALUATION OF FOLLOW                           */
/***********************************************************************/

/* Section 3.1 : primitive evaluation of the followset for
 *               one special nonterminal
 */

tCOMAR *cmrtl_follow_for_nterm(c, nt)
tCOMAR *c;
DID nt;
{
SID followsid = cmrl_add_name(c, FOLLOW);
tCOMAR *prop;

  if (cmr_get_def_entry_tag(c, nt) != P_NTERM)
    return((tCOMAR *)NULL);

#if DEBUG
  fprintf(stderr, "cmrtl_follow_for_nterm bei nt = %s\n", cmrl_didtosymb(c, nt));
#endif

  if ((prop = cmr_get_prop(c, nt, followsid)) != (tCOMAR *)NULL)
    return(cmr_get_prop_val(prop));
  
  if (cmrtl_follow_for_grammar(c) != CMR_SUCCESS)
    return((tCOMAR *)NULL);

  return(cmr_get_prop_val(cmr_get_prop(c, nt, followsid)));
}



void cmrtl_follow_on_prod_for_nt(c, prod)
tCOMAR *c;
DID prod;
{
DID lhs = cmr_get_prod_lhs(c, prod);
tCOMAR *l1;

    (void) cmrtl_follow_on_dlist_for_nt(c, cmr_get_prod_units(c, prod),
                                        l1 = NEWDVALLIST(lhs));

    (void) cmr_del_list(l1);
    return;
}


void cmrtl_follow_on_dlist_for_nt(c, dlist, locfol)
tCOMAR *c, *dlist;
tCOMAR *locfol;
{
  (void) cmrtl_follow_on_list_for_nt(c, cmr_get_begin_list(dlist), locfol);

  return;
}


void cmrtl_follow_on_list_for_nt(c, list, locfol)
tCOMAR *c, *list;
tCOMAR *locfol;
{
tCOMAR *localfollow;

  if (list == (tCOMAR *)NULL) return;

   /* then we must consider head */
   /* new evaluation of locfol for this part */
   localfollow = cmrtl_new_localfollow_for_list(c, list, locfol);

   (void) cmrtl_follow_on_subtr_for_nt(c, cmr_list_head(list), localfollow);

   (void) cmr_del_list(localfollow);

   cmrtl_follow_on_list_for_nt(c, cmr_list_tail(list), locfol);
   
  return;
}


void cmrtl_follow_on_subtr_for_nt(c, subtr, locfol)
tCOMAR *c, *subtr;
tCOMAR *locfol;
{
tCOMAR *localfollow;
static SID followsid = -1;

  if (followsid == -1)
    followsid = cmrl_add_name(c, FOLLOW);
  
  if (subtr == (tCOMAR *)NULL) return;

  switch (cmr_get_tag(subtr)) {

  case P_ELUNIT : {
		    DID nt = cmr_get_elunit_elem(subtr);

                    if (cmr_get_def_entry_tag(c, nt) == P_NTERM)
		    {
		      tCOMAR *prop = cmr_get_prop(c, nt, followsid);

		      if (prop == (tCOMAR *)NULL)
		      {
			if (cmr_new_prop_val(c, nt, followsid, PROPLISTHEAD(cmrl_copy_list(locfol)))
                            != nt)
			  return;
                      }
		      else
		      {
			tCOMAR *l1 = cmr_get_begin_list(cmr_get_lval_list(cmr_get_prop_val(prop)));

			l1 = cmrtl_union_val_lists(cmrl_copy_list(l1), locfol);
			(void) cmr_set_prop_val(c, nt, followsid, PROPLISTHEAD(l1));
			return;
                      }
                    }

		    (void) cmr_del_list(locfol);
                  }

  case P_ALT    : 
		  (void) cmrtl_follow_on_dlist_for_nt(c, cmr_get_alt_units1(subtr), locfol);
		  (void) cmrtl_follow_on_dlist_for_nt(c, cmr_get_alt_units2(subtr), locfol);

		  return;

  case P_PLUS   : localfollow = cmrtl_new_localfollow_for_plus(c, subtr, locfol);
		  (void) cmrtl_follow_on_dlist_for_nt(
                              c, cmr_get_plus_units(subtr), localfollow);
		  (void) cmr_del_list(localfollow);
		  return;

  case P_OPT    :  
		  (void) cmrtl_follow_on_dlist_for_nt(
                              c, cmr_get_opt_units(subtr), locfol);
		  return;

  case P_STAR   : localfollow = cmrtl_new_localfollow_for_star(c, subtr, locfol); 
		  (void) cmrtl_follow_on_dlist_for_nt(
                              c, cmr_get_star_units(subtr), localfollow); 
                  (void) cmr_del_list(localfollow);
		  return;

  case P_DELREP :
		  {
                    localfollow = cmrtl_new_localfollow_for_delrep_units1(c, subtr, locfol);
		    (void) cmrtl_follow_on_dlist_for_nt(c, cmr_get_delrep_units1(subtr), localfollow);
		    (void) cmr_del_list(localfollow);

		    localfollow = cmrtl_new_localfollow_for_delrep_units2(c, subtr, locfol);
		    (void) cmrtl_follow_on_dlist_for_nt(c, cmr_get_delrep_units2(subtr), localfollow);
		    (void) cmr_del_list(localfollow);

		    return;
                  }
		    
  default       : return;

  }               /* of switch */

}                /* of proc */


int cmrtl_follow_init(c)
tCOMAR *c;

{
tCOMAR *startsymbollist = cmrl_get_startsymbols(c);
static DID rootdid = -1;
SID followsid = cmrl_add_name(c, FOLLOW);
SID endsid    = cmrl_add_string(c, EOFSYMBOL);
SID endmarkersid = cmrl_add_name(c, EOFPROP);

int len;
int tag;
DID enddid;
tCOMAR *head;

 if (rootdid == -1)
 {
  if ((len = cmr_list_len(startsymbollist)) > 1)
  {
     while (!cmr_isempty_list(startsymbollist))
     {
       DID did = cmr_get_elunit_elem(cmr_list_head(startsymbollist));

       fprintf(stderr, "Startsymbol : %s\n", cmrl_didtosymb(c, did));
       startsymbollist = cmr_list_tail(startsymbollist);
     }
     return(CMRL_AMBSTART);
  }

  if (len == 0)
     return(CMRL_NOSTART);

  head = cmr_list_head(startsymbollist);

  if ((tag = cmr_get_tag(head)) == P_ELUNIT)
    rootdid = cmr_get_elunit_elem(head);

  else 
    if (tag == P_DVAL)
      rootdid = cmr_get_dval_did(head);
    else return(CMR_UNKERR);
 }
  /*    set the properties   */


  if ((enddid = cmrl_sid_to_firstdid(c, endsid)) == CMR_UNKERR)
  {
    enddid = cmr_new_def_entry(c, P_TERM, endsid);
    if (cmr_new_prop(c, enddid, endmarkersid) != enddid)
      return(CMR_UNKERR);
  }
  else
  {
    if ((tag = cmr_get_def_entry_tag(c, enddid)) == P_TERM &&
        cmr_get_prop(c, enddid, endmarkersid) == (tCOMAR *)NULL)
	  return(CMRTL_NOFOLINIT);
    else
      if (tag != P_TERM)
	return(CMRTL_NOFOLINIT);
  }

  if (cmr_new_prop_val(c, rootdid, followsid, 
			  PROPLISTHEAD(NEWDVALLIST(enddid))) != rootdid)
    return(CMR_UNKERR);

  return(CMR_SUCCESS);
}


int cmrtl_follow_for_grammar(c)
tCOMAR *c;
{
int stat;
DID p;

  if ((stat = cmrtl_follow_init(c)) != CMR_SUCCESS)
    return(stat);

  p = cmrl_first_prod(c);

  while (p != -1) 
  {
    (void) cmrtl_follow_on_prod_for_nt(c, p);

    p = cmrl_next_prod(c, p);
  }

  return(CMR_SUCCESS);
}


/* Section 3.2 : evaluation of the transitive closure of a
 *               followset for one nonterminal and terminalzation
 *               of a followset for a nonterminal
 */

tCOMAR *cmrtl_follow_trans_closure_for_nt(c, nt)
tCOMAR *c;
DID nt;
{
SID followtransclos = cmrl_add_name(c, FOLTRANSCLOS);
DID p;
tCOMAR *prop, *proplist, *sublist;
tCOMAR *newlist = cmr_new_list();

  if (cmr_get_def_entry_tag(c, nt) != P_NTERM)
    return((tCOMAR *)NULL);

  if ((prop = cmr_get_prop(c, nt, followtransclos)) != (tCOMAR *)NULL)
    return(cmr_get_prop_val(prop));

  /* mark this nt */
  if (cmr_new_prop_val(c, nt, followtransclos, cmr_new_list()) != nt)
    return((tCOMAR *)NULL);

  proplist = cmrtl_follow_for_nterm(c, nt);
  if (proplist == (tCOMAR *)NULL || cmr_get_tag(proplist) != P_LVAL)
    return((tCOMAR *)NULL);

  sublist = cmrl_copy_list(cmr_get_begin_list(cmr_get_lval_list(proplist)));

  while (!cmr_isempty_list(sublist))
  {
  tCOMAR *head, *l3;
  DID elem;

    if (cmr_get_tag(head = cmr_list_head(sublist)) == P_DVAL)
    {
      if (cmr_get_def_entry_tag(c, elem = cmr_get_dval_did(head)) == P_NTERM)
      {
      tCOMAR *proplist2 = cmrtl_follow_trans_closure_for_nt(c, elem);

	if (proplist2 != (tCOMAR *)NULL)
	  newlist = cmrtl_union_val_lists(newlist, cmr_get_begin_list(
                                              cmr_get_lval_list(proplist2)));
      }
      newlist = cmrtl_union_val_lists(newlist, l3 = NEWDVALLIST(elem));
      (void) cmr_del_list(l3);
    }
    sublist = cmr_list_tail(sublist);
  }                   /* of while */

  (void) cmr_del_list(sublist);

  (void) cmr_set_prop_val(c, nt, followtransclos, PROPLISTHEAD(newlist));

  p = cmrl_first_nterm(c);

  while (p != -1)
  {
  tCOMAR *list2, *proptree;

    if (p != nt &&
        (prop = cmr_get_prop(c, p, followtransclos)) != (tCOMAR *)NULL)
      if (cmrl_get_dval_in_val_subtr(
             proptree = cmr_get_prop_val(prop), nt) != (tCOMAR *)NULL)
      {
	list2 = cmrtl_union_val_lists(
                   cmrl_copy_list(cmr_get_begin_list(cmr_get_lval_list(proptree))), newlist);
	(void) cmr_set_prop_val(c, p, followtransclos, PROPLISTHEAD(list2));
      }
    p = cmrl_next_nterm(c, p);
  }

  return(cmr_get_prop_val(cmr_get_prop(c, nt, followtransclos)));
}


tCOMAR *cmrtl_follow_for_nt_terminalized(c, nt)
tCOMAR *c;
DID nt;
{
tCOMAR *newlist = cmr_new_list();
tCOMAR *proplist;
tCOMAR *q;

  if (cmr_get_def_entry_tag(c, nt) != P_NTERM)
    return((tCOMAR *)NULL);

  proplist = cmrtl_follow_trans_closure_for_nt(c, nt);

  if (proplist == (tCOMAR *)NULL || cmr_get_tag(proplist) != P_LVAL)
    return((tCOMAR *)NULL);

  for (q = cmr_get_begin_list(cmr_get_lval_list(proplist));
       !cmr_isempty_list(q);
       q = cmr_list_tail(q))
  {
    DID did1;
    tCOMAR *head;

    if (cmr_get_tag(head = cmr_list_head(q)) == P_DVAL)
      if (cmr_get_def_entry_tag(c, did1 = cmr_get_dval_did(head)) == P_TERM)

	newlist = cmr_add_to_list(newlist, cmr_new_dval(did1));
  }

  return(newlist);
}


