/*
** $Id: equality.c,v 1.2 90/10/23 14:40:40 cogito Exp $
*/
static char rcs_id[]= "$Id: equality.c,v 1.2 90/10/23 14:40:40 cogito Exp $";

/* equality.c  -  COMAR library routines for testing equality */

#include <stdio.h>

#include "ccomar.h"
#include "ccomarl.h"
#include "privlib.h"
#include "equality.h"

/*      private routines for equality functions     */

#define new_one_elem_list(nt) \
             cmr_add_to_list(cmr_new_list(), cmr_new_elunit(nt))
#define only_elem_of(l)   cmr_list_head(l)
/* two 'defines' added by Kalle */


/* Urspruengliche Implementierung:
static tCOMAR *push_stack(stack, nt1, nt2)
tCOMAR *stack;
DID nt1, nt2;
{
  return(cmr_add_to_list(stack,
			 cmr_new_alt(cmr_new_elunit(nt1),
                                     cmr_new_elunit(nt2))));
}
*/

static tCOMAR *push_stack(stack, nt1, nt2)
tCOMAR *stack;
DID nt1, nt2;
{
  return(cmr_add_to_list(stack,
			 cmr_new_alt(new_one_elem_list(nt1),
                                     new_one_elem_list(nt2))));
}

static tCOMAR *pop_stack(stack)
tCOMAR *stack;
{
  tCOMAR *t;

  t = cmr_split_list(stack, cmr_list_head(stack));
  (void) cmr_del_list(stack);

  return(t);
}


static boolean in_stack(stack, nt1, nt2)
tCOMAR *stack;
DID nt1, nt2;
{
  while (stack != (tCOMAR *)NULL)
  {

/* call of 'only_elem_of' inserted by Kalle */
    DID elem1 = cmr_get_elunit_elem(only_elem_of(
                             cmr_get_alt_units1(cmr_list_head(stack))
                                                ));
    DID elem2 = cmr_get_elunit_elem(only_elem_of(
                             cmr_get_alt_units2(cmr_list_head(stack))
                                                ));

    if (elem1 == nt1 && elem2 == nt2 ||
        elem1 == nt2 && elem2 == nt1)
      return(TRUE);

    stack = cmr_list_tail(stack);
  }

  return(FALSE);
}


/**************** exported functions of this part *************************/


/* returns TRUE if list1 and list2 are structural equal */
boolean cmrl_equal_list(c, list1, list2, stack, equals)
tCOMAR *c;
tCOMAR *list1, *list2;
tCOMAR *stack;
tCOMAR **equals;
{
  if (list1 == (tCOMAR*)NULL)
    return(list2 == (tCOMAR*)NULL);

  if (list2 == (tCOMAR*)NULL)
    return(list1 == (tCOMAR*)NULL); 

  if (cmr_list_len(list1) != cmr_list_len(list2)) 
    return(FALSE);

  return(cmrl_equal_subtr(c, cmr_list_head(list1), cmr_list_head(list2),
                          stack, equals)  &&
         cmrl_equal_list(c, cmr_list_tail(list1), cmr_list_tail(list2),
                         stack, equals));
}


/* returns TRUE if l1 and l2 are structural equal */
boolean cmrl_equal_subtr(c, l1, l2, stack, equals)
tCOMAR *c;
tCOMAR *l1, *l2;
tCOMAR *stack;
tCOMAR **equals;
{
  int tag;
  boolean same;
  DID did1, did2;

  if (l1 == (tCOMAR*)NULL)
    return(l2 == (tCOMAR*)NULL);

  if (l2 == (tCOMAR*)NULL)
    return(l1 == (tCOMAR*)NULL); 

  if ((tag = cmr_get_tag(l1)) != cmr_get_tag(l2)) 
    return(FALSE);

  switch(tag) 
  {
    case P_ALT   : 
		   same = cmrl_equal_list(c, cmr_get_alt_units1(l1),
                                   cmr_get_alt_units1(l2), stack, equals) 
			    &&
			    cmrl_equal_list(c, cmr_get_alt_units2(l1),
                                   cmr_get_alt_units2(l2), stack, equals);
                   if (same) return(same);
		   return(cmrl_equal_list(c, cmr_get_alt_units2(l1),
                                 cmr_get_alt_units1(l2), stack, equals)
                            &&
			    cmrl_equal_list(c, cmr_get_alt_units1(l1),
                                   cmr_get_alt_units2(l2), stack, equals));
     case P_OPT  : 
		   return(cmrl_equal_list(c,cmr_get_opt_units(l1),
                                           cmr_get_opt_units(l2),stack, equals));
     case P_PLUS : 
		   return(cmrl_equal_list(c,cmr_get_plus_units(l1),
                                           cmr_get_plus_units(l2),stack, equals)); 
     case P_STAR : 
		   return(cmrl_equal_list(c,cmr_get_star_units(l1),
                                           cmr_get_star_units(l2),stack, equals));  
     case P_DELREP : 
		     return(cmrl_equal_list(c,cmr_get_delrep_units1(l1),
                                           cmr_get_delrep_units1(l2),stack, equals)
                             &&
                            cmrl_equal_list(c,cmr_get_delrep_units2(l1),
                                           cmr_get_delrep_units2(l2),stack, equals));
     
     case P_ELUNIT : 
		     did1 = cmr_get_elunit_elem(l1);
		     did2 = cmr_get_elunit_elem(l2);

		     if (did1 == did2) return(TRUE);

		     if ((tag = cmr_get_def_entry_tag(c,did1)) ==
			 cmr_get_def_entry_tag(c,did2) &&
			 tag == P_NTERM)
			 if (cmrl_equal_nterms(c, did1, did2, stack, equals))
					  return(TRUE);
                     return(FALSE);

/* changed by Kalle */     
     default     : fprintf(stderr, "Invalid tag: %d of subtree in cmrl_equal_subtr\n"
                                 , tag);
                   exit(1);

     }
}



/* returns TRUE if the (nonterminals) did1 and did2 produce equivalent 
   right hand sides */
boolean cmrl_equal_nterms(c,did1,did2,stack,equals)
tCOMAR *c;
DID did1, did2;
tCOMAR *stack;
tCOMAR **equals;
{
  tCOMAR *l1, *l2;
  boolean same;
  int tag;

  if (did1 == did2) 
    return(TRUE);
  if ((tag = cmr_get_def_entry_tag(c,did1)) !=
       cmr_get_def_entry_tag(c,did2) || 
	 tag != P_NTERM) 
    return(FALSE);

  /* look up in the stack, whether did1 and did2 are already compared */


  if (in_stack(stack, did1, did2))
    return(TRUE);

  /* push did1 and did2 */  

  stack = push_stack(stack, did1, did2); 

  /* test for structural equivalence */
  l1 = cmrl_cmbine_rules_with_lhs(c, did1);
  l2 = cmrl_cmbine_rules_with_lhs(c, did2);

  same = cmrl_equal_list(c, l1, l2, stack, equals);

  if (same)            /* did1 and did2 are equal */
  {
    if (!in_stack(*equals, did1, did2))
      *equals = push_stack(*equals, did1, did2);
  }
  else
  { 
    /* necessary, because the comparsion of two nonterminals can
     * yield the equivalence of two nonterminals that aren't 
     * equal
     */

    *equals = cmr_del_list(*equals);
  }

  /* pop top of the stack */ 
  stack = pop_stack(stack);

  (void) cmr_del_list(l1);
  (void) cmr_del_list(l2);

  return(same);
}


int cmrl_equal_nterms_elim(c, equals, nosubst)
tCOMAR *c;
tCOMAR *equals;
DID nosubst;
{
  DID elem1, elem2;
  int stat;

  if (equals == (tCOMAR *)NULL)
    return(CMR_SUCCESS);

/* call of 'only_elem_of' inserted by Kalle */
    elem1 = cmr_get_elunit_elem(only_elem_of(
                             cmr_get_alt_units1(cmr_list_head(equals))
                                                ));
    elem2 = cmr_get_elunit_elem(only_elem_of(
                             cmr_get_alt_units2(cmr_list_head(equals))
                                                ));

  if (cmr_get_def_entry_tag(c, elem1) != P_NTERM ||
      cmr_get_def_entry_tag(c, elem2) != P_NTERM)
    return(CMR_SUCCESS);
		       /* return(CMR_SUCCESS) seems strange but makes sense
			  if nothing can be changed because one def_entry
			  was deleted or one is not a nonterminal */

  /* replaces elem2 by elem1 */

  if (elem2 == nosubst)
  {
    elem2 = elem1;
    elem1 = nosubst;
  }

  if ((stat = cmrl_equal_nt_replace(c, elem1, elem2)) != CMR_SUCCESS)
    return(stat);

  return(cmrl_equal_nterms_elim(c, cmr_list_tail(equals), nosubst));
}


/* cmrl_equal_nt_replace - replaces nt2 by nt1 in the whole grammar
 *         nt2 and its productions will be deleted
 */
int cmrl_equal_nt_replace(c, nt1, nt2)
tCOMAR *c;
DID nt1, nt2;
{
  DID maxdid = cmr_get_maxdid(c);
  DID index;

  if (cmr_get_def_entry_tag(c, nt1) != P_NTERM ||
      cmr_get_def_entry_tag(c, nt2) != P_NTERM)
    return(CMR_SUCCESS);
		       /* return(CMR_SUCCESS) seems strange but makes sense
			  if nothing can be changed because one def_entry
			  was deleted or one is not a nonterminal */
  for (index = 0; index <= maxdid; index++)
  {
    int tag = cmr_get_def_entry_tag(c, index);
    tCOMAR *prop;

    if (tag == P_PROD)
    {
      if (cmr_get_prod_lhs(c, index) == nt2)
	(void) cmr_del_def_entry(c, index);
      else
      {
	tCOMAR *rhs = cmr_get_prod_units(c, index);
	tCOMAR *elunit = cmrl_get_elem_in_list(rhs, nt2);

	while (elunit != (tCOMAR *)NULL)
	{
	  if (cmr_set_elunit_elem(elunit, nt1) != elunit)
	    return(CMR_UNKERR);

          elunit = cmrl_get_elem_in_list(rhs, nt2);
        }
      }
    }

    if (tag = P_NTERM)
      if (index == nt2)
	(void) cmr_del_def_entry(c, index);

    prop = cmr_get_first_prop(c, index);

    while (prop != (tCOMAR *)NULL)
    {
      tCOMAR *propval;
      tCOMAR *dvalptr;

      if (cmr_get_prop_tag(prop) == P_PROP_VAL)
      {
	propval = cmr_get_prop_val(prop);

	dvalptr = cmrl_get_dval_in_val_subtr(propval, nt2);

	while (dvalptr != (tCOMAR *)NULL)
	{
	  if (cmr_set_dval_did(dvalptr, nt1) != dvalptr)
	    return(CMR_UNKERR);

          dvalptr = cmrl_get_dval_in_val_subtr(propval, nt2);
        }
      }

      prop = cmr_get_next_prop(c, index, prop);
    }
  }                  /* for */

  return(CMR_SUCCESS);
}                    /* cmrl_equal_nt_replace */ 



