/*
** $Id: ebnf.h,v 1.2 90/10/23 14:40:30 cogito Exp $
*/

#include "old_to_newcmr.h"

/* ebnf.h - interface for EBNF to BNF transformator */


/* Part I : Function for transforming a grammar rule prod  */


/* cmrtl_ebnf_prod_to_bnf - transforms this rule to BNF
 * on entry:  prod denotes the grammarrule
 * LR == TRUE    => production shall be transformed using left recursion
 * LR == FALSE   => production shall be transformed using right recursion
 * alone == TRUE => only this production and newly generated productions
 *                  will be transformed without looking for structural
 *                  equivalences outside of these rules.
 * alone==FALSE  => this production will be transformed to BNF and the grammar
 *                  will be looked up for structural equivalences
 *
 * on exit : if transformation succeeds then CMR_SUCCESS
 *           error number otherwise
 */
extern int cmrtl_ebnf_prod_to_bnf( /* tCOMAR *c,
                         DID prod, boolean alone, boolean LR */ );


/* Part II : functions for eliminating special constructs from the grammar  */

extern int cmrtl_ebnf_alonealt_to_bnf_for_grammar( /* tCOMAR *c */ );

extern int cmrtl_ebnf_embalt_to_bnf_for_grammar( /* tCOMAR *c */ );

extern int cmrtl_ebnf_opt_to_bnf_for_grammar( /* tCOMAR *c */ );

extern int cmrtl_ebnf_delrep_to_bnf_for_grammar( /* tCOMAR *c, boolean LR */ );

extern int cmrtl_ebnf_plus_to_bnf_for_grammar( /* tCOMAR *c, boolean LR */ );

extern int cmrtl_ebnf_star_to_bnf_for_grammar( /* tCOMAR *c, boolean LR */ );


/* Part III : Function for transforming the whole grammar    */

/* cmrtl_ebnf_grammar_to_bnf - transforms the whole grammar to BNF
 * on entry: 
 *   LR == TRUE  => production shall be transformed using left recursion
 *   LR == FALSE => production shall be transformed using right recursion
 *
 * on exit:
 *   BNF grammar is available in DIDTABLE and structural equivalences 
 *   are substituted by the same nonterminal.
 *   returns CMR_SUCCESS if transformation succeeds
 *           error number otherwise
 */
extern int cmrtl_ebnf_grammar_to_bnf( /* tCOMAR *c, boolean LR */ );



