/*
** $Id: default.c,v 1.2 90/10/23 14:39:59 cogito Exp $
*/
static char rcs_id[]= "$Id: default.c,v 1.2 90/10/23 14:39:59 cogito Exp $";

#include <stdio.h>
#include "ccomar.h"
#include "ccomarl.h"
#include "privlib.h"
#include "default.h"


/**************************************************************************/
/*                        global variables                                */
/**************************************************************************/

static DID defaultdid = -1;
static SID defaultvalsid = -1;



/**************************************************************************/
/*             private functions for default evaluation                   */
/**************************************************************************/

#define OLDVAL 01
#define NEWVAL 02
#define STATUS 04


static int get_old_default_val(c, nt)
tCOMAR *c;
DID nt;
{
  tCOMAR *prop;
  int d;

  if ((prop = cmr_get_prop(c, nt, defaultvalsid)) == (tCOMAR *)NULL)
    return(CMR_UNKERR);

  if ((d = cmr_get_nval_val(cmr_get_prop_val(prop))) == CMR_UNKERR) 
    return(CMR_UNKERR); 
  return((d & OLDVAL) > 0);
}


static int get_new_default_val(c, nt)
tCOMAR *c; 
DID nt;
{
  tCOMAR *prop;
  int d;

  if ((prop = cmr_get_prop(c, nt, defaultvalsid)) == (tCOMAR *)NULL) 
    return(CMR_UNKERR);

  if ((d = cmr_get_nval_val(cmr_get_prop_val(prop))) == CMR_UNKERR) 
    return(CMR_UNKERR); 

  return((d & NEWVAL) > 0);
}


static int get_status_default_val(c, nt)
tCOMAR *c;
DID nt;
{
  tCOMAR *prop;
  int d;

  if ((prop = cmr_get_prop(c, nt, defaultvalsid)) == (tCOMAR *)NULL)
    return(CMR_UNKERR);

  if ((d = cmr_get_nval_val(cmr_get_prop_val(prop))) == CMR_UNKERR)
    return(CMR_UNKERR);

  return((d & STATUS) > 0);
}


static int set_old_default_val(c, nt)
tCOMAR *c;
DID nt;
{
  tCOMAR *prop, *head;
  int d;

  if ((prop = cmr_get_prop(c, nt, defaultvalsid)) == (tCOMAR *)NULL)
    return(CMR_UNKERR);

  if ((d = cmr_get_nval_val(head = cmr_get_prop_val(prop))) == CMR_UNKERR) 
    return(CMR_UNKERR);

  d |= OLDVAL;
  (void) cmr_set_nval_val(head, d);

  return(CMR_SUCCESS);
}


static int set_new_default_val(c, nt) 
tCOMAR *c; 
DID nt; 
{
  tCOMAR *prop, *head;
  int d;

  if ((prop = cmr_get_prop(c, nt, defaultvalsid)) == (tCOMAR *)NULL)
    return(CMR_UNKERR);

  if ((d = cmr_get_nval_val(head = cmr_get_prop_val(prop))) == CMR_UNKERR)
    return(CMR_UNKERR);

  d |= NEWVAL;
  (void) cmr_set_nval_val(head, d);

  return(CMR_SUCCESS);
}


static int set_status_default_val(c, nt)
tCOMAR *c;
DID nt;
{
  tCOMAR *prop, *head;
  int d;

  if ((prop = cmr_get_prop(c, nt, defaultvalsid)) == (tCOMAR *)NULL)
    return(CMR_UNKERR);

  if ((d = cmr_get_nval_val(head = cmr_get_prop_val(prop))) == CMR_UNKERR)
    return(CMR_UNKERR);

  d |= STATUS;
  (void) cmr_set_nval_val(head, d);

  return(CMR_SUCCESS);
}


/*************************************************************************/
/*        exported functions for determining default rules               */
/*************************************************************************/


int cmrtl_default_on_dlist(c, dlist, ready)
tCOMAR *c, *dlist;
boolean *ready;
{
  return(cmrtl_default_on_list(c, cmr_get_begin_list(dlist), ready));
}


int cmrtl_default_on_list(c, list, ready)
tCOMAR *c, *list;
boolean *ready;
{
  int i, j;

  if (list == (tCOMAR *)NULL) return(1);

  if ((i = cmrtl_default_on_subtr(c, cmr_list_head(list), ready))
       == CMR_UNKERR)  return(CMR_UNKERR);
  
  if (i == 0 && !(*ready))
    return(0);

  if ((j = cmrtl_default_on_list(c, cmr_list_tail(list), ready))
       == CMR_UNKERR)  return(CMR_UNKERR);

  return(i*j);
}


int cmrtl_default_on_subtr(c, subtr, ready)
tCOMAR *c, *subtr;
boolean *ready;
{
  switch (cmr_get_tag(subtr))
  {
    case P_OPT   : if (cmrtl_default_on_dlist
		       (c, cmr_get_opt_units(subtr), ready) == CMR_UNKERR)
		     return(CMR_UNKERR);
                   return(1);
    case P_STAR  : if (cmrtl_default_on_dlist
		       (c, cmr_get_star_units(subtr), ready) == CMR_UNKERR)
		     return(CMR_UNKERR);
		   return(1);
    case P_PLUS  : return(cmrtl_default_on_dlist
			  (c, cmr_get_plus_units(subtr), ready));
    case P_DELREP: { 
		     int result;

		     if ((result = cmrtl_default_on_dlist
			  (c, cmr_get_delrep_units1(subtr), ready))
			  == CMR_UNKERR)  
		       return(CMR_UNKERR);
                     if (cmrtl_default_on_dlist
			 (c, cmr_get_delrep_units2(subtr), ready) == CMR_UNKERR)
		       return(CMR_UNKERR);
                     return(result);
                   }
    case P_ALT   : 
                   {
                     /*  reference-level incremented by Kalle */
                     tCOMAR **units1, **units2;

                     int result1, result2;

                     units1 = cmr_get_adr_of_alt_units1(subtr);
                     units2 = cmr_get_adr_of_alt_units2(subtr);

                     if ((result1 = cmrtl_default_on_dlist(c, *units1, ready))
                          == CMR_UNKERR)  return(CMR_UNKERR);

                     if ((result2 = cmrtl_default_on_dlist(c, *units2, ready))
                          == CMR_UNKERR)  return(CMR_UNKERR);

                     if (result1)
                     {
                       if (!cmrl_otherdid_in_dlist(c, *units1, defaultdid)
			   && !cmrl_otherdid_in_dlist(c, *units2, defaultdid))
                       {
                         tCOMAR *q = cmr_get_begin_list(*units1);

                         q = cmr_add_to_list(q, cmr_new_elunit(defaultdid));
                         (void) cmr_set_begin_list(*units1, q);
                       }
                     }
                     else
                     if (result2)
                     {
                       if (!cmrl_otherdid_in_dlist(c, *units2, defaultdid))
                       {
                         tCOMAR *q = cmr_get_begin_list(*units2);

                         q = cmr_add_to_list(q, cmr_new_elunit(defaultdid));
                         (void) cmr_set_begin_list(*units2, q);
                       }
                     }

                     if (!result1 && !result2)
                     *ready = FALSE;

                     if (result1)
		       return(result1);

                     return(result2);
                   }
    
    case P_ELUNIT: {
		     DID elem;
                     int tag;

                     if ((tag = cmr_get_def_entry_tag(c, elem = cmr_get_elunit_elem(subtr))) 
			  == P_TERM || tag == P_OTHER)
		       return(1);

                     if (tag == P_NTERM)
		       return(get_old_default_val(c, elem));

                     return(CMR_UNKERR);
                   }
    default      : return(CMR_UNKERR);
  }
}


int cmrtl_default_for_nterm(c, nt)
tCOMAR *c;
DID nt;
{
  DID prod;
  int val;
  boolean ready = TRUE;

  /*  reference-level incremented by Kalle */
  tCOMAR **units;

  if ((val = get_status_default_val(c, nt)) == CMR_UNKERR)
    return(CMR_UNKERR);
  if (val) 
    return(CMR_SUCCESS);

  prod = cmrl_first_prod_with_lhs(c, nt);

  while (prod != -1)
  {
    /* The following two statements are changed by Kalle. */
    units = cmr_get_adr_of_prod_units(c, prod);
    if ( (val = cmrtl_default_on_dlist(c, *units, &ready)) == CMR_UNKERR)
      return(CMR_UNKERR);

    if (val == 1 && !cmrl_otherdid_in_dlist(c, *units, defaultdid)
	&& get_new_default_val(c, nt) != 1)
    {
      tCOMAR *q = cmr_get_begin_list(*units);

      q = cmr_add_to_list(q, cmr_new_elunit(defaultdid));
      (void) cmr_set_begin_list(*units, q);

      if (set_new_default_val(c, nt) == CMR_UNKERR)
	return(CMR_UNKERR);
    }

    prod = cmrl_next_prod_with_lhs(c, prod, nt);
  }

  if (get_new_default_val(c, nt) != 1)
    ready = FALSE;
  if (ready)
    (void) set_status_default_val(c, nt);

  return(CMR_SUCCESS); 
}


int cmrtl_default_init(c)
tCOMAR *c;
{
  SID defaultsid = cmrl_add_name(c, DEFAULT);
  DID d;
  DID nt;

  if ((defaultvalsid = cmrl_add_name(c, DEFAULTVAL))
       == CMR_UNKERR)  return(CMR_UNKERR);

  if ((d = cmrl_sid_to_firstdid(c, defaultsid)) == CMR_UNKERR)
    defaultdid = cmr_new_def_entry(c, P_OTHER, defaultsid);
  else
  {
    if (cmr_get_def_entry_tag(c, d) != P_OTHER)
      return(CMR_UNKERR);
    else
      defaultdid = d;
  }

  nt = cmrl_first_nterm(c);
  while (nt != -1)
  {
    if (cmr_new_prop_val(c, nt, defaultvalsid, cmr_new_nval(0)) != nt)
      return(CMR_UNKERR);

    nt = cmrl_next_nterm(c, nt);
  }

  return(CMR_SUCCESS);
}


int cmrtl_default_for_grammar(c)
tCOMAR *c;
{
  int stat;
  int numberofnt = cmrl_get_number_of_nterms(c);
  boolean ready = FALSE;
  boolean changed = FALSE;
  int i;
  DID nt;

  if ((stat = cmrtl_default_init(c)) != CMR_SUCCESS)
    return(stat);
  i = 1;

  while (i <= numberofnt && (!ready || !changed))
  {
    nt = cmrl_first_nterm(c);

    while (nt != -1)
    {
      if ((stat = cmrtl_default_for_nterm(c, nt))
	   != CMR_SUCCESS)  return(stat);

      nt = cmrl_next_nterm(c, nt);
    }

    nt = cmrl_first_nterm(c);
    ready = TRUE;
    changed = FALSE;

    while (nt != -1) 
    {
      int old = get_old_default_val(c, nt);
      int new = get_new_default_val(c, nt);
      int status = get_status_default_val(c, nt);

      ready   = ready && status;
      changed = changed || (old != new);

      if (old != new)
	(void) set_old_default_val(c, nt);

      nt = cmrl_next_nterm(c, nt);
    }

    i++;
  }

  nt = cmrl_first_nterm(c);

  stat = CMR_SUCCESS;

  while (nt != -1)
  {
    int old;
    old = get_old_default_val(c, nt);
    if (old == 0)
    {
      fprintf(stderr, "%s can not be terminalized\n", cmrl_didtosymb(c, nt));
      stat = CMRTL_NOTERMIN;
    }

    nt = cmrl_next_nterm(c, nt);
  }

  return(stat);
}

