/*
** $Id: ccomarf.h,v 1.2 90/10/23 11:36:26 cogito Exp $
*/

/* ccomarf.h - interface to COMAR routines for formatted grammar output */

#ifndef ccomarf_DEF
#define ccomarf_DEF


/* Exported definitions: */

/* Condition codes : */
#define CMRF_SUCCESS	0
#define CMRF_PRTERR	-1
#ifdef DEBUG
#define DBG_PRTERR	-1
#endif

/* codes for indicating output styles: */
#define FMT_EBNF	0
#define FMT_PGS		1
#define FMT_ALA		2
#define FMT_YACC	3

/* codes for indicating literals:	EBNF	PGS	ALA	YACC    */
#define FMT_IST		0	/* 	"::="	":" 	"::"	":"     */
#define FMT_ORT		1	/*	"|"	"/"	"?"	"|"	*/
#define FMT_SEPT	2	/*	"||" 	"//"	"//"	"?"	*/
#define FMT_ENDPT	3	/*	"."	"."	""	";"	*/

      /* where "?" ==> error, construct not allowed in grammars */


extern int (*pr_other)();	/* See cmrf_pr_init() below */

/* Where applicable in the following symbol printing routines, the following
 * entry and exit conditions hold (ie, unless redefined or arg irrelevant):
 *	entry:	pr_other == address of "other" printing routine; any static
 *		    data structures of that routine have been initialized.
 *		f is open for writing.
 *		c is a COMAR structure.
 *		l == the remaining length of current output line.
 *		maxlin == maximum output line length.
 *		indent == number of spaces to indent rule continuation lines.
 *		style == one of { FMT_EBNF, FMT_PGS, FMT_ALA, FMT_YACC }.
 *		rhsbrk ==> printing of rhs starts new line (w/ indent blanks).
 *	exit:	if the did identifies a definition of the correct type
 *		    if the symbol mapped to its sid has length less than l then
 *		        the symbol has been written to f,
 *		    else '\n' has been written to f, followed by the symbol. 
 *		    return value == the number of characters remaining 
 *			on the current output line.
 *		else return == CMRF_PRTERR.
 */


/* cmrf_pr_didsymb - print the symbol mapped to sid of def_entry of did
 *	entry:	did identifies a definition in c.
 */
extern int cmrf_pr_didsymb( /* FILE *f; p_comar c; DID did; 
				int l, maxlin, indent; */);


/* cmrf_pr_other - default "other" print function, uses PGS conventions.
 *	entry:	did identifies an "other" def_entry in c.
 */
extern int cmrf_pr_other( /* FILE *f; p_comar c; DID did; 
				int l, maxlin, indent; */ );


/* cmrf_pr_noother - alternative "other" printer - skip printing "others" */
extern int cmrf_pr_noother( /* FILE *f; p_comar c; DID did; 
				int l, maxlin, indent; */ );


/* cmrf_pr_prod - print production identified by did.
 *	exit:	if did identifies a production definition in c then
 *		    that production has been printed using style specified
 *		    one '\n'follows the production.
 *		    cmrf_pr_prod == CMR_SUCCESS.
 *		else cmrf_pr_prod == CMRF_PRTERR.
 */
extern int cmrf_pr_prod( /* FILE *f; p_comar c; DID did; 
				int maxlin, indent, style; boolean rhsbrk; */);


/* cmrf_pr_grammar - print grammar rules represented by COMAR structure c
 *	entry:	global pr_init == a function for initializing printing
 *		    of other symbols (see cmrf_pr_init below).
 *	exit:	if c identifies a COMAR structure then
 *		    the grammar represented by that structure has been printed
 *		    cmrf_pr_grammar == CMR_SUCCESS.
 *		else cmrf_pr_grammar == CMRF_PRTERR.
 */
extern int cmrf_pr_grammar( /* FILE *f; p_comar c; int maxlin, indent, style;
				boolean rhsbrk; void (*pr_init)(); */ );


/* cmrf_pr_init - default initialization routine for printing p_other's. 
 *	exit:	if (cmrf_pr_init == CMR_SUCCESS) then
 *		    global pr_other == cmrf_pr_other().
 *		    static data structures used by that function have been 
 *		    initialized.
 *	Note:	the above conditions should be met by any alternate function
 *		    for initializing a different "other" printing function.
 */
extern int cmrf_pr_init( /* p_comar c; */ );


/* alternative routine initializes pr_other to cmrf_pr_noother() */
extern int cmrf_pr_noinit( /* p_comar c; */ );


#endif !ccomarf_DEF
