/*
** $Id: grammarcomp.h,v 1.3 1991/12/02 17:43:30 cogito Exp $
*/

/***************************************************************************/
/* File: grammarcomp.h	First Edit: 18.11.88	  Last Edit: 17.02.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change:	10.08.89 from Kalle					   */
/***************************************************************************/

#ifndef	grammarcomp_DEF
#define	grammarcomp_DEF


/* Look at "default.h" to find 'cmrtl_default_for_grammar()' - a function
 * related to this file and used by 'cmrtl_grammar_comp()'
 */



/***************************************************************************/
/* Imported variables, which MUST(!) be initialized before executing	   */
/*		   the exported functions except 'cmrtl_grammar_comp()'.   */
/***************************************************************************/

/* Global variables defined in "cmrlib" */

extern	SEQdef_entry	TERM_SEQ; /* initialized by cmrlib_arrangedefs() */
extern	SEQdef_entry	NTERM_SEQ;
extern	SEQdef_entry	OTHER_SEQ;
extern	SEQdef_entry	PROD_SEQ;

/* The following variables are not used by 'cmrtl_compute_startprod()' */
extern	Indextype	MAXNTERM;  /* init. by cmrlib_compute_globarrs() */
extern	ARRIndextype	INDEX;
extern	ARRSEQdef_entry	PRODWITHLHS;
extern	ARRdef_entry	DEFTBL;

/* 'CMR' will be used by all follow. functions but needn't be init. before */
extern	p_comar	CMR;		  /* init. by cmrlib_changeglobalcmrvar() */


/***************************************************************************/
/* Exported headlines, errorcodes and functions:			   */
/***************************************************************************/

#define CMR_HEADLINE_ALL	"GRAMMAR IS AUGMENTED, REDUCED AND ORDERED"
#define CMR_HEADLINE_ST		"GRAMMAR IS AUGMENTED"
#define CMR_HEADLINE_RED	"GRAMMAR IS AUGMENTED AND REDUCED"
#define CMR_HEADLINE_ORD	"GRAMMAR HAS A PARTITIAL RULEORDER"
#define CMR_HEADLINE_ORDST	"GRAMMAR IS AUGMENTED AND ORDERED"

extern	p_prod	STARTPROD; /* Computed of cmrtl_grammar_comp(c,TRUE,X,Y,info) */


/* SECTION 1 */

/* errorcodes */
#define ST_NOSTSYM	-21
		/* No startsymbol can be determined. */
#define ST_AMBSTSYM	-22
		/* More than one startsymbol are determined. */
#define ST_AMBSTPROD	-23
		/* More than one startproduction are determined. */
#define ST_NOTBNFSTPROD	-24
		/* Determined startproduction is not BNF. */
#define ST_EOFNOTERM	-25
		/* The 'EOF'-symbol determined as the last symbol of the
		 * startproduction is not a terminal.
		 */
#define ST_AMBEOF	-26
		/* More than one def_entry of the 'EOF'-symbol exists. */
#define ST_EOFERR	-27
		/* The 'EOF'-symbol can be also found in other positions
		 * than the end of the startproduction.
		 */


/* 'cmrtl_compute_startprod()' computes the startproduction of the grammar
 * encoded in COMAR-structure 'c':
 * 	*startprod: the computed startproduction, except if
 *		    return == ( ST_NOSTSYM || ST_AMBSTSYM || ST_AMBSTPROD )
 * return == CMR_SUCCESS, if 'c' contains a correct startproduction
 *        == one of the above errorcodes, otherwise
 */
extern	ERR	cmrtl_compute_startprod(/* p_comar c, p_prod *startprod */);


/* SECTION 2 */

/* errorcodes */
#define GR_NOTREACH	-31
		/* Not all nonterminals can be reached from startsymbol */

/* 'cmrtl_reachibility()' checks whether all nonterminals are reachable
 * in a derivation from startsymbol with index 'startdid':
 * return == CMR_SUCCESS , if check yields a positiv answer
 * 	  == GR_NOTREACH , otherwise
 * Output of the unreachable nonterminals on stderr!
 */
extern	ERR	cmrtl_reachibility(/* p_comar c, DID startdid */);


/* SECTION 3 */

/* errorcodes */
#define GR_NOTBNF	-32
		/* Grammar is not in BNF */
#define GR_NODEFAULT	-33
		/* Use cmrtl_default_for_grammar() to compute the
		 * default-productions
		 */
#define GR_NTHASNOPROD	-34
		/* There exists a nonterminal without a production */
#define GR_ORDER_EXIST	-35
		/* There exists a property with name ORDER not convenient
		 * to this application
		 */

/* name of the property computed by cmrtl_partitial_ruleorder() */
#define ORDER	"_ORDER"

extern	ERR	cmrtl_partitial_ruleorder(/* p_comar c */);


#endif		/* of grammarcomp_DEF */


/* SECTION 4 */

/* errorcodes */
#define GR_NOTREDUCED	-36
		/* Grammar is not reduced because of both possible 
		 * conditions: GR_NOTREACH and CMRTL_NOTERMIN
		 */

/* Note:
 *  'cmrtl_grammar_comp()' initializes itself the above imported variables.
 *
 *  if ( start ):	'cmrtl_compute_startprod()' will be executed.
 *  if ( reach ):	'cmrtl_reachibility()' and
 *			'cmrtl_default_for_grammar()' will be executed.
 *  if ( order ):	'cmrtl_partitial_ruleorder()' will be executed.
 *
 *  return == if error, one of all above or in "default.h" errorcodes
 *	      oterwise, CMR_SUCCESS
 */
extern	ERR	cmrtl_grammar_comp(/*p_comar c; Boolean start, reach, order;
							 char toolinfo[] */);
