/*
** $Id: firstset.c,v 1.3 91/05/22 16:59:35 cogito Exp $
*/
static char rcs_id[]= "$Id: firstset.c,v 1.3 91/05/22 16:59:35 cogito Exp $";

/***************************************************************************/
/* File: firstset.c	First Edit: 27.02.89	  Last Edit: 31.03.89      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change: 24.04.89	From: Karl-Josef Prott			   */
/***************************************************************************/

#include <stdio.h>

#include "comar.h"
#include "cmrlib.h"
#include "cmrio.h"	/* defintion of CMR_OPNERR */
#include "privatlib.h"
#include "bitset.h"

#include "first.h"
#include "firstset.h"


ARRBitSet	FIRSTSETS = (ARRBitSet)NULL;

unsigned short	SIZEFIRSTSETS = NULL;

void	freeFIRSTSETS()
{
  unsigned short	i;

  for (i=0; i<SIZEFIRSTSETS; i++)
    FreeSet(FIRSTSETS[i]);

  free( (char *)FIRSTSETS );

  return;
}  /* end of freeFIRSTSETS() */

ERR	computeFIRSTSETS(c)
p_comar	c;
{
  p_comar	sav;
  p_name	firstname;
  unsigned short i;
  SEQdef_entry	d_travel;
  def_entry	nt;
  p_prop_val	firstprop;
  SEQvalue	v_travel;
  value		val;

  sav = cmrlib_changeglobalcmrvar(c);	/* initializing of CMR */

  if ( (firstname = cmrlib_strtopname(CMR->symbols, FIRSTTRANSCLOS))
	== (p_name)NULL )
    return(FIR_UNK);

  /* creating an array of empty BitSets indexed by nonterminals */
  if ( FIRSTSETS != (ARRBitSet)NULL )
    freeFIRSTSETS();

  SIZEFIRSTSETS = MAXNTERM;
  if ( (FIRSTSETS = (ARRBitSet)malloc(MAXNTERM*sizeof(BitSet)))
	== (ARRBitSet)NULL )
    {
      INT_ALLOC_ERR("computeFIRSTSETS()");
      exit(1);
    }
  for (i=0; i<MAXNTERM; i++)
    FIRSTSETS[i] = MakeEmptySet(MAXTERM);

  foreachinSEQdef_entry(NTERM_SEQ, d_travel, nt)
    {
#ifdef DEBUG_FIR
      if ( typeof(nt) != Kp_nterm )
	INT_TAG_ERR("computeFIRSTSETS_1()",typeof(nt));
#endif
      if ((firstprop = cmrlib_sidtopropval(nt.Vp_nterm->prop,
					   (SID)firstname->sid))
	    == (p_prop_val)NULL )
	return(FIR_INCOMPL);
      foreachinSEQvalue(firstprop->val.Vp_lval->list, v_travel, val)
	{
#ifdef DEBUG_FIR
          if ( typeof(val) != Kp_dval )
	    INT_TAG_ERR("computeFIRSTSETS_2()",typeof(val));
#endif
	  if ( typeof( DEFTBL[val.Vp_dval->did]) == Kp_term )
	    (void)AddElemToSet(INDEX[val.Vp_dval->did],
			       FIRSTSETS[INDEX[nt.Vp_nterm->did]]);
	}  /* end of for */
    }  /* end of for */

  (void)cmrlib_changeglobalcmrvar(sav);/* reinit. of CMR to old value */
  return(CMR_SUCCESS);

}  /* end of computeFIRSTSETS() */


ERR	cmrtl_compute_first(c, filename)
p_comar	c;
String	filename;
{
  p_comar	sav;
  short		stat;
  SEQdef_entry	travel;
  def_entry	def;
  FILE		*f;
  p_name	firsttransname;

  sav = cmrlib_changeglobalcmrvar(c);	/* initializing of CMR */

  if ( (stat = cmrtl_first_for_grammar(CMR))  !=  CMR_SUCCESS )
    return(stat);

  foreachinSEQdef_entry(CMR->definitions, travel, def)
    if ( typeof(def) == Kp_nterm )
      if ( (int)cmrtl_first_trans_closure_for_nt(CMR, def.Vp_nterm->did)
	    == NULL )
	{
          priv_generrstr(FIR_TRANSCLOSERR, priv_deftostr(def));
	  stat = FIR_TRANSCLOSERR;
	}
  /* end of for */
  if ( stat != CMR_SUCCESS )
    return( stat );

  if ( *filename != '\0' )
    {
      if ( (f = fopen(filename, "w")) == (FILE *)NULL )
        { 
          priv_generrstr(CMR_OPNERR, filename);
          exit(1);
        }
      firsttransname = cmrlib_strtopname(CMR->symbols,FIRSTTRANSCLOS);

      foreachinSEQdef_entry(CMR->definitions, travel, def)
	if ( typeof(def) == Kp_nterm )
          if ( cmrtl_write_property(f,CMR,def.Vp_nterm->did,
				    firsttransname->sid)  != CMR_SUCCESS )
	    {
	      stat = FIR_WRTERR;
	    }
      /* end of for */
    }  /* end of if */

  (void)cmrlib_changeglobalcmrvar(sav);/* reinit. of CMR to old value */
  return(stat);
}  /* end of cmrtl_compute_first() */
