/*
** $Id: ebnf2bnf.c,v 1.3 91/05/22 16:58:38 cogito Exp $
*/
static char rcs_id[]= "$Id: ebnf2bnf.c,v 1.3 91/05/22 16:58:38 cogito Exp $";

/***************************************************************************/
/* File: ebnf2bnf.c	First Edit: 23.08.90	  Last Edit: 23.08.90      */
/*									   */
/* Author: Karl-Josef Prott,	University at Paderborn, Germany	   */
/*									   */
/* Last Change: 23.08.90	From: Karl-Josef Prott			   */
/***************************************************************************/


#include <stdio.h>
#include <strings.h>

#include "comar.h"
#include "cmrio.h"
#include "privatlib.h"

#include "ebnf.h"
#include "filter.h"

main(argc, argv)
int argc;
char *argv[];
{
  char		tool_info[MAX_TOOL_INFO];
  short		stat;

   if (argc != 2) {
      (void)fprintf(stderr, "Usage %s comarfile\n", argv[0]);
      exit(1);
   }

  /* input of the COMAR-data-structure */
  if ((stat = cmrlib_read(argv[1], tool_info, &CMR)) != CMR_SUCCESS)
    {
      priv_generrstr(stat, argv[1]);
      exit(1);
    }


  /* EBNF to BNF transformation */
  if ( (stat = cmrtl_ebnf_grammar_to_bnf(CMR, TRUE))
        !=  CMR_SUCCESS )
    {
      priv_generrstr(stat, "cmrtl_ebnf_grammar_to_bnf()");
      exit(1);
    }

  /* Adjusting the old COMAR-tool to the new ones by
   * changing the epsilon-representation */
  removeEmpty(CMR);


  /* output of the COMAR-data-structure */
  if ( (stat = cmrlib_write(priv_genfilename(argv[1], ".bnf"), ".bnf", CMR))
	!= CMR_SUCCESS )
      { 
	priv_generrstr(stat, priv_genfilename(argv[1], ".bnf"));
        exit(1);
      }

  exit(0);
}


