/*
** $Id: tabsopttype.h,v 1.3 1992/01/10 16:14:09 cogito Exp $
*/

/******************************************************************************/
/* filename: tabsopttype.h                    first edit   : 28 . 9 . 89      */
/* author  : Christian Zeitel                 last change  : 10 . 7 . 90      */
/******************************************************************************/

/******************************** CONTENTS ************************************* *                                                                             * *  This file contains two typedefinitions :				       *
 *  "opttpye" is the typedefinition for the interface between the modules      *
 *  <optimize parsertables> and <print parsertables> of the generator for      *
 *  the tabledriven LALR(1)-parser. 					       *
 *  "optkindtype" is typedefinition for selecting a special optimization-      *
 *  method by the user.							       *
 *									       *
 ******************************************************************************/
 

typedef  struct  {

        char *ttaboptkind; /* name for terminaltableoptimization    */
        char *ntaboptkind; /* name for nonterminaltableoptimization */
        char  chainrule;   /* if notzero the chainrule-elimination  */
                           /* is performed, isn't implemented yet   */
        
} optkindtype;




typedef  struct  {

		union  {
		/* the variable "ttabopt" contains the datas needed for a */
		/* special optimization-method for the  terminal-table    */
		
		  	 struct  { 
		  	 
		  	 	short *sigrowind,
		  	 	      *sigrowptr,
		  	 	       sigmaxrowind,
		  	 	      *sigcolind,
		  	 	      *sigcolptr,
		  	 	       sigmaxcolind,
		  	 	      
		  	 	      *rowind,
		  	 	       maxrowind,
		  	 	      *colind,
		  	 	       maxcolind,
		  	 	       
		  	 	      *ttab,
		  	 	      
		  	 	      *convtermlist;
		  	 	       
		  	 } GCS; /* Graph Colouring Scheme      */
		  	 
		  	 
		  	 
		  	 struct  {
		  	 	
		  	 	short *sigrowind,
		  	 	      *sigrowptr,
		  	 	       sigmaxrowind,
		  	 	      *sigcolind,
		  	 	      *sigcolptr,
		  	 	       sigmaxcolind,
		  	 
		  	 	      *decrow,
		  	 	      *deccol,
		  	 	      *rowval,
		  	 	      *colval,
		  	 	       elrows,
		  	 	       elcols,
		  	 	       scans,
		  	 	      
		  	 	      *convtermlist;
		  	 	
		  	 } LES; /* Line Elimination Scheme     */
		  	 
		  	 
		  	 
		  	 struct  {
		  	 
		  	        short *sigrowind,
		  	 	      *sigrowptr,
		  	 	       sigmaxrowind,
		  	 	      *sigcolind,
		  	 	      *sigcolptr,
		  	 	       sigmaxcolind,
		  	 
		  	              *ttab;
				int   *rowptr,
			               size;
				
				short *convtermlist;

		  	 } RDS; /* Row Displacement Scheme     */
		  	 
		  	 
		  	 
		  	 struct  {
		  	 
		  	 	short *firstptr,
				      *lastptr;
				int   *rowptr;

				short *convtermlist;

		  	 } SDS; /* Significant Distance Scheme */
		  	 
		  	 
		  	 struct  {
		  	 
		  	 	short  *rowptr,
		  	 	       *rowind,
		  	 	        maxrowind;
		  	 	        
		  	 } RCS; /* Row Collumn Scheme         */
		  	  
		} ttabopt;
		
		
		
		
		union  {
		/* the variable "ntabopt" contains the datas needed for a */
		/* special optimization-method for the nonterminal-table  */
		
		  	 struct  { 
		  	 	      
		  	 	short *rowind,
		  	 	       maxrowind,
		  	 	      *colind,
		  	 	       maxcolind,
		  	 	      
		  	 	      *ntab;
		  	 	       
		  	 } GCS; /* Graph Colouring Scheme       */
		  	 
		  	 
		  	 
		  	 struct  {
		  	 
		  	 	short *decrow,
		  	 	      *deccol,
		  	 	      *rowval,
		  	 	      *colval,
		  	 	       elrows,
		  	 	       elcols,
		  	 	       scans;
		  	 	
		  	 } LES; /* Line Elimination Scheme      */
		  	 
		  	 
		  	 
		  	 struct  {
		  	 
		  	 	short *ntab;
                                int   *rowptr,
                                       size;
		  	 	
		  	 } RDS; /* Row Displacement Scheme          */
		  	 
		  	 
		  	 
		  	 struct  {
		  	 
		  	 	short *firstptr,
                                      *lastptr;
                                int   *rowptr;
		  	 	
		  	 } SDS; /* Significant Distance Scheme  */
		  	 
		  	 
		  	 struct  {
		  	 
		  	 	short  *rowptr,
		  	 	       *rowind,
		  	 	        maxrowind;
		  	 	        
		  	 } RCS; /* Row Collumn Scheme          */
		  	 
		  	 
		} ntabopt;
		
		
		
} opttype;
