/***************************************************************************/
/* filename : write_help.c                         first edit  : 16.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 02.07.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: write_help.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

#include<stdio.h>

#include "over.h"

#include "over_types.h"

#include "out.h"

/****************************** FUNCTIONS **********************************/



void Print_If( fp,user_data,out_list,pos,space,eq_string,shred_mark,
	       shift_mark,default_mark,comp,called_from_error,sx_code_list,
               seman_list,extra_info)

   FILE                           *fp;  /* file pointer to the external
					   output file, where the complete
					   parser should be written        */
   struct equality          *out_list;  /* pointer to structure equality,
					   which represents a part of code,
					   where some comparisons lead
					   through                         */
   char_ptr               *seman_list;  /* a list of pointer to the 
                                           semantic actions                */
   struct user             *user_data;  /* internal interface vector, which
					   saves information fixed by the
					   user                            */
   short                          pos,  /* position in vector out_list
					   which should be printed out yet */
                        *sx_code_list,  /* used to convert internal to
                                           external syntax code            */
      				space;  /* the number of blanks which should
					   be printed out, before some code
					   will be printed                 */
   char                    *eq_string,  /* the string which should compared
					   with other data                 */
			  *shred_mark,  /* this string would be printed
					   out, if a jump to a reduce -
					   mark should be passed through   */
			  *shift_mark,  /* this string would be printed
					   out, if a jump to a shift -
					   mark should be passed through    */
			*default_mark,  /* this string would be printed
					   out, if a jump to a default -
					   mark ( no reduce - and no shift
					   - mark ) should be passed through*/
				 comp,  /* if comp == 1 then the code is
					   compressed and then a default
					   action exists                   */
		    called_from_error,  /* used to decide if this function
					   is called from the error recovery
					   writing routine or not          */
			   extra_info;  /* if extra_info == 1, then extra
					   information about begin and end
					   of function is printed out     */







/* This function is used by modul Write_Parser and Write_Error. The
   user can choose out of three ways to print the parser code.
   First Normal If, second Binary If and third Case Switch Construct.
   This fixes the way of printing out lists of long comparisons. This
   function is used to print one element of a comparison list, if
   Normal If or Binary If is choosen.
*/


   {
     short  loop,  /* loop index                                           */
	     len;  /* loop index                                           */

     if( extra_info )
	printf("begin of function Print_If( )\n");


     if( !(IS_SHRED_NTACT( out_list[pos].eq_elem )) )
	if( IS_ACCEPTACT( out_list[pos].eq_elem ) )
	   {
	     for( loop=0;loop<space;loop++ )
		fprintf(fp,"   ");
             if( !(IS_REDUCEACT( out_list[pos].action.goto_action )) )
	        fprintf(fp,"if (%s == %d) ACCEPT();\n",
		        eq_string,((sx_code_list == NULL) ? 
		        (OPERAND( out_list[pos].eq_elem )) :
                        (sx_code_list[OPERAND( out_list[pos].
                        eq_elem )])) );
             else
                {
	          fprintf(fp,"if (%s == %d)\n",
		          eq_string,((sx_code_list == NULL) ? 
		          (OPERAND( out_list[pos].eq_elem )) :
                          (sx_code_list[OPERAND( out_list[pos].
                          eq_elem )])) );
	          for( loop=0;loop<space;loop++ )
		     fprintf(fp,"   ");
                  fprintf(fp,"   {\n");
	          for( loop=0;loop<space;loop++ )
		     fprintf(fp,"   ");
                  if( user_data->direct_struct_connection )
                     fprintf(fp,"   %s\n",
                             seman_list[OPERAND( out_list[pos].
                                                 action.goto_action )] );
                  else
                     fprintf(fp,"     SEMANTIC( %d );\n",
                             OPERAND( out_list[pos].action.goto_action ));
	          for( loop=0;loop<space;loop++ )
		     fprintf(fp,"   ");
                  fprintf(fp,"     ACCEPT();\n");
	          for( loop=0;loop<space;loop++ )
		     fprintf(fp,"   ");
                  fprintf(fp,"   }\n");

                } /* end of else ( if( !(IS_REDUCEA... ) */
	   } /* end of if( IS_ACCEPTAC... */
	else
	   {
	     for( loop=0;loop<space;loop++ )
		fprintf(fp,"   ");
	     if( comp )
                if( called_from_error )
                   fprintf(fp,"action = %d; break;\n",
                           out_list[pos].action.goto_action );

                else
		     fprintf(fp,"goto %s_%d;\n",
			     shift_mark,
			     out_list[pos].action.goto_action );
	     else
                if( called_from_error )
		   fprintf(fp,"if (%s == %d) { action = %d; break; }\n",
			   eq_string,
                           ((sx_code_list == NULL) ? 
		           (OPERAND( out_list[pos].eq_elem )) :
                           (sx_code_list[OPERAND( out_list[pos].eq_elem )])),
			   out_list[pos].action.goto_action );
                else
		   fprintf(fp,"if (%s == %d) goto %s_%d;\n",
			   eq_string,
                           ((sx_code_list == NULL) ? 
		           (OPERAND( out_list[pos].eq_elem )) :
                           (sx_code_list[OPERAND( out_list[pos].eq_elem )])),
			   shift_mark,
			   out_list[pos].action.goto_action );
	   } /* end of else ( if( IS_ACCEPTAC... ) */
     else
	if( !(out_list[pos].action.new_red_sit->pop)               &&
	    !(IS_SEM( out_list[pos].action.new_red_sit->sem ))     &&
	    !(IS_SEM( out_list[pos].action.new_red_sit->old_sem )) &&
	    !comp                                                  	&&
	    (((IS_REDUCEACT( out_list[pos].
			      action.new_red_sit->sem )) &&
	      !(out_list[pos].action.new_red_sit->scan)  )  ||
	     (!(IS_REDUCEACT( out_list[pos].
			      action.new_red_sit->sem )) )  )      &&
	    (out_list[pos].action.new_red_sit->pcc == NULL)        )
	   {
	     for( loop=0;loop<space;loop++ )
		fprintf(fp,"   ");
             if( called_from_error )
		fprintf(fp,"if (%s == %d) { action = %s%d; break; }\n",
                        eq_string,
                        ((sx_code_list == NULL) ? 
		        (OPERAND( out_list[pos].eq_elem )) :
                        (sx_code_list[OPERAND( out_list[pos].eq_elem )])),
		        ((IS_REDUCEACT(out_list[pos].action.new_red_sit->
                         sem)) ?
			"-" : ""),
			out_list[pos].action.new_red_sit->mark );
             else
                {
	          if( user_data->individual_reduce_code &&
		      IS_REDUCEACT( out_list[pos].action.new_red_sit->sem ) )
		     fprintf(fp,"if (%s == %d) goto %s_%d_%d_%d;\n",eq_string,
                             ((sx_code_list == NULL) ? 
		             (OPERAND( out_list[pos].eq_elem )) :
                             (sx_code_list[OPERAND( out_list[pos].eq_elem )])),
		             shred_mark,
		             out_list[pos].action.new_red_sit->mark,
		             out_list[pos].action.new_red_sit->kind,
		             out_list[pos].action.new_red_sit->state );
	          else
		     fprintf(fp,"if (%s == %d) goto %s_%d;\n",eq_string,
                             ((sx_code_list == NULL) ? 
		             (OPERAND( out_list[pos].eq_elem )) :
                             (sx_code_list[OPERAND( out_list[pos].eq_elem )])),
		             ((IS_REDUCEACT(out_list[pos].action.new_red_sit->
                              sem)) ?
			     shred_mark : ((out_list[pos].action.new_red_sit->
			     scan) ? shift_mark : default_mark)),
			     out_list[pos].action.new_red_sit->mark );
                }
	   } /* end of if( !(out_list[... */
	else
	{

	  if( comp )
	     space -= 2;
	  else
	     {
	       for( loop=0;loop<space;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"if (%s == %d) \n",
		       eq_string,
                       ((sx_code_list == NULL) ? 
		       (OPERAND( out_list[pos].eq_elem )) :
                       (sx_code_list[OPERAND( out_list[pos].eq_elem )])) );
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"{\n");
	     } /* end of else ( if( comp ) ) */
	  if( (out_list[pos].action.new_red_sit->scan)                     &&
	      ((IS_REDUCEACT( out_list[pos].action.new_red_sit->sem )) ||
               (IS_SEM( out_list[pos].action.new_red_sit->sem ))       ||
               (IS_SEM( out_list[pos].action.new_red_sit->old_sem ))    )   )
	     {
	       if( user_data->semantic_symbols )
		  {
		    for( loop=0;loop<space+1;loop++ )
		       fprintf(fp,"   ");
		    fprintf(fp,"   if( IS_SEM( term ) )\n");
		    for( loop=0;loop<space+1;loop++ )
		       fprintf(fp,"   ");
		    fprintf(fp,"      SYMB_SEM( SYMBOL_CONNECTION_VALUE );\n");
		  } /* end of if( user_data->se... */
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"   SCAN( %s );\n",eq_string );
	     } /* end of if( (out_list[p... */

	  if( out_list[pos].action.new_red_sit->pcc != NULL )
	     {
	       if( (out_list[pos].action.new_red_sit->pop > 0)     &&
		   (out_list[pos].action.new_red_sit->pcc->pop > 0) )
		  {
		    for( loop=0;loop<space+1;loop++ )
		       fprintf(fp,"   ");
		    fprintf(fp,"   sp -= %d;\n",
			    ((out_list[pos].action.new_red_sit->pcc->pop) +
			     (out_list[pos].action.new_red_sit->pcc->pop)) );
		  } /* end of if( (out_list[p... */
	       else
		  if( (out_list[pos].action.new_red_sit->pop > 0)     ||
		      (out_list[pos].action.new_red_sit->pcc->pop > 0) )
		     {
		       for( loop=0;loop<space+1;loop++ )
			  fprintf(fp,"   ");
		       fprintf(fp,"   sp -= %d;\n",
			       ((out_list[pos].action.new_red_sit->
				 pcc->pop > 0) ?
				 (out_list[pos].action.new_red_sit->
				 pcc->pop) :
				 (out_list[pos].action.new_red_sit->pop)) );
		     } /* end of if( (out_list[p... */
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"   if(");
	       for( len=0;len<out_list[pos].action.new_red_sit->pcc->
			  number;len++ )
		  {
		    if( len )
		       {
			 fprintf(fp,"         ");
			 for( loop=0;loop<space;loop++ )
			    fprintf(fp,"   ");
		       } /* end of if( len ) */
		    fprintf(fp," (*sp == %d) %s\n",
			    out_list[pos].action.new_red_sit->
			    pcc->pointer[len],
			    ((len == out_list[pos].action.new_red_sit->
			    pcc->number-1) ? ")" : "||") );
		  } /* end of for( len=0;len<... */
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"      sp -= 1;\n");

	     } /* end of if( out_list[po... */
	  else
	     if( out_list[pos].action.new_red_sit->pop > 0 )
		{
		  for( loop=0;loop<space+1;loop++ )
		     fprintf(fp,"   ");
		  fprintf(fp,"   sp -= %d;\n",
			  out_list[pos].action.new_red_sit->pop );
		} /* end of else ( if( out_list[po... ) */

	  if( IS_SEM( out_list[pos].action.new_red_sit->
				   old_sem ) )
	     {
	       if( called_from_error )
		  {
		    for( loop=0;loop<space+1;loop++ )
		       fprintf(fp,"   ");
		    fprintf(fp,"   if( run == 2 )\n");
		    fprintf(fp,"   ");
		  } /* end of if( called_from_err... */
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
               if( user_data->direct_struct_connection )
                  fprintf(fp,"   %s\n",
                          seman_list[OPERAND( out_list[pos].action.
                                              new_red_sit->old_sem )] );
               else
	          fprintf(fp,"   SEMANTIC( %d );\n",
		          OPERAND( out_list[pos].action.new_red_sit->
			 	   old_sem ) );
	     } /* end of if( IS_SEM( out... */
	  if( IS_SEM( out_list[pos].action.new_red_sit->
				   sem ) )
	     {
	       if( called_from_error )
		  {
		    for( loop=0;loop<space+1;loop++ )
		       fprintf(fp,"   ");
		    fprintf(fp,"   if( run == 2 )\n");
		    fprintf(fp,"   ");
		  } /* end of if( called_fr... */
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
               if( user_data->direct_struct_connection )
                  fprintf(fp,"   %s\n",
                          seman_list[OPERAND( out_list[pos].action.
                                              new_red_sit->sem )] );
               else
	          fprintf(fp,"   SEMANTIC( %d );\n",
		          OPERAND( out_list[pos].action.new_red_sit->
				     sem ) );
	     } /* end of if( IS_SEM( out... */
	  if( IS_REDUCEACT( out_list[pos].action.new_red_sit->
				   sem ) )
	     {
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
               if( called_from_error )
		  fprintf(fp,"   action = -%d; break;\n",
			  out_list[pos].action.new_red_sit->mark );
               else
                  {
	            if( user_data->individual_reduce_code )
		       fprintf(fp,"   goto %s_%d_%d_%d;\n",shred_mark,
			       out_list[pos].action.new_red_sit->mark,
			       out_list[pos].action.new_red_sit->kind,
			       out_list[pos].action.new_red_sit->state );
	            else
		       fprintf(fp,"   goto %s_%d;\n",shred_mark,
			       out_list[pos].action.new_red_sit->mark );
                  }
	     } /* end of if( IS_REDUCEAC... */
	  else
	     {
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
               if( called_from_error )
	            fprintf(fp,"   action = %d; break;\n",
		            out_list[pos].action.new_red_sit->mark );
               else
	            fprintf(fp,"   goto %s_%d;\n",
		            (out_list[pos].action.new_red_sit->scan &&
                            !(IS_SEM( out_list[pos].action.new_red_sit->
                              sem )) &&
                            !(IS_SEM( out_list[pos].action.new_red_sit->
                              old_sem ))) ?
			     shift_mark : default_mark,
		            out_list[pos].action.new_red_sit->mark );
	     } /* end of else ( if( IS_REDUCEAC... ) */
	  if( !comp )
	     {
	       for( loop=0;loop<space+1;loop++ )
		  fprintf(fp,"   ");
	       fprintf(fp,"} \n");
	     } /* end of if( !comp ) */
	} /* end of else ( if( !(out_list[... ) */

     if( extra_info )
	printf("end of function Print_If( )\n");

   } /* end of function Print_If( ) */





void Print_Normal_If( fp,user_data,out_list,upper_bound,eq_string,
		      shred_mark,shift_mark,default_mark,comp,
	              called_from_error,sx_code_list,seman_list,extra_info)


   FILE                           *fp;  /* file pointer to the external
					   output file, where the complete
					   parser should be written        */
   struct equality          *out_list;  /* pointer to structure equality,
					   which represents a part of code,
					   where some comparisons lead
					   through                         */
   struct user             *user_data;  /* internal interface vector, which
					   saves information fixed by the
					   user                            */
   short                *sx_code_list,  /* used to convert internal to
                                           external syntax code            */
                          upper_bound;  /* number of code elements which
					   should be printed out           */
   char_ptr               *seman_list;  /* a list of pointer to the 
                                           semantic actions                */

   char                    *eq_string,  /* the string which should compared
					   with other data                 */
			  *shred_mark,  /* this string would be printed
					   out, if a jump to a reduce -
					   mark should be passed through   */
			  *shift_mark,  /* this string would be printed
					   out, if a jump to a shift -
					   mark should be passed through   */
			*default_mark,  /* this string would be printed
					   out, if a jump to a default -
					   mark ( no reduce - and no shift
					   - mark ) should be passed 
                                           through                         */
				 comp,  /* if comp == 1 then the code is
					   compressed and then a default
					   action exists                   */
		    called_from_error,  /* used to decide if this function
					   is called from the error recovery
					   writing part or not             */
			   extra_info;  /* if extra_info == 1, then extra
					   information about begin and end
					   of function is printed out     */



/* This function controls the printing out of "Normal If" discribed above. 
   "Normal If" means, that each element of a comparison list is compared step 
   by step with a pattern as long as one is equal to. Then some action
   lead through and a jump to another state takes place.
*/




   {
     short  loop;  /* loop index                                           */

     if( extra_info )
	printf("begin of function Print_Normal_If( )\n");

     for( loop=0;loop<upper_bound;loop++ )
	{
	  Print_If( fp,user_data,out_list,loop,((called_from_error) ? 6 : 1),
                    eq_string,shred_mark,shift_mark,default_mark,
		    ((loop == upper_bound-1) && comp) ? 1 : 0,
		    called_from_error,sx_code_list,seman_list,
		    extra_info);


	} /* end of for( loop=0;loo... */

     if( extra_info )
	printf("end of function Print_Normal_If( )\n");

   } /* end of function Print_Normal_If( ) */





void Write_Semantic_Code( fp,nop,seman_list,seman_out,extra_info )

   FILE              *fp;  /* File pointer to file semantic_productions.h  */
   char_ptr  *seman_list;  /* a list of pointer to the semantic actions    */
   short             nop;  /* number of productions                        */
   char       extra_info,  /* if extra_info == 1, then extra information
                              about begin and end of function are printed 
                              out                                          */
              *seman_out;  /* the productions which have semantic
                              connections and should printed out are 
                              marked                                       */


/* This function builds the code for the file semantic_productions.
   For each semantic production a semantic connection is choosed by the
   production code.
*/


   {
     short count;  /* loop index                                          */

     if( extra_info )
        printf("begin of function Write_Semantic_Code()\n");

     fprintf(fp,"void Semantic_Prods( rule_number )\n");
     fprintf(fp,"\n   short rule_number;\n");
     fprintf(fp," \n\n  {\n");
     fprintf(fp,"     switch( rule_number )\n");
     fprintf(fp,"        {\n");
     for( count=0;count<nop;count++ )
        {
          if( seman_out == NULL )
             {
               if( seman_list[count] != NULL )
                  { 
                    fprintf(fp,"          case %d : %s\n",count,
                            seman_list[count] );
                    fprintf(fp,"                    break;\n");
                  } /* end of if( seman_list[cou... */
             }  /* end of if( seman_out... */
          else
             if( (seman_list[count] != NULL) && seman_out[count] )
                { 
                  fprintf(fp,"          case %d : %s\n",count,
                          seman_list[count] );
                  fprintf(fp,"                    break;\n");
                } /* end of if( seman_list[cou... */

        } /* end of for( count=0;c... */
     fprintf(fp,"        }\n");
     fprintf(fp,"   }\n");

     if( extra_info )
        printf("end of function Write_Semantic_Code()\n");

   } /* end of function Write_Semantic_Code() */



