/***************************************************************************/
/* filename : optim_out.c                          first edit  :  3.03.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 21.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: optim_out.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";


/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include "errors.h"

#include "out.h"

#include "clearing.h"

#include "reach.h"


#include "optim_help.h"

#include "optim_out.h"

/***************************** FUNCTIONS *************************************/


static void Det_Min_Max_Term( quick_data,optim_out_data,extra_info )

   readtype              *quick_data;  /* internal interface vector          */
   struct optim_out  *optim_out_data;  /* stores the optimized code in a
					  form which could be printed out
					  easy                               */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out        */


/* Internal and external syntax code are different, because internal code 
   should be very compact. This function determines the minimum and maximum 
   external syntax code.
*/


   {
     short     *external_code,  /* pointer to the external code vector      */
	                  max,  /* greatest syntax code                     */
	                  min,  /* lowest syntax code                       */
	                 term,  /* loop index                               */
	                state,  /* loop index                               */
	               length,  /* length of the syntax code bit set        */
	                  szc,  /* size of char in bits                     */
	                  nos,  /* number of states                         */
	                  not;  /* number of terminals                      */
     char_ptr        *bit_set;  /* used to save the syntax code in a bit 
                                   set                                      */   


     if( extra_info )
	printf("begin of function Det_Min_Max_Term()\n");

     external_code = (*quick_data)[2];
     not           = *((*quick_data)[0]);
     nos           = *((*quick_data)[9]);

     min = external_code[0];
     max = min;
     for( term=1;term<not;term++ )
	if( external_code[term] < min )
	   min = external_code[term];
	else
	   if( external_code[term] > max )
	      max = external_code[term];

     optim_out_data->min_term = min;
     optim_out_data->max_term = max;

     szc = sizeof( char ) * BYTE;
     length = (!((max+1-min)%szc)) ? ((max+1-min)/szc) : (((max+1-min)/szc)+1);

     optim_out_data->length_of_bvector = length;

     if( (bit_set = (char_ptr*) calloc( nos,sizeof( char_ptr) )) == NULL )
	 Error_Message( _DET_MIN_MAX_TERM,MODULE_OPTIM_OUT,NO_SPACE_FOR_VECTOR,
                        ABORT," bit_set" );

     for( state=0;state<nos;state++ )
	if( optim_out_data->similar_act_rows[state] == state )
	   {
	     if( (bit_set[state] = (char*) calloc(
			   length,sizeof(char) )) == NULL )
		Error_Message( _DET_MIN_MAX_TERM,MODULE_OPTIM_OUT,
                               NO_SPACE_FOR_VECTOR,ABORT," bit_set[state]");
	     for( term=0;term<not;term++ )
		if( optim_out_data->bit_set[state][term/BYTE] &
		    (1 << (term%BYTE)) )
		   bit_set[state][(external_code[term]-min)/BYTE] =
			  bit_set[state][(external_code[term]-min)/BYTE] |
				(1 << ((external_code[term]-min)%BYTE));
	   } /* end of if( optim_out_d... */
	  else
	     bit_set[state] = NULL;


     optim_out_data->bvector = bit_set;

     if( extra_info )
	printf("end of function Det_Min_Max_Term()\n");

   } /* end of function Det_Min_Max_Term() */






static struct red_out_code *Build_Ind_Red_Code( quick_data,user_data,
						changed_data,reach_ptr,
						rep_vc,extra_info )

   readtype        *quick_data;  /* internal interface vector              */
   struct inter  *changed_data;  /* vector which stores the changes, which
				    have arisen from the optimization
				    techniques                             */
   struct user      *user_data;  /* vector which stores information set
				    by the user                            */
   reach            *reach_ptr;  /* a vector in which all reduction paths
				    are saved, which could be reached
				    after the optimization techniques are
				    applied                                */
   rep_code            *rep_vc;  /* vector which saves the information
				    about shared reduce code and " Unit -
				    Marks "                                */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */



/* This function is used to determine the individual reduce code. For
   every reduction situation one reduction mark should be printed out. So,
   all relevant information about each reduction situation is saved.
   This data are the states which should occur on top of stack and the
   corresponding action. This action could be a jump to a state mark or
   to a reduction mark. If it is a jump to reduction mark, other action
   must be lead through first. This actions could be pop some elements,
   pass some semantic information and so on.
   To get a definite name of the reduction mark, I choose a name which is
   composed of four parts :
   First the letters RED_, than the number of the reduction, followed by
   the kind of reduction and at lastly the state in which the reduction 
   takes place. The kind is a number from 0 up to 2 ( kind == 0, a reduce 
   entry in T - table, kind == 1, a shift/reduce entry in T - table and 
   kind == 2, a shift/reduce entry in N - table ).
*/



   {
     short                           nop,  /* number of productions        */
				    prod,  /* loop index                   */
				     pos,  /* loop index                   */
				   *used,  /* this vector is used by func-
					      tion Code_Compression        */
                             search_elem,
			       *red_path;  /* pointer to the reduction
					      paths of one reduction
					      situation                    */
     struct reach_elem    *help_elem_ptr,  /* this pointer is used to
					      search a reduction situation */
                             *search_ptr,
			       *elem_ptr;  /* this pointer is used to
					      search a reduction situation */
     struct red_out_code        *red_ptr,  /* pointer of a list of reduc-
					      tion code                    */
			   *red_help_ptr;  /* this pointer is used to gene-
					      rate an elemnet of the
					      reduction code list and put
					      it at the beginning of the
					      list                         */
     char                          found;  /* used to find a reduction
					      situation                    */



     if( extra_info )
	printf("begin of function Build_Ind_Red_Code( )\n");


     red_ptr = NULL;

     nop = *((*quick_data)[5]);

     if( (used = (short*) calloc( *((*quick_data)[9]),sht )) == NULL )
	Error_Message( _BUILD_IND_RED_CODE,MODULE_OPTIM_OUT,NO_SPACE_FOR_VECTOR,
                       ABORT," used" );

     for( prod=nop-1;prod>=0;prod-- )
     if( reach_ptr[prod] != NULL )
	{
	  help_elem_ptr = reach_ptr[prod];
	  while( help_elem_ptr != NULL )
	     {
               if( !(IS_DGD( help_elem_ptr->state_nr )) )
                  {
	             red_path = help_elem_ptr->pointer;
	             if( (red_help_ptr = (struct red_out_code*) malloc(
			      	sizeof( struct red_out_code ) )) == NULL )
		        Error_Message( _BUILD_IND_RED_CODE,MODULE_OPTIM_OUT,
                                       NO_SPACE_FOR_STRUCTURE,ABORT,
                                       " red_help_ptr" );
	             red_help_ptr->mark   = prod;
	             red_help_ptr->state  = OPERAND( help_elem_ptr->state_nr );
	             red_help_ptr->kind   = help_elem_ptr->kind;
	             red_help_ptr->number = red_path[0];
	             if( (red_help_ptr->eq_list = (struct equality*) calloc(
			   red_path[0],sizeof( struct equality ) )) == NULL )
		        Error_Message( _BUILD_IND_RED_CODE,MODULE_OPTIM_OUT,
                                       NO_SPACE_FOR_VECTOR,ABORT,
                                       " red_help_ptr->eq_list");

	             for( pos=0;pos<red_path[0];pos++ )
		        {
		          if( !(IS_SHRED_NTACT( red_path[2*pos+3] )) )
		             {
			        red_help_ptr->eq_list[pos].eq_elem =
				  red_path[2*pos+2];
			        red_help_ptr->eq_list[pos].action.goto_action =
					OPERAND( red_path[2*pos+3] );
			     } /* end of if( !(IS_SHRED_... */
		          else
			     {
			       red_help_ptr->eq_list[pos].eq_elem =
					SET_SHRED_NTACT( red_path[2*pos+2] );
			       if( (red_help_ptr->eq_list[pos].
				  action.new_red_sit = (struct red*) malloc(
					    sizeof( struct red ) )) == NULL )
			          Error_Message( _BUILD_IND_RED_CODE,
                                                 MODULE_OPTIM_OUT,
                                                 NO_SPACE_FOR_STRUCTURE,
                                                 ABORT,
                                                 " red_help_ptr->eq_list[pos]" );
			       red_help_ptr->eq_list[pos].action.new_red_sit->
					   scan = FALSE;
			       elem_ptr = reach_ptr[OPERAND(
						       red_path[2*pos+3] )];
			       found = FALSE;
			       while( (elem_ptr != NULL) && !found )
			          if( OPERAND( elem_ptr->state_nr ) == 
                                      red_path[2*pos+2] )
				     found = TRUE;
			          else
				     elem_ptr = elem_ptr->next;
			       if( !found )
			          Error_Message( _BUILD_IND_RED_CODE,
                                                 MODULE_OPTIM_OUT,
                                                 NOT_FIND_ELEMENT,ABORT,
                                                 " red_path[2*pos+2]" );
			       red_help_ptr->eq_list[pos].action.new_red_sit->
			          pop = elem_ptr->pointer[1];
			      if( elem_ptr->pointer[1] < 0 )
			         red_help_ptr->eq_list[pos].action.new_red_sit->
				   pcc = Find_Pcc_Elem( changed_data->pcc_list,
						        OPERAND(
						          red_path[2*pos+3] ),
						        OPERAND(
						          red_path[2*pos+2] ),
						        2,extra_info );
			      else
			         red_help_ptr->eq_list[pos].action.new_red_sit->
				      pcc = NULL;
                              if( IS_ABS( (*quick_data)[8][OPERAND(
                                    red_path[2*pos+3] )] ) )
			         red_help_ptr->eq_list[pos].action.new_red_sit->
				    old_sem = SET_SEM( OPERAND( 
                                                       red_path[2*pos+3] ) );
                              else
			         red_help_ptr->eq_list[pos].action.new_red_sit->
				    old_sem = 0;
                              if( IS_DGD( elem_ptr->state_nr ) )
                                 {
                                   if( IS_SHRED_NTACT( elem_ptr->pointer[3] ) )
                                      {
                                        search_elem = OPERAND( 
                                                        elem_ptr->pointer[2] );
                                        search_ptr = reach_ptr[OPERAND( 
                                                     elem_ptr->pointer[3] )];
                                        found = FALSE;
                                        while( (search_ptr != NULL ) &&
                                               !found )
                                        if( OPERAND( search_ptr->state_nr ) ==
                                            search_elem )
                                           found = TRUE;
                                        else
                                           search_ptr = search_ptr->next;
                                        if( !found )
                                           Error_Message();
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->sem = SET_REDUCEACT(
                                              elem_ptr->pointer[3] );
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->state = OPERAND( 
                                              search_ptr->state_nr );
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->kind = search_ptr->kind;
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->mark = OPERAND( 
                                               elem_ptr->pointer[3] );
                                        if( search_ptr->pointer[1] < 0 )
                                           red_help_ptr->eq_list[pos].action.
                                             new_red_sit->pcc = Find_Pcc_Elem(
                                               changed_data->pcc_list,
                                               OPERAND( elem_ptr->pointer[3] ),
                                               OPERAND( search_ptr->state_nr ),
                                               2,extra_info );
                                        else
                                           red_help_ptr->eq_list[pos].action.
                                             new_red_sit->pop += search_ptr->
                                                                 pointer[1];
                                        if( IS_ABS( (*quick_data)[8][
                                             OPERAND( search_ptr->pointer[3] )] ) )
                                           red_help_ptr->eq_list[pos].action.
                                             new_red_sit->sem = SET_SEM(
                                                red_help_ptr->eq_list[pos].action.
                                                new_red_sit->sem );
                                      } /* end of if( IS_SHRED_NTA... */
                                   else
                                      {
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->kind = 0;
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->state = 0;
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->sem = 0;
                                        red_help_ptr->eq_list[pos].action.
                                           new_red_sit->mark = OPERAND( elem_ptr->
                                                               pointer[3] );
                                      } /* end of else ( if( IS_SHRED_NTA... ) */
                                 } /* end of if( IS_DGD( elem_... */
                              else
                                 {
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->sem = SET_REDUCEACT( 0 );
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->state = OPERAND( 
                                           elem_ptr->state_nr );
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->kind = elem_ptr->kind;
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->mark = OPERAND(
                                         red_path[2*pos+3] );
                                 } /* end of else ( if( IS_DGD( elem_... ) */
			     } /* end of else ( if( !(IS_SHRED_N... ) */
		        } /* end of for( pos=0;pos<... */
	            found = FALSE;
	            if( user_data->code_compression && 
                        (red_help_ptr->number > 1 ) )
		       red_help_ptr->eq_list = Code_Compression(
					        red_help_ptr->eq_list,
					        &(red_help_ptr->number),
					        used,&found,extra_info );
	            if( user_data->delete_unit_marks )
		       if( Unit_Assignment( rep_vc,red_help_ptr,nop,extra_info ) )
		          {
		            if( user_data->share_reduce_code )
			       if( Not_Equal_Code( rep_vc,red_ptr,red_help_ptr,
			 	                   nop,extra_info ) )
			          {
			            red_help_ptr->next   = red_ptr;
			            red_ptr = red_help_ptr;
			           } /* end of if( Not_Equal_C... */
			       else
			          free( red_help_ptr );
		            else
			       {
			         red_help_ptr->next   = red_ptr;
			         red_ptr = red_help_ptr;
			       } /* end of else ( if( user_data->... ) */
		          } /* end of if( Unit_Assign... */
		       else
		          free( red_help_ptr );
	            else
		       if( user_data->share_reduce_code )
	                  if( Not_Equal_Code( rep_vc,red_ptr,red_help_ptr,
			                      nop,extra_info ) )
		             {
			       red_help_ptr->next   = red_ptr;
			       red_ptr = red_help_ptr;
			     } /* end of if( Not_Equal_C... */
	                  else
			     free( red_help_ptr );
                       else
		          {
	                    red_help_ptr->next   = red_ptr;
		            red_ptr = red_help_ptr;
		          } /* end of if( user_data->s... */
                  } /* end of if( !(IS_DGD( help_el... */
	       help_elem_ptr = help_elem_ptr->next;
	     } /* end of while( help_ele... */
	} /* end of if( reach_ptr[p... */


     if( extra_info )
	printf("end of function Build_Ind_Red_Code( )\n");

     return( red_ptr );

   } /* end of function Build_Ind_Red_Code( ) */









static struct red_out_code *Build_Red_Code( quick_data,user_data,
					    changed_data,reach_ptr,
					    rep_vc,extra_info )


   readtype        *quick_data;  /* internal interface vector              */
   struct inter  *changed_data;  /* vector which stores the changes, which
				    have arisen from the optimization
				    techniques                             */
   struct user      *user_data;  /* vector which stores information set
				    by the user                            */
   reach            *reach_ptr;  /* a vector in which all reduction paths
				    are saved, which could be reached
				    after the optimization techniques are
				    applied                                */
   rep_code            *rep_vc;  /* vector, which saves the information
				    about shared reduce code and " Unit -
				    Marks "                                */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */





/* Here the normal or combined reduce code is build. The reduction
   situations of all productions, which have the same left hand side
   symbol, are put together. The rest is equal to the function above.
   Only the reduce mark does'nt need to be so complex. It is a two part
   name, with the same beginning as above ( RED_ ) followed by the number 
   of the left hand side symbol of the productions.
*/



   {
     short                           nop,  /* number of productions        */
				     nos,  /* number of states             */
				     non,  /* number of nonterminals       */
				    prod,  /* loop index                   */
				   state,  /* loop index                   */
				    symb,  /* loop index                   */
				  number,  /* loop index                   */
				     pos,  /* loop index                   */
                             search_elem,
				   *used,  /* this vector is used by func-
					      tion Code_Compression        */
				    *lhs,  /* vector of the left hand side
					      symbols of all productions   */
			       *out_list,  /* saves the action which takes
					      place if productions with
					      the same lhs reduce          */
			       *red_path;  /* pointer to the reduction
					      paths of one reduction
					      situation                    */
     struct reach_elem    *help_elem_ptr,  /* this pointer is used to
					      search a reduction situation */
                             *search_ptr,
			       *elem_ptr;  /* this pointer is used to
					      search a reduction situation */
     struct red_out_code        *red_ptr=  /* pointer of a list of reduc-  */
				    NULL,  /* tion code                    */
			   *red_help_ptr;  /* this pointer is used to gene-
					      rate an elemnet of the
					      reduction code list and put
					      it at the beginning of the
					      list                         */
     char                          found;  /* used to find a reduction
					      situation                    */



     if( extra_info )
	printf("begin of function Build_Red_Code( )\n");

     nos = *((*quick_data)[9]);
     nop = *((*quick_data)[5]);
     non = *((*quick_data)[3]);
     lhs = (*quick_data)[6];



     if( ((used     = (short*) calloc( nos,sht )) == NULL) ||
	 ((out_list = (short*) calloc( nos,sht )) == NULL) )
	Error_Message( _BUILD_RED_CODE,MODULE_OPTIM_OUT,NO_SPACE_FOR_VECTOR,
                       ABORT," out_list" );

     for( symb=non-1;symb>=0;symb-- )
	{
	  for( state=0;state<nos;state++ )
	     out_list[state] = 0;
	  number = 0;
	  for( prod=0;prod<nop;prod++ )
	     if( (lhs[prod] == symb) && (reach_ptr[prod] != NULL) )
		{
		  help_elem_ptr = reach_ptr[prod];
		  while( help_elem_ptr != NULL )
                     {
                       if( !(IS_DGD( help_elem_ptr->state_nr )) )
		          {
		            red_path = help_elem_ptr->pointer;
		            for( state=0;state<red_path[0];state++ )
			       if( !out_list[red_path[state*2+2]] )
			          {
			            number++;
			            out_list[red_path[state*2+2]] =
						  red_path[state*2+3];
			          } /* end of if( !out_list[r... */
			       else
			          if( out_list[red_path[state*2+2]] !=
				      red_path[state*2+3] )
				     Error_Message( _BUILD_RED_CODE,
                                                    MODULE_OPTIM_OUT,
                                                    DIFFERENT_CONTINUATION_STATES,
                                                    ABORT,"");
		          } /* end of if( !(IS_DGD( ... */
		       help_elem_ptr = help_elem_ptr->next;
                     } /* end of while( help_ele... */
		} /* end of if( (lhs[prod] ... */
	  if( number>0 )
	     {
	       if( (red_help_ptr = (struct red_out_code*) malloc(
				sizeof( struct red_out_code ) )) == NULL )
		  Error_Message( _BUILD_RED_CODE,MODULE_OPTIM_OUT,
                                 NO_SPACE_FOR_STRUCTURE,ABORT," red_help_ptr" );
	       red_help_ptr->mark   = symb;
	       red_help_ptr->state  = 0;
	       red_help_ptr->kind   = 0;
	       red_help_ptr->number = number;

	       if( (red_help_ptr->eq_list = (struct equality*) calloc(
				    number,sizeof( struct equality ) )) == NULL )
		  Error_Message( _BUILD_RED_CODE,MODULE_OPTIM_OUT,
                                 NO_SPACE_FOR_VECTOR,ABORT,
                                 " red_help_ptr->eq_list" );

	       pos = 0;
	       for( state=0;state<nos;state++ )
		  {
		    if( out_list[state] )
		       if( !(IS_SHRED_NTACT( out_list[state] )) )
			  {
			    red_help_ptr->eq_list[pos].eq_elem = state;
			    red_help_ptr->eq_list[pos].action.goto_action =
					OPERAND( out_list[state] );
			    pos++;
			  } /* end of if( !(IS_SHRED_... */
		       else
			  {
			    red_help_ptr->eq_list[pos].eq_elem =
					SET_SHRED_NTACT( state );
			    if( (red_help_ptr->eq_list[pos].
				  action.new_red_sit = (struct red*) malloc(
					    sizeof( struct red ) )) == NULL )
			       Error_Message( _BUILD_RED_CODE,MODULE_OPTIM_OUT,
                                              NO_SPACE_FOR_STRUCTURE,ABORT,
                                              " red_help_ptr->eq_list...." );
			    red_help_ptr->eq_list[pos].action.new_red_sit->
			       state = 0;
			    red_help_ptr->eq_list[pos].action.new_red_sit->
			       kind = 0;
			    red_help_ptr->eq_list[pos].action.new_red_sit->
					   scan = FALSE;
			    elem_ptr = reach_ptr[OPERAND( out_list[state] )];
			    found = FALSE;
			    while( (elem_ptr != NULL) && !found )
			       if( OPERAND( elem_ptr->state_nr ) == state )
				  found = TRUE;
			       else
				  elem_ptr = elem_ptr->next;
			    if( !found )
			       Error_Message( _BUILD_RED_CODE,MODULE_OPTIM_OUT,
                                              NOT_FIND_ELEMENT,ABORT," state" );
			    red_help_ptr->eq_list[pos].action.new_red_sit->
			       pop = elem_ptr->pointer[1];
			    if( elem_ptr->pointer[1] < 0 )
			       red_help_ptr->eq_list[pos].action.new_red_sit->
				 pcc = Find_Pcc_Elem( changed_data->pcc_list,
						      OPERAND(
							out_list[state] ),
						      state,2,
						      extra_info );
			    else
			       red_help_ptr->eq_list[pos].action.new_red_sit->
				   pcc = NULL;
                            if( IS_ABS( (*quick_data)[8][OPERAND(
                                out_list[state] )] ) )
                               red_help_ptr->eq_list[pos].action.new_red_sit->
				 old_sem = SET_SEM( OPERAND( out_list[state] ) );
                            else
                               red_help_ptr->eq_list[pos].action.new_red_sit->
				 old_sem = 0;
                            if( IS_DGD( elem_ptr->state_nr ) )
                               {
                                 if( IS_SHRED_NTACT( elem_ptr->pointer[3] ) )
                                    {
                                      search_elem = OPERAND( 
                                                        elem_ptr->pointer[2] );
                                      search_ptr = reach_ptr[OPERAND( 
                                                     elem_ptr->pointer[3] )];
                                      found = FALSE;
                                      while( (search_ptr != NULL ) &&
                                               !found )
                                        if( OPERAND( search_ptr->state_nr ) ==
                                            search_elem )
                                           found = TRUE;
                                        else
                                           search_ptr = search_ptr->next;
                                      if( !found )
                                         Error_Message();
                                      red_help_ptr->eq_list[pos].action.
                                         new_red_sit->sem = SET_REDUCEACT(
                                              elem_ptr->pointer[3] );
                                      red_help_ptr->eq_list[pos].action.
                                         new_red_sit->state = 0;
                                      red_help_ptr->eq_list[pos].action.
                                         new_red_sit->kind = 0;
                                      red_help_ptr->eq_list[pos].action.
                                           new_red_sit->mark = lhs[OPERAND( 
                                               elem_ptr->pointer[3] )];
                                      if( search_ptr->pointer[1] < 0 )
                                         red_help_ptr->eq_list[pos].action.
                                           new_red_sit->pcc = Find_Pcc_Elem(
                                               changed_data->pcc_list,
                                               OPERAND( elem_ptr->pointer[3] ),
                                               OPERAND( search_ptr->state_nr ),
                                               2,extra_info );
                                      else
                                         red_help_ptr->eq_list[pos].action.
                                           new_red_sit->pop += search_ptr->
                                                               pointer[1];
                                      if( IS_ABS( (*quick_data)[8][
                                           OPERAND( search_ptr->pointer[3] )] ) )
                                         red_help_ptr->eq_list[pos].action.
                                           new_red_sit->sem = SET_SEM(
                                              red_help_ptr->eq_list[pos].action.
                                              new_red_sit->sem );
                                    } /* end of if( IS_SHRED_NTA... */
                                 else
                                    {
                                      red_help_ptr->eq_list[pos].action.
                                         new_red_sit->kind = 0;
                                      red_help_ptr->eq_list[pos].action.
                                         new_red_sit->state = 0;
                                      red_help_ptr->eq_list[pos].action.
                                         new_red_sit->sem = 0;
                                       red_help_ptr->eq_list[pos].action.
                                         new_red_sit->mark = OPERAND( elem_ptr->
                                                               pointer[3] );
                                      } /* end of else ( if( IS_SHRED_NTA... ) */
                                 } /* end of if( IS_DGD( elem_... */
                              else
                                 {
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->sem = SET_REDUCEACT( 0 );
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->state = 0;
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->kind = 0;
                                   red_help_ptr->eq_list[pos].action.
                                      new_red_sit->mark = lhs[OPERAND(
                                         out_list[state] )];
                                 } /* end of else ( if( IS_DGD( elem_... ) */
			    pos++;
			  } /* end of else ( if( !(IS_SHRED_... ) */
		  } /* end of for( state=0;st... */
	       found = FALSE;
	       if( user_data->code_compression && 
                   (red_help_ptr->number > 1 ) )
		  red_help_ptr->eq_list = Code_Compression(
					     red_help_ptr->eq_list,
					     &(red_help_ptr->number),
					     used,&found,extra_info );
	       if( user_data->delete_unit_marks )
		  if( Unit_Assignment( rep_vc,red_help_ptr,nop,extra_info ) )
		     {
		       if( user_data->share_reduce_code )
			  if( Not_Equal_Code( rep_vc,red_ptr,red_help_ptr,
					      nop,extra_info ) )
			     {
			       red_help_ptr->next   = red_ptr;
			       red_ptr = red_help_ptr;
			     } /* end of if( Not_Equal_C... */
			  else
			     free( red_help_ptr );
		       else
			  {
			    red_help_ptr->next   = red_ptr;
			    red_ptr = red_help_ptr;
			  } /* end of else ( if( user_data->... ) */
		     } /* end of if( Unit_Assign... */
		  else
		     free( red_help_ptr );
	       else
		  if( user_data->share_reduce_code )
	             if( Not_Equal_Code( rep_vc,red_ptr,red_help_ptr,
			                 nop,extra_info ) )
		        {
			  red_help_ptr->next   = red_ptr;
			  red_ptr = red_help_ptr;
			} /* end of if( Not_Equal_C... */
	             else
			free( red_help_ptr );
                  else
		     {
	               red_help_ptr->next   = red_ptr;
		       red_ptr = red_help_ptr;
		     } /* end of if( user_data->s... */

	     } /* end of if( number>0 ) */
	} /* end of for( symb=non-1... */

     if( extra_info )
	printf("end of function Build_Red_Code( )\n");

     return( red_ptr );

   } /* end of function Build_Red_Code( ) */







static struct sa_code *Build_Similar_Act_Code( quick_data,changed_data,max_sx,
                                               scan_mark,extra_info )

   readtype        *quick_data;  /* internal interface vector              */
   struct inter  *changed_data;  /* vector which stores the changes, which
				    have arisen from the optimization
				    techniques                             */
   short                max_sx;
   char             extra_info,  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */
                    *scan_mark;

/* In the modul Low_Optim I have explained what similar act code means.
   A short repetition : If the code of one state could not used as equal
   code, subcode and common code with others, it is possible that there
   are some actions wich are common with other but different states. I
   build one simmilar action code block and all states which belongs to,
   have a jump to this action group.
*/


   {
     struct sa_code     *sa;  /* pointer to a list of similar action code  */
     short              not,  /* number of terminals                       */
		      *ttab,  /* a representation of the T - table         */
			col,  /* loop index                                */
			pos,  /* loop index                                */
		     number,  /* used to count how many elements are in
				 the similar action code list              */
                   *sx_code,  /* a list of the external syntax code        */
           *reverse_sx_code,  /* a list of the reverse external syntax 
                                 code                                      */
                     *print;  /* vector to decide, which internal code 
                                 should be printed                         */
     char         *sx_print;  /* vector to decide, which external code 
                                 should be printed                         */



     if( extra_info )
	printf("begin of function Build_Similar_Act_Code( )\n");

     not     = *((*quick_data)[0]);

     if( ((reverse_sx_code  = (short *) calloc(
				     max_sx+1,sht )) == NULL) ||
	 ((sx_print  = (char *) calloc(
			  max_sx+1,sizeof( char ) )) == NULL) ||
	 ((print = (short  *) calloc(
			                  not,sht )) == NULL) )
	Error_Message( _BUILD_SIMILAR_ACT_CODE,MODULE_OPTIM_OUT,
                       NO_SPACE_FOR_VECTOR,ABORT," print" );


     ttab    = (*quick_data)[1];
     sx_code = (*quick_data)[2];

     for( col=0;col<max_sx+1;col++ )
        reverse_sx_code[col] = -1;

     for( col=0;col<not;col++ )
        if( reverse_sx_code[sx_code[col]] >= 0 )
           Error_Message( _BUILD_SIMILAR_ACT_CODE,MODULE_OPTIM_OUT,
                          SAME_SYNTAXCODE,ABORT,"" );
        else
           reverse_sx_code[sx_code[col]] = col;

     number = 0;
     for( col=0;col<not;col++ )
	if( changed_data->sim_act[col] >= 0 )
           {
	     number++;
             sx_print[sx_code[col]] = TRUE;
           } /* end of if( changed_da... */

     pos = 0;
     for( col=0;col<max_sx+1;col++ )
        if( sx_print[col] ) 
           print[reverse_sx_code[col]] = pos++;

     if( number )
	{
	  if( (sa = (struct sa_code*) calloc(
			   number,sizeof( struct sa_code ) )) == NULL )
	     Error_Message( _BUILD_SIMILAR_ACT_CODE,MODULE_OPTIM_OUT,
                            NO_SPACE_FOR_VECTOR,ABORT," sa" );

	  sa->number = number;
	  if( (sa->eq_list = (struct equality*) calloc(
			   number,sizeof( struct equality ) )) == NULL )
	     Error_Message( _BUILD_SIMILAR_ACT_CODE,MODULE_OPTIM_OUT,
                            NO_SPACE_FOR_VECTOR,ABORT," sa->eq_list");

	  for( col=0;col<not;col++ )
	     if( changed_data->sim_act[col] >= 0 )
                if( print[col] < 0 )
                   Error_Message( _BUILD_SIMILAR_ACT_CODE,MODULE_OPTIM_OUT,
                                  OBSCURE_STATE,ABORT,"" );
                else
		   {
		     sa->eq_list[print[col]].eq_elem = col;
		     sa->eq_list[print[col]].action.goto_action =
                                          OPERAND( ttab[changed_data->
						   sim_act[col]*not+col] );
                     scan_mark[OPERAND( ttab[changed_data->
				        sim_act[col]*not+col] )] = TRUE;
		   } /* end of if( changed_da... */
	} /* end of if( number ) */
     else
	sa = NULL;

     if( extra_info )
	printf("end of function Build_Similar_Act_Code( )\n");
     return( sa );

   } /* end of function Build_Similar_Act_Code( ) */







static char Is_Elem( quick_data,changed_data,user_data,state,term,used,
		     extra_info )

   readtype        *quick_data;  /* internal interface vector              */
   struct inter  *changed_data;  /* vector which stores the changes, which
				    have arisen from the optimization
				    techniques                             */
   struct user      *user_data;  /* vector which stores information set
				    by the user                            */
   short                 state,  /* the state which to be investigated     */
			  term;  /* the terminal to be investigated        */

   char                   used,  /* variable to choose different actions   */
		    extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                         */




/* This function tests, if the action ( state x term ) belongs to state.
   It is possible that this action belongs to another state now, because 
   the code could be shared.  
*/



   {
     short  *ttab,  /* a representation of the T - table                   */
	      not,  /* number of terminals                                 */
	      szc,  /* size of char in bits                                */
	     flag;  /* used to determine a position in the bitset          */

     if( extra_info )
	printf("begin of function Is_Elem( )\n");


     not  = *((*quick_data)[0]);
     ttab = (*quick_data)[1];


     szc  = sizeof( char ) * BYTE;
     flag = 1;

     if( used )
        {
	  if( changed_data->ident_act_rows[state] >= 0 )
	     {
	       if( changed_data->bit_set[changed_data->
	  	       ident_act_rows[state]][term/szc] & (flag<<(term%szc)) )
		  {
		    if( extra_info )
		       printf("end of function Is_Elem( )\n");
		    return( TRUE );
		  } /* end of if( (changed_da... */
	       else
		  {
		    if( extra_info )
		       printf("end of function Is_Elem( )\n");
		    return( FALSE );
		  } /* end of else ( if( (changed_da... ) */
	     } /* end of if( changed_da... */
          if( extra_info )
             printf("end of function Is_Elem( )\n");
          return( FALSE );
        } /* end of if( used ) */
     else
	{
	  if( changed_data->ident_act_rows[state] >= 0 )
	     if( changed_data->bit_set[changed_data->
		     ident_act_rows[state]][term/szc] & (flag<<(term%szc)) )
		{
		  if( extra_info )
		     printf("end of function Is_Elem( )\n");
		  return( FALSE );
		} /* end of if( (changed_da... */
	  if( changed_data->similar_act_rows[state] >= 0 )
	     if( changed_data->bit_set[state][term/szc] & (flag<<(term%szc)) )
		{
		  if( extra_info )
		     printf("end of function Is_Elem( )\n");
		  return( FALSE );
		} /* end of if( (changed_da... */
	  if( (changed_data->under_rows[state] >= 0)            &&
              (ttab[state*not+term] != ERROR_ENTRY )            &&
              (ttab[changed_data->under_rows[state]*not+term] 
                                                 != ERROR_ENTRY) )
	     if( Eq_Test( ttab[state*not+term],
		          ttab[changed_data->under_rows[state]*not+term],
		          state,changed_data->under_rows[state],
		          user_data,changed_data,extra_info ) )
	        {
	          if( extra_info )
		     printf("end of function Is_Elem( )\n");
	          return( FALSE );
	        } /* end of if( (changed_da... */

	  if( extra_info )
	     printf("end of function Is_Elem( )\n");
	  return( TRUE );
	} /* end of else ( if( used ) ) */

   } /* end of function Is_Elem( ) */





static struct rp *Find_Red_Sit( search_ptr,search_count,search_state,
                                extra_info )

   struct rp    *search_ptr;  /* pointer to all reduction situations of one
				 production                                */
   short       search_count,  /* number of reduction situations of the
				 production                                */
	      *search_state;  /* pointer to the searched state             */
   char          extra_info;  /* if extra_info == 1, then extra information
				 about begin and end of function is printed
				 out                                       */


/* It searches for one reduction situation and returns a pointer to the
   reduction situation.
*/



   {
     short  search=  /* position at pointer search_ptr                     */
		 0;
     char    found=  /* variable to decide if the searched element is      */
	     FALSE;  /* found                                              */


     if( extra_info )
	printf("begin of function Find_Red_Sit( )\n");


     while( (search < search_count) && !found )
	{
	  if( OPERAND( search_ptr[search].state ) == *search_state )
	     {
	       if( IS_DEL( search_ptr[search].state ) )
		  {
		    *search_state = search_ptr[search].rep.rep_state;
		    search = 0;
		  } /* end of if( IS_DEL( sea... */
	       else
		  found = TRUE;
	     } /* end of if( OPERAND( se... */
	  else
	     search++;
	} /* end of while( (search ... */
     if( search == search_count )
	Error_Message( _FIND_RED_SIT,MODULE_OPTIM_OUT,NOT_FIND_ELEMENT,
                       ABORT," *search_state" );

     search_ptr += search;

     if( extra_info )
	printf("end of function Find_Red_Sit( )\n");

     return( search_ptr );

   } /* end of function Find_Red_Sit( ) */









static void Build_Eq_List( quick_data,changed_data,user_data,print,
			   next_state,help_pars_ptr,scan_mark,extra_info )


   readtype               *quick_data;  /* internal interface vector       */
   struct inter         *changed_data;  /* vector which stores the changes,
					   which have arisen from the
					   optimization techniques         */
   struct user             *user_data;  /* vector which stores informa-
					   tions set by the user           */
   struct parser_code  *help_pars_ptr;  /* pointer to the parser code      */
   short                   next_state,  /* state to be investigated
					   yet                             */
                               *print;  /* vector which stores all termi-
					   nals which should be printed out*/
   char                    extra_info,  /* if extra_info == 1, then extra
					   information about begin and end
					   of function is printed out     */
                           *scan_mark;



/* In each state a lot of comparisons lead through. These comparisons
   and the corresponding actions should be saved in equality lists. These
   equality lists are built by this function.
*/


   {
     short             term,  /* loop index                                */
			not,  /* number of terminals                       */
		      *ttab,  /* a representation of the T - table         */
		       *lhs,  /* vector of the left hand side of all pro-
				 ductions                                  */
		     action,  /* saves an action, which is fixed by a state
				 and the left hand side of a production in
				 T - table                                 */
		       kind,  /* see above                                 */
	       search_count,  /* saves the number of reduction situations
				 of a production                           */
	       search_state;  /* the state to be serched                   */
     struct rp  *search_ptr,  /* this two pointers are used to search the  */
		  *help_ptr;  /* search state                              */

     if( extra_info )
	printf("begin of function Build_Eq_List( )\n");



     not  = *((*quick_data)[0]);
     ttab = (*quick_data)[1];
     lhs  = (*quick_data)[6];


     for( term=0;term<not;term++ )
	if( print[term] >= 0 )
	   if( (IS_REDUCEACT(   ttab[next_state*not+term] )) ||
	       (IS_SHREDACT( ttab[next_state*not+term] )) )
	      {
		if( (help_pars_ptr->eq_list[print[term]].action.
		   new_red_sit = (struct red*) malloc(
				  sizeof( struct red ) )) == NULL )
		   Error_Message( _BUILD_EQ_LIST,MODULE_OPTIM_OUT,
                                  NO_SPACE_FOR_STRUCTURE,ABORT," new_red_sit" );
		action = OPERAND( ttab[next_state*not+term] );
		help_pars_ptr->eq_list[print[term]].eq_elem = 
                                            SET_SHRED_NTACT( term );
		if( IS_SHREDACT( ttab[next_state*not+term] ) )
		   {
		     help_pars_ptr->eq_list[print[term]].action.new_red_sit->
                            scan =  TRUE;
		     search_ptr   = changed_data->ttsred_paths[action].pointer;
		     search_count = changed_data->ttsred_paths[
						    action].number_of_states;
		     kind = 1;
		   } /* end of if( IS_SHREDACT... */
		else
		   {
		     help_pars_ptr->eq_list[print[term]].action.new_red_sit->
                           scan = FALSE;
		     search_ptr   = changed_data->ttred_paths[action].pointer;
		     search_count = changed_data->ttred_paths[
						    action].number_of_states;
		     kind = 0;
		   } /* end of else ( if( IS_SHREDACT... ) */

		search_state = next_state;
		search_ptr = Find_Red_Sit( search_ptr,search_count,
					   &search_state,extra_info );

		help_pars_ptr->eq_list[print[term]].action.new_red_sit->pop =
			(*search_ptr).rep.pt_rp[1];
		if( (*search_ptr).rep.pt_rp[1] < 0 )
		   help_pars_ptr->eq_list[print[term]].action.new_red_sit->
			pcc = Find_Pcc_Elem( changed_data->pcc_list,
					     action,OPERAND( 
                                              (*search_ptr).state ),
					     kind,extra_info );
		else
		   help_pars_ptr->eq_list[print[term]].action.new_red_sit->
			pcc = NULL;

		if( IS_ABS( (*quick_data)[8][OPERAND(
				ttab[next_state*not+term] )] ) )
		   help_pars_ptr->eq_list[print[term]].action.new_red_sit->
		      old_sem = SET_SEM( OPERAND(
				ttab[next_state*not+term] ) );
		else
		   help_pars_ptr->eq_list[print[term]].action.new_red_sit->
		      old_sem = 0;
		if( IS_DGD( (*search_ptr).state ) )
		   {
		     if( IS_SHRED_NTACT( (*search_ptr).rep.pt_rp[3] ) )
			{
			  help_pars_ptr->eq_list[print[term]].action.
                                   new_red_sit->sem =
                              SET_REDUCEACT( OPERAND(
				       (*search_ptr).rep.pt_rp[3] ) );
			  if( IS_ABS( (*quick_data)[8][
			      OPERAND( (*search_ptr).rep.pt_rp[3] )] ) )
			     help_pars_ptr->eq_list[print[term]].action.
                                   new_red_sit->sem = 
                                   SET_SEM( help_pars_ptr->eq_list[print[term]].
				     action.new_red_sit->sem );

			  /* if continuation state is a new reduction situ-
			     ation, then some elements of these situation
			     must be poped too */
			  help_ptr     = changed_data->ntred_paths[OPERAND(
					   (*search_ptr).rep.pt_rp[3] )].
					   pointer;
			  search_count = changed_data->ntred_paths[OPERAND(
					   (*search_ptr).rep.pt_rp[3] )].
					   number_of_states;
			  search_state = (*search_ptr).rep.pt_rp[2];
			  help_ptr = Find_Red_Sit( help_ptr,search_count,
						   &search_state,extra_info );
                          if( (*help_ptr).rep.pt_rp[1] < 0 )
			     help_pars_ptr->eq_list[print[term]].action.
                                  new_red_sit->
				  pcc = Find_Pcc_Elem( changed_data->pcc_list,
						       OPERAND((*search_ptr).
							      rep.pt_rp[3] ),
						       OPERAND( (*help_ptr).
                                                                 state ),
						       2,extra_info );
			  else
			     help_pars_ptr->eq_list[print[term]].action.
                                 new_red_sit->
				 pop += (*help_ptr).rep.pt_rp[1];

			  if( user_data->individual_reduce_code )
			     {
			       help_pars_ptr->eq_list[print[term]].action.
				  new_red_sit->mark =
				     OPERAND( (*search_ptr).rep.pt_rp[3] );
                               help_pars_ptr->eq_list[print[term]].action.
				  new_red_sit->state = OPERAND(
							   search_state );
                               help_pars_ptr->eq_list[print[term]].action.
				  new_red_sit->kind = 2;
			     } /* end of if( user_data->... */
			  else
			     {
			       help_pars_ptr->eq_list[print[term]].action.
				  new_red_sit->mark =
				     lhs[OPERAND( (*search_ptr).
						rep.pt_rp[3] )];
                               help_pars_ptr->eq_list[print[term]].action.
				  new_red_sit->state = 0;
                               help_pars_ptr->eq_list[print[term]].action.
				  new_red_sit->kind = 0;
			     } /* end of else ( if( user_data->... ) */
			} /* end of if( IS_SHRED_NT... */
		     else
			{
			  help_pars_ptr->eq_list[print[term]].action.
                               new_red_sit->sem = 0;
			  help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->
				mark = OPERAND( (*search_ptr).rep.pt_rp[3] );
                          if( (help_pars_ptr->eq_list[print[term]].action.
                               new_red_sit->scan ) &&
                               !(IS_SEM( help_pars_ptr->eq_list[print[term]].
                                         action.new_red_sit->sem )) &&
                               !(IS_SEM( help_pars_ptr->eq_list[print[term]].
                                         action.new_red_sit->old_sem )) )
                             scan_mark[OPERAND( (*search_ptr).rep.pt_rp[3] )] = 
                                TRUE;
			  help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->state = 0;
			  help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->kind = 0;
			} /* end of else ( if( IS_SHRED_NT... ) */

		   } /* end of if( IS_DGD( (*s... */
		else
		   {
		     help_pars_ptr->eq_list[print[term]].action.new_red_sit->
			       sem = SET_REDUCEACT( 0 );
		     if( user_data->individual_reduce_code )
			{
			  help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->
				mark = OPERAND( ttab[next_state*not+term] );
                          help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->
				state = OPERAND( search_state );
                          help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->kind = kind;
			} /* end of if( user_data->... */
		     else
			{
			  help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->mark = lhs[OPERAND(
					     ttab[next_state*not+term] )];
                          help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->state = 0;
                          help_pars_ptr->eq_list[print[term]].action.
                                new_red_sit->kind = 0;
			} /* end of else ( if( user_data->... ) */
		   } /* end of else ( if( IS_DGD( (*s... ) */
	      } /* end of if( (IS_REDUCEA... */
	   else
	      {
		if( IS_ACCEPTACT( ttab[next_state*not+term] ) )
                   {
		     help_pars_ptr->eq_list[print[term]].eq_elem =
						       SET_ACCEPTACT( term );
                     if( IS_ABS( (*quick_data)[8][*((*quick_data)[13])] ) )
		        help_pars_ptr->eq_list[print[term]].action.
                          goto_action = SET_REDUCEACT( *((*quick_data)[13]) );
                     else
		        help_pars_ptr->eq_list[print[term]].action.
                          goto_action = 0;
                   } /* end of if( IS_ACCEPTACT(... */
		else
                   {
		     help_pars_ptr->eq_list[print[term]].eq_elem = term;
		     help_pars_ptr->eq_list[print[term]].action.goto_action =
			OPERAND( ttab[next_state*not+term] );
                     scan_mark[OPERAND( ttab[next_state*not+term] )] = TRUE;
                   } /* end of else ( if( IS_ACCEPTACT(... ) */
	      } /* end of else ( if( (IS_REDUCEA... ) */

     if( extra_info )
	printf("end of function Build_Eq_List( )\n");

   } /* end of function Build_Eq_List( ) */




static struct parser_code *Build_Parser_Code( quick_data,changed_data,
					      user_data,max_sx,scan_mark,
                                              extra_info )

   readtype           *quick_data;  /* internal interface vector           */
   struct inter     *changed_data;  /* vector which stores the changes,
				       which have arisen from the optimi-
				       zation techniques                   */
   struct user         *user_data;  /* vector which stores information
				       set by the user                     */
   short                   max_sx;
   char                extra_info,  /* if extra_info == 1, then extra
				       information about begin and end of
				       function is printed out            */
                       *scan_mark;


/* This function saved all information used by the parser in a list
   structure. Each vertex of the lists represents a state. In this vertex
   all relevant information about the state is saved.
*/


   {
     struct parser_code         *parser=  /* pointer to the structure      */
				   NULL,  /* which saves the parser code   */
			    *end_parser,  /* the end of the parser code
					     list                          */
			 *help_pars_ptr;  /* used to allocate storage space
					     for a new parser code block   */
     short                        state,  /* loop index                    */
				     st,  /* loop index                    */
				   term,  /* loop index                    */
                                    pos,
			     next_state,  /* the next state to be
					     investigated                  */
				 number,  /* count the number of elements
					     which will be saved in an
					     equality_list                 */
			     *over_rows,  /* stores for each state q its
					     representation state, if the
					     code of q is a subset of 
					     another state                 */
			       *used_vc,  /* this vector will be passed to
					     function Code_Compression     */
				  *ttab,  /* a representation of the T -
					     table                         */
				    nos,  /* number of states              */
				    not,  /* number of terminals           */
                       *reverse_sx_code,
                               *sx_code,
				 *print;  /* used to decide which actions
					     should be printed in the
					     current code block            */
     char                          used,  /* used to decide if a state is
					     used                         */
                              eq_state=
                                  FALSE,
                                *eq_rep,
			      *sx_print;  /* used to decide which actions
					     should be printed in the
					     current code block            */



     if( extra_info )
	printf("begin of function Build_Parser_Code( )\n");



     nos     = *((*quick_data)[9]);
     not     = *((*quick_data)[0]);
     ttab    = (*quick_data)[1];
     sx_code = (*quick_data)[2];


     if( ((eq_rep = (char  *) calloc(
			       nos,sizeof( char ) )) == NULL) ||
         ((over_rows  = (short *) calloc(
					  nos,sht )) == NULL) ||
	 ((used_vc  = (short *) calloc(
					  not,sht )) == NULL) ||
	 ((reverse_sx_code  = (short *) calloc(
				     max_sx+1,sht )) == NULL) ||
	 ((sx_print  = (char *) calloc(
			  max_sx+1,sizeof( char ) )) == NULL) ||
	 ((print = (short  *) calloc(
			                  not,sht )) == NULL) )
	Error_Message( _BUILD_PARSER_CODE,MODULE_OPTIM_OUT,NO_SPACE_FOR_VECTOR,
                       ABORT," print" );

     for( term=0;term<max_sx+1;term++ )
        reverse_sx_code[term] = -1;

     for( term=0;term<not;term++ )
        if( reverse_sx_code[sx_code[term]] >= 0 )
           Error_Message( _BUILD_PARSER_CODE,MODULE_OPTIM_OUT,SAME_SYNTAXCODE,
                          ABORT,"" );
        else
           reverse_sx_code[sx_code[term]] = term;

     for( state=0;state<nos;state++ )
        {
	  over_rows[state] = -1;
          eq_rep[state]    = FALSE;
        } /* end of for( state=0;st... */

     for( state=0;state<nos;state++ )
        {
	  if( changed_data->under_rows[state] >= 0 )
	     over_rows[changed_data->under_rows[state]] = state;
	  if( changed_data->equal_rows[state] >= 0 )
	     eq_rep[changed_data->equal_rows[state]] = TRUE;
        } /* end of for( state=0;st... */


     for( state=0;state<nos;state++ )
	if( (changed_data->equal_rows[state] < 0) &&
	    (over_rows[state] < 0) )
	   {
	     next_state = state;
	     used       = FALSE;
             eq_state   = FALSE;
             if( eq_rep[state] )
                {
                  if( (help_pars_ptr = (struct parser_code*) malloc(
	               sizeof( struct parser_code ) )) == NULL)
		     Error_Message( _BUILD_PARSER_CODE,MODULE_OPTIM_OUT,
                                    NO_SPACE_FOR_STRUCTURE,ABORT,
                                    " help_pars_ptr" );
	          help_pars_ptr->mark         = state;
		  help_pars_ptr->push         = changed_data->
					        min_push[state];
		  help_pars_ptr->stack_check  = changed_data->
					        stack_check_states[state];
                  help_pars_ptr->number       = 0;
                  help_pars_ptr->eq_list      = NULL;
                  help_pars_ptr->goto_default = -5;
		  help_pars_ptr->next         = NULL;
		  if( parser == NULL )
		     {
		       parser              = help_pars_ptr;
		       end_parser          = parser;
		     } /* end of if( parser ==... */
		  else
		     {
		       end_parser->next = help_pars_ptr;
		       end_parser       = end_parser->next;
		     } /* end of else ( if( parser ==... ) */


                  eq_state = TRUE;
                } /* end of if( eq_rep[st... */

	     while( next_state >= 0 )
		{
		  for( st=0;st<not;st++ )
		     print[st] = -1;
                  for( st=0;st<max_sx+1;st++ )
                     sx_print[st] = FALSE;
		  if( (help_pars_ptr = (struct parser_code*) malloc(
				    sizeof( struct parser_code ) )) == NULL)
		     Error_Message( _BUILD_PARSER_CODE,MODULE_OPTIM_OUT,
                                    NO_SPACE_FOR_STRUCTURE,ABORT,
                                    " help_pars_ptr" );

		  if( (used && (next_state == state))    ||
                      (eq_state && (next_state == state)) )
		     {
		       /* investigate ident_act_rows */
		       help_pars_ptr->mark        = state;
		       help_pars_ptr->push        = FALSE;
		       help_pars_ptr->stack_check = FALSE;
		     } /* end of if( used && (ne... */
		  else
		     if( next_state == state )
			{
			  used = FALSE;
			  help_pars_ptr->mark        = state;
			  help_pars_ptr->push        = changed_data->
						       min_push[next_state];
			  help_pars_ptr->stack_check = changed_data->
					      stack_check_states[next_state];
			} /* end of if( next_state ... */
		     else
			{
			  used = FALSE;
			  if( over_rows[next_state] >= 0 )
			     help_pars_ptr->mark = over_rows[next_state];
			  else
			     Error_Message( _BUILD_PARSER_CODE,
                                            MODULE_OPTIM_OUT,
                                            OBSCURE_STATE,ABORT,"" );
			  help_pars_ptr->push        = FALSE;
			  help_pars_ptr->stack_check = FALSE;
			} /* end of else ( if( next_state ... ) */
		  help_pars_ptr->next = NULL;
		  if( parser == NULL )
		     {
		       parser              = help_pars_ptr;
		       end_parser          = parser;
		     } /* end of if( parser ==... */
		  else
		     {
		       end_parser->next = help_pars_ptr;
		       end_parser       = end_parser->next;
		     } /* end of else ( if( parser ==... ) */

		  number = 0;
		  for( term=0;term<not;term++ )
		  if( (ttab[next_state*not+term] != ERROR_ENTRY) &&
		      Is_Elem( quick_data,changed_data,user_data,
			       next_state,term,used,extra_info) )
		     {
		       number++;
		       sx_print[sx_code[term]] = TRUE;
		     } /* end of if( (ttab[next_... */

                  pos = 0;
                  for( term=0;term<max_sx+1;term++ )
                     if( sx_print[term] ) 
                        print[reverse_sx_code[term]] = pos++;
              
                  help_pars_ptr->number = number;
		  if( number )
		     {
		       if( (help_pars_ptr->eq_list = (struct equality*)
			  calloc( number,sizeof( struct equality ) )) == NULL )
			  Error_Message( _BUILD_PARSER_CODE,MODULE_OPTIM_OUT,
                                         NO_SPACE_FOR_VECTOR,ABORT,
                                         " help_pars_ptr->eq_list" );

		       Build_Eq_List( quick_data,changed_data,user_data,print,
				      next_state,help_pars_ptr,scan_mark,
                                      extra_info );
		     } /* end of if( number ) */
		  if( changed_data->under_rows[next_state] >= 0 )
		     {
		       next_state   =	changed_data->under_rows[next_state];
		       help_pars_ptr->goto_default = -1;
		     } /* end of if( changed_dat... */
		  else
		     if( (changed_data->ident_act_rows[next_state] >= 0) &&
			 !used )
			{
			  if( changed_data->ident_act_rows[next_state] ==
			      next_state )
			     {
			       next_state    = changed_data->
					       ident_act_rows[next_state];
			       help_pars_ptr->goto_default = -1;
			     } /* end of if( changed_dat... */
			  else
			     {
			       help_pars_ptr->goto_default = changed_data->
				      ident_act_rows[next_state];
			       next_state = -1;
			     } /* end of else ( if( changed_dat... ) */
			} /* end of if( (changed_da... */
		     else
			if( changed_data->similar_act_rows[next_state] >= 0 )
			   {
			     next_state = -1;
			     help_pars_ptr->goto_default = -3;
			   } /* end of if( (changed_da... */
			else
			   {
			     next_state = -1;
			     if( number > 1 )
				{
				  used = TRUE;
				  if( user_data->code_compression )
				     help_pars_ptr->eq_list =
					 Code_Compression(
						    help_pars_ptr->eq_list,
						    &(help_pars_ptr->number),
						    used_vc,&used,
						    extra_info );
				  if( used && user_data->code_compression )
				     help_pars_ptr->goto_default = -4;
				  else
				     help_pars_ptr->goto_default = -2;
				} /* end of if( number > 1 ) */
			     else
                                help_pars_ptr->goto_default = -2;
			   } /* end of else  if( changed_da... ) */
		  used = TRUE;
		} /* end of while( next_sta... */
	   } /* end of if( (changed_da... */
	else
	   {
	     if( (help_pars_ptr = (struct parser_code*) malloc(
				    sizeof( struct parser_code ) )) == NULL)
		Error_Message( _BUILD_PARSER_CODE,MODULE_OPTIM_OUT,
                               NO_SPACE_FOR_STRUCTURE,ABORT," help_pars_ptr");

	     help_pars_ptr->mark         = state;
	     help_pars_ptr->push         = changed_data->min_push[state];
	     help_pars_ptr->stack_check  = changed_data->
						stack_check_states[state];
	     help_pars_ptr->eq_list      = NULL;
	     help_pars_ptr->number       = 0;

	     if( changed_data->equal_rows[state] >= 0 )
		{
		  next_state = changed_data->equal_rows[state];
                  if( over_rows[next_state] >= 0 )
                     {
		       while( over_rows[next_state] >= 0 )
		          next_state = over_rows[next_state];
                       help_pars_ptr->goto_default = next_state;
                     } /* end of if( over_rows... */
                  else
		     help_pars_ptr->goto_default = 
                                  SET_EQUAL_STATE( next_state );
		} /* end of if( changed_dat... */
	     else
                help_pars_ptr->goto_default = over_rows[state];

             help_pars_ptr->next = NULL;
	     if( parser == NULL )
		{
		  parser              = help_pars_ptr;
		  end_parser          = parser;
		} /* end of if( parser == NULL ) */
	     else
		{
		  end_parser->next = help_pars_ptr;
		  end_parser       = end_parser->next;
		} /* end of else ( if( parser == NULL ) ) */


	   } /* end of else ( if( (changed_da... ) */

     if( extra_info )
	printf("end of function Build_Parser_Code( )\n");

     return( parser );

   } /* end of function Build_Parser_Code( ) */







static void Build_Seman_List( quick_data,user_data,optim_out_data,
			      extra_info )

   readtype              *quick_data;  /* internal interface vector        */
   struct user            *user_data;  /* vector which stores information
					  fixed by the user                */
   struct optim_out  *optim_out_data;  /* stores the optimized code in a
					  form which could be printed out
					  easily                           */
   char                   extra_info;  /* if extra_info == 1, then extra
					  information about begin and end
					  of function is printed out       */

/* If there exist semantic actions then this function saves for each 
   production the corresponding semantic action. The semantic action 
   must be C - Code.
*/


   {
     short  *attribute_list, /* list of all terminals and theire attri-
                                butes ( skip - symbol, semantic - paran-                                       theses or list - separator )                */

	     *external_code,  /* a list of the external syntax code         */
			not,  /* number of terminals                        */
			min,  /* the minimal syntax code                    */
		       loop;  /* loop index                                 */
     char     found = FALSE;  /* used to decide, if the semantic action is
                                 found or not                               */

     if( extra_info )
	printf("begin of function Build_Seman_List()\n");

     external_code  = (*quick_data)[2];
     not            = *((*quick_data)[0]);
     attribute_list = (*quick_data)[11];


     min = optim_out_data->min_term;

     if( (optim_out_data->sem_symb_list = (char*) calloc(
	 optim_out_data->length_of_bvector,sizeof( char ) )) == NULL)
	Error_Message( _BUILD_SEMAN_LIST,MODULE_OPTIM_OUT,
                       NO_SPACE_FOR_VECTOR,ABORT,
                       " optim_out_data->sem_symb_list" );

     for( loop=0;loop<not;loop++ )
	if( IS_SEMANTIC( attribute_list[loop] ) )
	   {
	     found = TRUE;
	     optim_out_data->sem_symb_list[(external_code[loop]-min)/BYTE] =
		 optim_out_data->sem_symb_list[(external_code[loop]-min)/
		 BYTE] | (1 << ((external_code[loop]-min)%BYTE));
	   } /* end of if( IS_SEMANTIC( at... */

     if( !found )
	{
	  free( optim_out_data->sem_symb_list );
	  Error_Message( _BUILD_SEMAN_LIST,MODULE_OPTIM_OUT,
                         NO_SEMANTIC_TERMINALS,WARN,"" );
	  user_data->semantic_symbols   = FALSE;
	  optim_out_data->sem_symb_list = NULL;
	} /* end of if( !found ) */

     if( extra_info )
	printf("end of function Build_Seman_List()\n");
   } /* end of function Build_Seman_List() */







struct optim_out *Optim_Out( quick_data,changed_data,user_data,extra_info )


   readtype        *quick_data;  /* internal interface vector              */
   struct inter  *changed_data;  /* vector which stores the changes, which
				    have arisen from the optimization
				    techniques                             */
   struct user      *user_data;  /* vector which stores information set
				    by the user                            */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tion about begin and end of function
				    is printed out                        */




/* This function controls the preparation of the normal parser data
   for printing out. The information about the error recovery will be
   prepared in module error_out.
*/

   {
     reach                  *reach_ptr;  /* saves which reduction situa-
					    tions could be reached in the
					    optimized code                 */
     struct optim_out  *optim_out_data;  /* stores the optimized code in
					    a form which could be printed
					    out easily                       */
     rep_code                  *rep_vc;  /* vector which saves the infor-
					    mation about shared reduce code
					    and " Unit - Marks "           */
     short                         nop,  /* number of productions          */
                                   nos,  /* number of states               */
				  prod;  /* loop index                     */



     if( extra_info )
	printf("begin of function Optim_Out( )\n");

     nop = *((*quick_data)[5]);
     nos = *((*quick_data)[9]);

     if( ((rep_vc         = (rep_code*)         calloc(
				      nop,sizeof( rep_code ) )) == NULL) ||
	 ((optim_out_data = (struct optim_out*) malloc(
				  sizeof( struct optim_out )) ) == NULL) )
	Error_Message( _OPTIM_OUT,MODULE_OPTIM_OUT,NO_SPACE_FOR_STRUCTURE,
                       ABORT," optim_out_data" );

     if( (optim_out_data->scan_mark = (char*) 
                    calloc( nos,sizeof( char )) ) == NULL )
	Error_Message( _OPTIM_OUT,MODULE_OPTIM_OUT,NO_SPACE_FOR_VECTOR,
                       ABORT," optim_out_data->scan_mark" );


     optim_out_data->nos                  =  *((*quick_data)[9]);
     optim_out_data->red_code             = NULL;
     optim_out_data->sim_act_code         = NULL;
     optim_out_data->parser               = NULL;
     optim_out_data->pcc_list             = NULL;
     optim_out_data->longest_path         = changed_data->longest_path;
     optim_out_data->bit_set              = changed_data->bit_set;
     optim_out_data->similar_act_rows     = changed_data->similar_act_rows;
     optim_out_data->similar_act_branches = changed_data->
						similar_act_branches;
     optim_out_data->sem_symb_list        = NULL;
     optim_out_data->bvector              = NULL;
     optim_out_data->length_of_bvector    = 0;
     optim_out_data->sx_code_list         = (*quick_data)[2];

     for( prod=0;prod<nop;prod++ )
	rep_vc[prod] = NULL;

     Det_Min_Max_Term( quick_data,optim_out_data,extra_info );

     reach_ptr = Reachebility_Test( quick_data,changed_data,extra_info );


     if( !user_data->individual_reduce_code )
	optim_out_data -> red_code = Build_Red_Code( quick_data,user_data,
						     changed_data,reach_ptr,
						     rep_vc,extra_info );
     else
	optim_out_data -> red_code = Build_Ind_Red_Code( quick_data,
							 user_data,
							 changed_data,
							 reach_ptr,rep_vc,
							 extra_info );

     if( (user_data->delete_unit_marks)             ||
	 ((user_data->individual_reduce_code) &&
	  (user_data->share_reduce_code)       )     )
	Change_Red_Eq_Marks( rep_vc,optim_out_data->red_code,optim_out_data->
                             scan_mark,extra_info );

     free( reach_ptr );

     optim_out_data->parser = Build_Parser_Code( quick_data,changed_data,
						 user_data,optim_out_data->
                                                 max_term,optim_out_data->
                                                 scan_mark,extra_info );

     if( (user_data->delete_unit_marks)             ||
	 ((user_data->individual_reduce_code) &&
	  (user_data->share_reduce_code)       )     )
	Change_Pars_Eq_Marks( rep_vc,optim_out_data->parser,optim_out_data->
                              scan_mark,extra_info );


     if( optim_out_data->similar_act_branches )
	optim_out_data->sim_act_code = Build_Similar_Act_Code( quick_data,
							       changed_data,
                                                               optim_out_data->
                                                               max_term,
                                                               optim_out_data->
                                                               scan_mark,
							       extra_info );
     optim_out_data->pcc_list = changed_data->pcc_list;

     if( user_data->semantic_symbols )
	Build_Seman_List( quick_data,user_data,optim_out_data,extra_info );

     if( extra_info )
	printf("end of function Optim_Out( )\n");

     return( optim_out_data );

   } /* end of function Optim_Out( ) */







