/***************************************************************************/
/* filename : high.h                               first edit  : 10.01.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 13.07.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
/* $Id: high.h,v 1.1 1992/01/10 14:38:40 cogito Exp $ */


/************************* MACRO - DEFINITIONS *****************************/


#define SET_SHREDACT( entry )            entry | 0x4000
          /* This mask is used to know that the action is a shift reduce 
             action.                                                       */

#define SET_SHIFT_SITUATION( entry )     entry | 0x8000
          /* This mask is used to know that the current situation is a 
             shift situation.                                              */

#define SET_DGD( entry )                 entry | 0x4000
          /* With this mask the reduction situation, to which direct
             goto determination could apply is marked .                    */

#define SET_NO_DGD( entry )              entry ^ 0x4000
          /* If a pop count conflict occurs in a reduction situation, to 
             which direct goto determination could apply, the setting
             must be deleted.                                              */

#define SET_DGD_NOT_ALLOWED( entry )     entry | 0x2000


#define IS_DGD_NOT_ALLOWED( entry )      entry & 0x2000


#define IS_ABS( prodcode )               prodcode >= 0
          /* Tests for a given production code, if the production belongs 
             to the abstract syntax.                                       */

#define IS_SHIFT_SITUATION( entry )      entry & 0x8000
          /* This mask is used to know that the action is a shift action.  */

#define IS_DGD( entry )                  entry & 0x4000
          /* Used to test if the reduction situation is marked as 
             direct goto determination could apply.                        */


#define LAST_SYMBOL( string,length )     (length>0) ? string[length-1] : -1
          /* Used to get the last symbol of a vector.                      */

#define GET_CONT_STATE( ntab,state,non,lhs )     ntab[state*non+lhs]
          /* Used to get the continuation, state of a reduction, from the 
             N - table                                                     */
     
