/***************************************************************************/
/* filename : clearing.c                           first edit  : 18.02.91  */
/* author   : Markus Adam                                                  */
/*            In der Aue 26                        last change : 20.08.91  */
/*            4780 Lippstadt                                               */
/*            Germany                                                      */
/***************************************************************************/

/* $Revision: 1.1 $ */
static char rcsid[] = "$Id: clearing.c,v 1.1 1992/01/10 14:38:40 cogito Exp $";

/*************************** INCLUDE - FILES *******************************/

typedef short *readtype[];

#include<stdio.h>

#include<malloc.h>

#include "over.h"

#include "over_types.h"

#include "determ.h"

#include  "clear.h"

#include "errors.h"


/****************************** FUNCTIONS *********************************/


char Eq_Test( op1,op2,row1,row2,user_data,changed_data,extra_info )

   short                   op1,  /* the first operand of the comparison    */
			   op2,  /* the second operand of the comparison   */
			  row1,  /* the number of the first row ( state )  */
			  row2;  /* the number of the second row ( state ) */
   struct inter  *changed_data;  /* internal interface between the opti-
				    mization modules                        */
   struct user      *user_data;  /* the saved information, passed from
				    the user                               */
   char             extra_info;  /* if extra_info == 1, then extra informa-
				    tions about begin and end of function
				    is printed out                        */


/* This function tests if two positions in T - table are equal. If the
   user specified that the lower optimization techniques should apply
   before the higher optimization techniques, comparison is easy,
   because only the two T - table entries must be compared.  But, when
   the higher optmization techniques are called first, then the
   entries in T - table can be changed.  These changes can be very
   complex, so we must inspect very different cases here.

   The result of this function is, the result of testing the two
   entries to see if they are equal or not.
*/

   {
     struct rp    *help_ptr1,  /* help pointer, used to search for a 
                                  reduction situation                      */
		  *help_ptr2;  /* help pointer, used to search for a 
                                  reduction situation                      */
     char        equal=FALSE,  /* used to decide if two reduction situa-
				  tions are equal                          */
		       found;  /* used to decide if a searched reduction
				  situation is found                       */
     short		 st1,  /* loop index of a while loop to find the
				  first reduction situation                */
			 st2,  /* loop index of a while loop to find the
				  second reduction situation               */
		state1_count,  /* number of reduction situations which 
                                  exist in the first production            */
		state2_count;  /* number of reduction situations which
                                  exist in the second production           */



     if( extra_info )
	printf("begin of function Eq_Test()\n");
     if( !user_data->high_before_low )
	if( op1 == op2 )
	   {
	     if( extra_info )
		printf("end of function Eq_Test()\n");
	     return( TRUE );
	   } /* end of if( op1 == op2 ) */
	else
	   {
             if( extra_info )
		printf("end of function Eq_Test()\n");
	     return( FALSE );
	   } /* end of else ( if( op1 == op2 ) ) */
     else
	/* are there changes in  T - table by High_Optim ? */
	if( IS_SHIFTACT( op1 ) )
	   if( op1 != op2 )
	      {
                if( extra_info )
		   printf("end of function Eq_Test()\n");
		return( FALSE );
	      } /* end of if( op1 != op2 ) */
	   else
	      {
                if( extra_info )
		   printf("end of function Eq_Test()\n");
		return( TRUE );
	      } /* end of else ( if( op1 != op2 ) ) */
	else
           if( user_data->individual_reduce_code )
              {
                /* The origin states must be disjunct, if one 
                   production is reduced in more than one state.  */
                if( extra_info )
	           printf("end of function Eq_Test()\n");
                return( FALSE );
              }
           else
	      {
                equal = FALSE;
	        if( (IS_REDUCEACT( op1 )) && (op1 == op2) )
		   {
		     help_ptr1 = changed_data->ttred_paths[OPERAND(							      op1 )].pointer;
		     state1_count = changed_data->ttred_paths[OPERAND(						op1 )].number_of_states;
		     help_ptr2 = changed_data->ttred_paths[OPERAND(							      op2 )].pointer;
		     state2_count = changed_data->ttred_paths[OPERAND(						op2 )].number_of_states;
		     equal = TRUE;
		   } /* end of if( (IS_REDUCEA... */
	        else
		   if( (IS_SHREDACT( op1 )) && (op1 == op2) )
		      {
		        help_ptr1 = changed_data->ttsred_paths[OPERAND(							      op1 )].pointer;
		        state1_count = changed_data->ttsred_paths[OPERAND(						op1 )].number_of_states;
		        help_ptr2 = changed_data->ttsred_paths[OPERAND(							      op2 )].pointer;
		        state2_count = changed_data->ttsred_paths[OPERAND(						op2 )].number_of_states;
		        equal = TRUE;
		      } /* end of if( (IS_SHREDAC... */
	        if( !equal )
		   {
		     if( extra_info )
		        printf("end of function Eq_Test()\n");
		     return( FALSE );
		   } /* end of if( !equal ) */
	        else
		   {
		     st1 = 0;
		     found = FALSE;
		     while( (st1<state1_count) && !found )
		        if( OPERAND( help_ptr1[st1].state ) == row1 )
			   if( !(IS_DEL( help_ptr1[st1].state )) )
			      found = TRUE;
			   else
			      {
			        row1 = help_ptr1[st1].rep.rep_state;
			        st1 = 0;
			      } /* end of else ( if( !(IS_DEL( h... ) */
		        else
			   st1++;
		     if( st1 == state1_count )
		        Error_Message( _EQ_TEST,MODULE_CLEARING,
                                       NOT_FIND_ELEMENT,ABORT," row1" );

		     st2 = 0;
		     found = FALSE;
		     while( (st2<state2_count) && !found )
		        if( OPERAND( help_ptr2[st2].state ) == row2 )
			   if( !(IS_DEL( help_ptr2[st2].state )) )
			      found = TRUE;
			   else
			      {
			        row2 = help_ptr2[st2].rep.rep_state;
			        st2  = 0;
			      } /* end of else ( if( !(IS_DEL( h... ) */
		        else
			   st2++;
		     if( st2 == state2_count )
		        Error_Message( _EQ_TEST,MODULE_CLEARING,
                                       NOT_FIND_ELEMENT,ABORT," row2" );

		     /* test if one reduction path includes a pop
		        count conflict */
		     if( ( help_ptr1[st1].rep.pt_rp[1] == -1 ) ||
		         ( help_ptr2[st2].rep.pt_rp[1] == -1 ) )
		        {
		          if( extra_info )
			   printf("end of function Eq_Test()\n");
		          return( FALSE );
		        } /* end of if( ( help_ptr1... */
		     else
		        /* can direct goto determination apply to both
			   states */
                        if( IS_DGD( help_ptr1[st1].state )     &&
			    IS_DGD( help_ptr2[st2].state )      )
			   if( (*(help_ptr1[st1].rep.pt_rp+3) ==
			        *(help_ptr2[st2].rep.pt_rp+3))    &&
			       (*(help_ptr1[st1].rep.pt_rp+1) ==
			        *(help_ptr2[st2].rep.pt_rp+1))    )
			      {
			        if( extra_info )
				   printf("end of function Eq_Test()\n");
			        return( TRUE );
			      } /* end of if( (*(help_ptr... */
			   else
			      {
			        if( extra_info )
				   printf("end of function Eq_Test()\n");
			        return( FALSE );
			      } /* end of else ( if( (*(help_ptr... ) */
		        else
                           if( IS_DGD( help_ptr1[st1].state )  ||
			       IS_DGD( help_ptr2[st2].state )   )
                              {
			        if( extra_info )
				   printf("end of function Eq_Test()\n");
			        return( FALSE );
                              }
                           else
			      {
			        /* are the number of pop's are equal */
			        if( *(help_ptr1[st1].rep.pt_rp+1) ==
				    *(help_ptr2[st2].rep.pt_rp+1) )
				   {
				     if( extra_info )
				        printf("end of function Eq_Test()\n");
				     return( TRUE );
				   } /* end of if( *(help_ptr1... */
			        else
				   {
				     if( extra_info )
				        printf("end of function Eq_Test()\n");
				     return( FALSE );
				   } /* end of else ( if( *(help_ptr1... ) */
			      } /* end of else ( if( IS_DGD... ) */
		} /* end of else ( if( !equal ) ) */
	   } /* end of else ( if( IS_SHIFTACT... ) */


   } /* end of function Eq_Test() */





static char Exist_Other_Sits( quick_data,changed_data,state,red_prod,
			      extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct inter  *changed_data;  /* interface between the optimization
				    modules                                 */
   short                 state,  /* the actual state                       */
		      red_prod;  /* the actual production                  */
   char             extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */


/* If one state has some common actions with another state and one action
   is a reduce action, then it is possible, that this reduction situation 
   can not be deleted because the possibility exists for the same reduc-
   tion in the state to appear once again and this can't be shared. This 
   function decides, if the reduction situation can be deleted or not.
*/


   {
     char   delete=  /* used to decide if a reduction situation can be     */
	      TRUE,  /* deleted                                            */
	     exist=  /* used to decide if more that one instance           */
             FALSE,  /* of the same reduction entry exists                 */
	      flag=  /* used to get single bits of a bitset                */
		 1;
     short    symb=  /* loop index of a while loop                         */
		 0,
	       not,  /* number of terminals                                */
	       szc;  /* size of char in bits                               */


     if( extra_info )
	printf("begin of function Exist_Other_Sits( )\n");

     szc = BYTE * sizeof( char );
     not = *((*quick_data)[0]);
     while( (symb<not) && delete )
	{
	  if( (OPERAND( (*quick_data)[1][state*not+symb] ) == red_prod) &&
	      ((IS_SHREDACT( (*quick_data)[1][state*not+symb] )) ||
	       (IS_REDUCEACT( (*quick_data)[1][state*not+symb] )) )     )
	     {
	       exist = TRUE;
	       if( !(changed_data->bit_set[changed_data->ident_act_rows[
		   state]][symb/szc] & (flag << (symb%szc))) )
		  delete = FALSE;
	     } /* end of if( (OPERAND( (... */
	  symb++;
	} /* end of while( (symb<n... */

     if( extra_info )
	printf("end of function Exist_Other_Sits( )\n");

     return( (exist && delete) );

   } /* end of function Exist_Other_Sits( ) */










static char Exist_Red_In_Sit( quick_data,changed_data,state,red_prod,
			      extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct inter  *changed_data;  /* interface between the optimization
				    modules                                 */
   short                 state,  /* the actual state                       */
		      red_prod;  /* the actual production                  */
   char             extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */


/*
*/


   {
     char    exist=  /* used to decide if more that one instance           */
             FALSE,  /* of the same reduction entry exists                 */
	      flag=  /* used to get single bits of a bitset                */
		 1;
     short    symb=  /* loop index of a while loop                         */
		 0,
	       not,  /* number of terminals                                */
	       szc;  /* size of char in bits                               */


     if( extra_info )
	printf("begin of function Exist_Red_In_Sit( )\n");

     szc = BYTE * sizeof( char );
     not = *((*quick_data)[0]);
     while( (symb<not) && !exist )
	{
	  if( (OPERAND( (*quick_data)[1][state*not+symb] ) == red_prod) &&
	      ((IS_SHREDACT( (*quick_data)[1][state*not+symb] )) ||
	       (IS_REDUCEACT( (*quick_data)[1][state*not+symb] )) )     )
	     {
	       if( (changed_data->bit_set[changed_data->ident_act_rows[
		   state]][symb/szc] & (flag << (symb%szc))) )
                  exist = TRUE;
	     } /* end of if( (OPERAND( (... */
	  symb++;
	} /* end of while( (symb<n... */

     if( extra_info )
	printf("end of function Exist_Red_In_Sits( )\n");

     return( exist );

   } /* end of function Exist_Red_In_Sit( ) */





static void Save_Origin_States( pointer_to_reds,pos,rep_state,count,
                                extra_info )
   struct rp  *pointer_to_reds;
   short                   pos,
                     rep_state,
                         count;
   char             extra_info;

/*

*/

   {  
     short       state=
                     0,
                  pos1,
                  pos2,
            *space_ptr,
                 space;
     char        found=
                 FALSE;

     if( extra_info )
	printf("begin of function Save_Origin_States( )\n");

     while( (state<count) && !found )
        if( OPERAND( pointer_to_reds[state].state ) ==
            rep_state )
           if( IS_DEL( pointer_to_reds[state].state ) )
              {
                rep_state = pointer_to_reds[state].rep.rep_state;
                state = 0;
              }  /* end of if( IS_DEL( point... */
           else
              found = TRUE;
        else
           state++;
     if( state == count )
        Error_Message( );

     space = pointer_to_reds[state].rep.pt_rp[0] +
             pointer_to_reds[pos].rep.pt_rp[0];

     if( (space_ptr = (short*) calloc( 2+2*space,sizeof( short ) )) == NULL )
        Error_Message();

     space_ptr[0] = space;
     space_ptr[1] = pointer_to_reds[state].rep.pt_rp[1];

     pos1 = 0;
     pos2 = 0;

     while( (pos1<pointer_to_reds[pos].rep.pt_rp[0])   &&
            (pos2<pointer_to_reds[state].rep.pt_rp[0])  )
        if( pointer_to_reds[pos].rep.pt_rp[2+2*pos1] <
            pointer_to_reds[state].rep.pt_rp[2+2*pos2] )
           {
             space_ptr[2+2*(pos1+pos2)] =
                  pointer_to_reds[pos].rep.pt_rp[2+2*pos1];
             space_ptr[3+2*(pos1+pos2)] =
                  pointer_to_reds[pos].rep.pt_rp[3+2*pos1++];
           }  /* end of if( pointer_to_... */
        else
           {
             space_ptr[2+2*(pos1+pos2)] =
                  pointer_to_reds[state].rep.pt_rp[2+2*pos2];
             space_ptr[3+2*(pos1+pos2)] =
                  pointer_to_reds[state].rep.pt_rp[3+2*pos2++];
           }  /* end of else ( if( pointer_to_... ) */

     while( pos1<pointer_to_reds[pos].rep.pt_rp[0] )
        {
          space_ptr[2+2*(pos1+pos2)] =
               pointer_to_reds[pos].rep.pt_rp[2+2*pos1];
          space_ptr[3+2*(pos1+pos2)] =
               pointer_to_reds[pos].rep.pt_rp[3+2*pos1++];
        }  /* end of while( pos1<pointer... */

     while( pos2<pointer_to_reds[state].rep.pt_rp[0] )
        {
          space_ptr[2+2*(pos1+pos2)] =
               pointer_to_reds[state].rep.pt_rp[2+2*pos2];
          space_ptr[3+2*(pos1+pos2)] =
               pointer_to_reds[state].rep.pt_rp[3+2*pos2++];
        }  /* end of while( pos2<pointer_to_... */

     free( pointer_to_reds[state].rep.pt_rp );
     pointer_to_reds[state].rep.pt_rp = space_ptr;

     if( extra_info )
	printf("end of function Save_Origin_States( )\n");

   }  /* end of function Save_Origin_States( ) */







void Delete_Shared_Red_Sits( quick_data,changed_data,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct inter  *changed_data;  /* interface between the optimization
				    modules                                 */
   char             extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */


/* If two or more reduction situations are shared, only one representant 
   is used. The other situations are deleted by this function.   
*/

   {
     short          *over,  /* this vector saves where the representation 
			       state is for each state which is a subset  
			       of another state.			   */
		    state,  /* loop index                                  */
		     prod,  /* loop index                                  */
		      nos,  /* number of states                            */
		      nop,  /* number of productions                       */
		    count;  /* number of reduction situations of one pro-
			       duction                                     */
     char         changed,  /* Criterion to break of a while loop. Used
			       to decide if an entry is changed            */
		    shift;  /* loop index                                  */
     struct rp  *help_ptr;  /* help pointer to reduction situations        */


     if( extra_info )
	printf("begin of function Delete_Shared_Red_Sits( )\n");

     nos = *((*quick_data)[9]);
     nop = *((*quick_data)[5]);
     if( (over = (short*) calloc( nos,sht )) == NULL )
        Error_Message( _DELETE_SHARED_RED_SITS,MODULE_CLEARING,
                       NO_SPACE_FOR_VECTOR,ABORT," over" );

     for( state=0;state<nos;state++ )
	over[state] = -1;

     for( state=0;state<nos;state++ )
	if( changed_data->under_rows[state] >= 0 )
	   over[changed_data->under_rows[state]] = state;


     changed = TRUE;
     while( changed )
        {
          changed = FALSE;
	  for( state=0;state<nos;state++ )
	     if( over[state] >= 0 )
	       if( over[over[state]] >= 0 )
		  {
		    over[state] = over[over[state]];
		    changed = TRUE;
		  } /* end of if( over[over[s... */

	} /* end of while( changed ) */
     for( state=0;state<nos;state++ )
	if( over[state] >= 0 )
	   if( changed_data->equal_rows[over[state]] >= 0 )
		over[state] = changed_data->equal_rows[over[state]];

     for( shift=0;shift<2;shift++ )
	for( prod=0;prod<nop;prod++ )
	   {
	     if( shift )
		{
		  help_ptr = changed_data->ttsred_paths[prod].pointer;
		  count    = changed_data->ttsred_paths[prod].number_of_states;
		} /* end of if( shift ) */
	     else
		{
		  help_ptr = changed_data->ttred_paths[prod].pointer;
		  count    = changed_data->ttred_paths[prod].number_of_states;
		} /* end of else ( if( shift ) ) */
	     for( state=0;state<count;state++ )
		{

		  if( changed_data->equal_rows[OPERAND(			    help_ptr[state].state)] >= 0 )
		     {
                       Save_Origin_States( help_ptr,state,changed_data->
                                           equal_rows[OPERAND(help_ptr[state].
                                           state)],count,extra_info );
		       help_ptr[state].state = SET_DEL(
						   help_ptr[state].state );
		       free( help_ptr[state].rep.pt_rp);
		       help_ptr[state].rep.rep_state = changed_data->
                                  equal_rows[OPERAND( help_ptr[state].state )];
		     } /* end of if( changed_dat... */
		  else
		     if( over[OPERAND( help_ptr[state].state )] >= 0 )
			{
                          Save_Origin_States( help_ptr,state,over[OPERAND( 
                                              help_ptr[state].state )],count,
                                              extra_info );
			  help_ptr[state].state = SET_DEL(
						   help_ptr[state].state );
			  free( help_ptr[state].rep.pt_rp);
			  help_ptr[state].rep.rep_state =
                                  over[OPERAND( help_ptr[state].state )];
			} /* end of if( over[OPERAN... */
		     else
			if( (changed_data->ident_act_rows[OPERAND(					    help_ptr[state].state )]>=0)  &&
			    (changed_data->ident_act_rows[OPERAND(				 help_ptr[state].state )]) != OPERAND(						   help_ptr[state].state) )
                           {
			     if( Exist_Other_Sits( quick_data,changed_data,
						   OPERAND( help_ptr[state].
						   state),prod,extra_info ) )
			        {
                                  Save_Origin_States( help_ptr,state,
                                                      changed_data->
                                                      ident_act_rows[OPERAND(					              help_ptr[state].state )],
                                                      count,extra_info );
				  help_ptr[state].state = SET_DEL(
						   help_ptr[state].state );
				  free( help_ptr[state].rep.pt_rp);
				  help_ptr[state].rep.rep_state = changed_data->
                                      ident_act_rows[OPERAND( help_ptr[state].
                                                              state )];
			        } /* end of if( Exist_Other... */
                             else
                                if( Exist_Red_In_Sit( quick_data,changed_data,
						      changed_data->ident_act_rows[
                                                      OPERAND( help_ptr[state].
						      state)],prod,extra_info ) )
                                   Save_Origin_States( help_ptr,state,
                                                       changed_data->
                                                       ident_act_rows[OPERAND(					               help_ptr[state].state )],
                                                       count,extra_info );
                           }
		} /* end of for( state=0;st... */
	   } /* end of for( prod=0;pro... */

     if( extra_info )
	printf("end of function Delete_Shared_Red_Sits( )\n");

   } /* end of function Delete_Shared_Red_Sits( ) */





static void Join_Reds( quick_data,changed_data,prod,help_ptr,state_count,
		       join,min,rep,nos,redp_ptr,extra_info )

   readtype           *quick_data;  /* interface vector to optimization    */
   struct inter     *changed_data;  /* interface between the optimization
				       modules                              */
   struct rp            *help_ptr;  /* help pointer to the reduction
				       situations of the actual produc-
				       tion                                */
   char                     *join,  /* in this vector all states are
				       marked which share the actual
				       reduction situation                 */
		       extra_info;  /* if extra_info == 1, then extra
				       information about begin and end of
				       function is printed out            */
   short             state_count,  /* number of reduction situations of
				       the current production              */
			      min,  /* the minimum state number of all
				       states which should be joined       */
			      nos,  /* number of states                    */
			     prod,  /* the actual investigate production   */
			     *rep;  /* in this vector for each state his
				       representation state is saved       */

   struct ctr_redp      *redp_ptr;  /* vector used to save and join
				       the reduction situation, which
				       should be shared                    */


/* If two or more states share the code of a reduce or shift/reduce entry,
   it is possible that corresponding reduction situations are different.
   Before further investigations are applied to these reduction situations,
   I join they to one reduction situation. So the investigations give the
   correct result.
*/


   {
     short           st,  /* loop index                                    */
		  state,  /* loop index                                    */
	    first_state,  /* used to find the state equal to min ( see
			     above )                                       */
		    pos,  /* used to distribute the old data of the reduc-
			     tion situations to the new pointer soace_ptr  */
		minimum,  /* the reduction situation with the lowest
			     number of reduction paths                     */
	      min_state,  /* the corresponding state                       */
	       eq_state,  /* the actual state which will be investigated   */
		space=0,  /* number of states, which share the reduction
			     situation                                     */
	     *space_ptr;  /* pointer to the new, joined reduction
			     situation                                     */
     char        delete;  /* used to decide if one reduction situation
                             could be joined, and indicate if it should be
			     deleted                                       */


     if( extra_info )
	printf("begin of function Join_Reds()\n");

     for( st=0;st<state_count;st++ )
	if( join[OPERAND( help_ptr[st].state )] )
	   {
	     space += help_ptr[st].rep.pt_rp[0];
	     redp_ptr[OPERAND( help_ptr[st].state )].numb =
					    help_ptr[st].rep.pt_rp[0];
	     redp_ptr[OPERAND( help_ptr[st].state )].pointer =
					    help_ptr[st].rep.pt_rp+2;
	   } /* end of if( join[OPERAN... */
     if( (space_ptr = (short *) calloc(
				 2+2*space,sizeof( short ) )) == NULL )
	Error_Message( _JOIN_REDS,MODULE_CLEARING,NO_SPACE_FOR_VECTOR,
                       ABORT," space_ptr" );

     space_ptr[0] = space;
     first_state = 0;
     while( (OPERAND( help_ptr[first_state].state ) != min) &&
	    (first_state<state_count)  )
	first_state++;
     if( first_state==state_count )
	Error_Message( _JOIN_REDS,MODULE_CLEARING,NOT_FIND_ELEMENT,ABORT,
                       " min" );


     pos = 2;
     while( pos<2*space+2 )
	{
	  minimum   = nos+1;
	  min_state = -1;
	  for( state=first_state;state<state_count;state++ )
	     {
	       eq_state = OPERAND( help_ptr[state].state );
	       if( join[eq_state] && (redp_ptr[eq_state].numb>0) )
		  if( minimum > *(redp_ptr[eq_state].pointer) )
		     {
		       minimum   = *(redp_ptr[eq_state].pointer);
		       min_state = eq_state;
		     } /* end of if( minimum > *... */
	     } /* end of for( state=firs... */
	  if( min_state<0 )
	     Error_Message( _JOIN_REDS,MODULE_CLEARING,NOT_FIND_ELEMENT,ABORT,
                            " min_state" );
	  space_ptr[pos++] = *(redp_ptr[min_state].pointer);
	  redp_ptr[min_state].pointer++;
	  space_ptr[pos++] = *(redp_ptr[min_state].pointer);
	  if( --redp_ptr[min_state].numb  > 0 )
	     redp_ptr[min_state].pointer++;
	} /* end of while( pos<2*sp... */

     free( help_ptr[first_state].rep.pt_rp );

     help_ptr[first_state].rep.pt_rp = space_ptr;


     for( st=0;st<state_count;st++ )
	if( join[OPERAND( help_ptr[st].state )]      ||
	    join[rep[OPERAND( help_ptr[st].state )]] )
	       {
		 rep[OPERAND( help_ptr[st].state )] = min;
		 if( OPERAND( help_ptr[st].state ) != min )
		    {
		      if( join[OPERAND( help_ptr[st].state )] )
			 {
			   delete = TRUE;
			   if( delete )
			      {
				help_ptr[st].state = SET_DEL(
							help_ptr[st].state );
				free( help_ptr[st].rep.pt_rp );
			      } /* end of if( delete ) */
			 } /* end of if( join[OPERAN... */
		      help_ptr[st].rep.rep_state = min;
		    } /* end of if( OPERAND( he...*/
	       } /* end of if( join[OPERAN... */

     if( extra_info )
	printf("end of function Join_Reds()\n");
   } /* end of function Join_Reds() */




void Eq_Red_Sit( quick_data,changed_data,red_paths,extra_info )

   readtype        *quick_data;  /* interface vector to optimization       */
   struct inter  *changed_data;  /* interface between the optimization
				    modules                                 */
   struct ptrp      *red_paths;  /* abstract data structure, which saves
				    the reduction paths                    */
   char             extra_info;  /* if extra_info == 1, then extra infor-
				    mation about begin and end of function
				    is printed out                        */

/* When the user fix, that the lower optimization techniques should apply
   before the higher optimization techniques, then it is possible, that
   two reduce or shift/reduce entries share their code. But contemporary
   the corresponding reduction situations could be different. To prevent
   errors, I join the reduction situations, with the same reduce or
   shift/reduce entries. So the normal higher optimization techniques can
   be applied.
*/

   {
     short                     prod,  /* loop index                        */
			      state,  /* loop index                        */
				 st,  /* loop index                        */
			state_count,  /* number of reduction situations
					 of the current production         */
				nos,  /* number of states                  */
				nop,  /* number of productions             */
			  rep_state,  /* the state which represents the
					 shared states                     */
			   eq_state,  /* another state of the reduction
					 situations, which will be
					 compared with the rep_state       */
				min,  /* the minimum state number of all
					 states which should be joined     */
			       *rep;  /* the representation state for each 
					 state is saved in this vector	   */

     struct rp            *help_ptr;  /* pointer to the reduction situa-
					 tions of the current production   */
     char                     *join,  /* in this vector all states are
					 marked which share the actual
					 reduction situation               */
		      more_than_one;  /* used to decide if there is really
					 more than one state which should
					 be joined                         */

     struct ctr_redp      *redp_ptr;  /* vector used to save and join
					 the reduction situation, which
					 should be shared                  */

     if( extra_info )
	printf("begin of function Eq_Red_Sit()\n");
     nos = *((*quick_data)[9]);
     nop = *((*quick_data)[5]);

     if( ((join = (char *)               calloc(
				     nos,sizeof( char )  )) == NULL) ||
	 ((redp_ptr = (struct ctr_redp*) calloc(
			   nos,sizeof( struct ctr_redp )  )) == NULL) ||
	 ((rep  = (short*)               calloc(
				      nos,sht ))             == NULL) )
	 Error_Message( _EQ_RED_SIT,MODULE_CLEARING,NO_SPACE_FOR_VECTOR,
                        ABORT," rep" );

     for( prod=0;prod<nop;prod++ )
	{
	  help_ptr    = red_paths[prod].pointer;
	  state_count = red_paths[prod].number_of_states;
	  for( st=0;st<nos;st++ )
	     rep[st]  = st;
          for( state=0;state<state_count;state++ )
	       {
		 for( st=0;st<nos;st++ )
		      join[st] = FALSE;
		 more_than_one = FALSE;
		 rep_state = OPERAND( help_ptr[state].state );
		 for( st=state+1;st<state_count;st++ )
		       {
			 eq_state = OPERAND( help_ptr[st].state );

			 /* test if the eq_state share this reduction
			    situation with the rep_state */
			 if(   ((changed_data->equal_rows[rep_state] >= 0) &&
				 (changed_data->equal_rows[rep_state] ==
				  changed_data->equal_rows[eq_state]     ))
			     ||  (changed_data->equal_rows[rep_state] ==
				  eq_state)
			     ||  (changed_data->equal_rows[eq_state]  ==
				  rep_state)
			     ||  (changed_data->under_rows[rep_state] ==
				  eq_state)
			     ||  (changed_data->under_rows[eq_state]  ==
				  rep_state)
			     || ((changed_data->
					   ident_act_rows[rep_state] >= 0) &&
				 (changed_data->ident_act_rows[rep_state] ==
				  changed_data->ident_act_rows[eq_state]  ) )
			   )
				    {
				      if( !join[rep[rep_state]] )
					 {
					   join[rep[rep_state]] = TRUE;
					   min = rep[rep_state];
					 } /* end of if( !join[rep[r... */
				      if( rep[eq_state] < min )
					   min = rep[eq_state];
				      if( !join[rep[eq_state]] )
					 {
                                           join[rep[eq_state]]  = TRUE;
					   more_than_one = TRUE;
					 } /* end of if( !join[rep[e... */
				    } /* end of if(   ((changed... */
		       } /* end of if( !(IS_DEL( h... */
		 if( join[rep[rep_state]] && more_than_one )
		      Join_Reds( quick_data,changed_data,prod,help_ptr,
				 state_count,join,min,rep,nos,redp_ptr,
				 extra_info );
 	       } /* end of if( !(IS_DEL( h... */

	} /* end of for( prod=0;pro... */

     if( extra_info )
	printf("end of function Eq_Red_Sit()\n");

   } /* end of function Eq_Red_Sit() */



