#!/bin/sh
# $Id: colaOpt.cmd,v 1.3 1992/03/05 15:52:29 cogito Exp $
# Copyright, 1990, The University of Paderborn

# colaOpt <
#     colaLalrOpt "cola analyzer options"*
#     colaBackOpt "cola backend options"*
#     colaErrIncl 'macro to stop the table driven parser after the first syntax error'*
#     > "Produces the options for generating the abstract/concrete parser"* :
# 	USER
# 		: (:cola.cmpd :cpp)
#		+ direct

umask 0
cd (|<RUNDIR|)

if [ -s (|<(:cola.cmpd :cpp)|) ]
then ln -s (|<(:cola.cmpd :cpp)|)  opt
else echo '# no options' > opt 
fi

if [ -f (|<direct|) ]
then	(|$/Tool/cola/cola_option.exe|) -direct opt 1>ERRORS 2>&1
else	(|$/Tool/cola/cola_option.exe|) -table  opt 1>ERRORS 2>&1
fi

if test -s core
then
        echo '".", line 0:0 DEADLY: Tool COLA option failed' >> ERRORS
fi

if test -s ERRORS
then
        sed -n -f (|$/Tool/cola/Info/mess_sort|) ERRORS
fi

if test -s ERRS
then
        echo '(''|(|$/Tool/cola/Info/option.err|):std_err:' > (|>ERROR|)
        echo '(''|(|<(:cola.cmpd :cpp)|):cpp_err:' >> (|>ERROR|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' ERRS >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
        echo '|'')' >> (|>ERROR|)
else
    if [ -f (|<direct|) ]
    then mv direct.opt (|>colaBackOpt|)
    else mv table.opt	(|>colaBackOpt|)
	 mv table.2.opt	(|>colaErrIncl|)
    fi
    mv frontend.opt	(|>colaLalrOpt|)
fi

if test -s WARN
then
        echo '(''|(|$/Tool/cola/Info/option.err|):std_err:' > (|>WARNING|)
        echo '(''|(|<(:cola.cmpd :cpp)|):cpp_err:' >> (|>WARNING|)
        sed 's/^"[^"]*", line \([0-9]*\):\([0-9]*\)/\1 \2/' WARN >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
        echo '|'')' >> (|>WARNING|)
fi

exit 0
