/* $Id: queue.h,v 1.7 1992/07/26 23:14:14 waite Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

#ifndef queue_DEF
#define queue_DEF

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif



typedef struct queue QUEUE;
typedef struct queue *QUEUE_PTR;
typedef struct queue_elt QUEUE_ELT;
typedef struct queue_elt *QUEUE_ELT_PTR;


/* Define the structure which represents the queue */
struct queue_elt {
	QUEUE_ELT_PTR next;		/* Points at first element of queue */
	void *value;			    /* Holds pointer to user object */
        };

struct queue {
	QUEUE_ELT_PTR front;		/* Points at first element of queue */
	QUEUE_ELT_PTR end;	         /* Points at last element of queue */
	};


extern QUEUE_PTR init_queue();
extern int empty();
extern void *dequeue();
extern void enqueue();
extern void empty_queue();
extern void reverse_queue();
extern int count_queue();
extern QUEUE_PTR dup_queue();
extern void delete_queue();

#endif /* ! queue_DEF */
