/* $Id: cagt_usr.h,v 1.8 1991/07/01 21:32:46 tony Exp $ */
/* Copyright, 1989, The Regents of the University of Colorado */

/*   The cagt_usr module implements the top-level user interface to CAGT.
 *
 *   Different (machine-specific) user interface modules may be implemented
 *   on top of the basic tool by rewriting those modules prefixed with 
 *   "cagt_usr_" while maintaining the interface specified by the associated
 *   header files. All cagt_usr_ modules must be consistent in the treatment
 *   of user-tool interaction.
 */

#ifndef cagt_usr_DEF
#define cagt_usr_DEF

#define USR_NOSAVFWD	0     /* user wants to exit without saving results */
#define USR_SAVFWD	1	/* user wants to exit after saving results */

typedef struct {
  int (* init)();	/* ^ to user interface init rtn, returns int */
  int (* forward)();	/* ^ to user interface forward processing, ret int */
  int (* shutdown)();	/* ^ to user interface cleanup rtn, returns int */
} CAGT_USR_IF;

/*
 * This variable is defined by the user interface module. It contains pointers
 * to the actual user interface routines. In this way, multiple user interfaces
 * can be added to cagt without it needing to know which one it has been
 * loaded with.
*/
extern CAGT_USR_IF cagt_interface;


extern CAGT_USR_IF cagt_interface ;
extern void sigint_handler();
extern int usr_init_forward();
extern int usr_forward_loop();
extern int usr_shutdown();

#endif /* ! cagt_usr_DEF */
