static char RCSid[] = "$Id: adtinit.c,v 1.8 1991/09/02 08:13:35 waite Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

#include <stdio.h>
#include <ctype.h>
#include "csm.h"
#include "idn.h"

main(argc,argv)
int argc; char *argv[];
{
	char *codefile=NULL, *symbfile=NULL;
	int cl, code, length;
	FILE *f, *h, *fopen();

	while (argc > 1 && *argv[1] == '-') {
		switch (*(++argv[1])) {
		case 'f': dofold = 1; break;
		case 'c': argc--; argv++; codefile = argv[1]; break;
		case 's': argc--; argv++; symbfile = argv[1]; break;
		default: fprintf(stderr, "Invalid option -%s\n", argv[1]);
		}
		argc--; argv++;
	}

	(void) stostr("",0);	/* GAG expects string[0] never to be used */

	if (symbfile != NULL) {
		if ((f = fopen(symbfile, "r")) == NULL) {
			fprintf(stderr, "Cannot open file %s\n", symbfile);
			exit(1);
		}

		while (fscanf(f, " %d %d", &code, &length) != EOF) {
			char str[BUFSIZ];
			int ndx;
			register char *p;
			register int l;

			p = str; getc(f); l = length;
			while (l-- != 0) *p++ = getc(f);
			*p = '\0';

			if (code != 0 || index(str,' ') == 0 && length>0)
				mkidn(str,length,&code,&ndx);
			else (void)stostr(str, length);
		}
		(void)fclose(f);
	}

	if (codefile != NULL) {
		if ((f = fopen(codefile, "r")) == NULL) {
			fprintf(stderr, "Cannot open file %s\n", codefile);
			exit(1);
		}

		while (fscanf(f, " %d %*d %d %d", &cl, &code, &length) != EOF) {
			char str[BUFSIZ];
			int ndx;
			register char *p;
			register int l;

			p = str; getc(f); l = length;
			while (l-- != 0) *p++ = getc(f);
			*p = '\0';

			if (cl == 5) mkidn(str,length,&code,&ndx);
		}
		(void)fclose(f);
	}

	h = fopen("csmtbl.h", "w"); savestr(h); (void)fclose(h);

	h = fopen("idntbl.h", "w");
	(void)fprintf(h, "int dofold = %d;\n", dofold); saveidn(h);
	(void)fclose(h);
	exit(0);
}
