static char RCSid[] = "$Id: kwd.c,v 1.1 1992/08/01 13:56:16 waite Exp $";
/* Keyword recognizer */
/* Copyright 1992, The Regents of the University of Colorado */

#include <stdio.h>
#include <stdlib.h>
#include "source.h"
#include "match.h"

void
ParseCommandLine(argc,argv)
int argc; char *argv[];
{
   if (argc == 1) initBuf("stdin", 0);
   else if (argc > 2) {
      (void)fprintf(stderr, "Usage: %s [file]\n", argv[0]);
      exit(1);
   } else {
      int infile = open(argv[1], 0);
      if (infile != -1) initBuf(argv[1], infile);
      else {
         (void)fprintf(stderr, "%s: cannot open %s for reading\n", argv[0], argv[1]);
         exit(2);
      }
   }
}


main(argc, argv)
int argc;
char *argv[];
{
  char Keyword[BUFSIZ];
  FILE *delit, *str;

  if ((delit = fopen("kwd_gen.delit", "w")) == NULL) {
    (void)fprintf(stderr, "%s: cannot open kwd_gen.delit for writing\n", argv[0]);
    exit(2);
    }

  if ((str = fopen("kwd_gen.str", "w")) == NULL) {
    (void)fprintf(stderr, "%s: cannot open kwd_gen.str for writing\n", argv[0]);
    exit(2);
    }

  ParseCommandLine(argc, argv);

  while (*TokenEnd) {
    if (*TokenEnd != '$') while (*TokenEnd++ != '\n') ;
    else {
      register char *p = TokenEnd + 1;
      register char *q = Keyword;

      while ((*q = *p++) > ' ') if (*q == '\\') *q++ = *p++; else q++;
      p++; *q = '\0';
      if (match(Keyword)) {
        while (*TokenEnd > ' ') (void)putc(*TokenEnd++, delit);
        (void)putc('\n', delit);
        while (*p != '\n') (void)putc(*p++, str);
        p++;
        (void)fprintf(str, " %d %s\n", strlen(Keyword), Keyword);
      } else while (*p++ != '\n') ;
      TokenEnd = p;
    }
    if (*TokenEnd == '\0') refillBuf(TokenEnd);
  }

  return(0);
}
