static char RCSid[] = "$Id: glahead.c,v 1.27 1992/08/17 17:26:09 kadhim Exp $";
/* Copyright, 1989, The Regents of the University of Colorado */

extern char *string[];

#include <stdio.h>
#include <string.h>

#define NORETURN 15001	/* hopefully, no one needs this as a token code */

#include "err.h"
#include "source.h"

static char errbuf[80];	/* to form error messages w/ sprintf */
char *errbufp;		/* use with errbuf, sprintf and malloc */

#define myASSERT
#ifdef myASSERT
/* no need to malloc space, cause this is FATAL */
#define assert(ex) {if (!(ex)){ \
				(void)sprintf(errbuf,\
				"Assertion failed: file %s, line %d\n", \
				__FILE__, __LINE__); \
				message(FATAL, errbuf, 0, &curpos);}}
#else
#define assert(ex) ;
#endif

#include "xtables.h"

#ifdef GLAPRINTTOKENS
#if defined(__cplusplus) || defined(__STDC__)
int
glalex (char *v)
#else
int
glalex (v)
char *v;		/* pointer to storage for intrinsic value */
#endif
{
	int code;
	char tmp;
	static int init = 0;

	code = debugglalex (v);	/* first do the work */

	if (GlaPrintTokens) {	/* print info ? */
		if (init == 0) {
			init++;
			fprintf (stderr, "(line,col) code,intrinsic\tsrc-matched  TOK\n");
		}
		tmp = *TokenEnd;	/* make a string for printf */
		*TokenEnd = '\0';
		fprintf (stderr, "(%d,%d)	%d,%d	\"%s\"	",
			 curpos.line, curpos.col,code, *v, TokenStart);
		
		/* Is code within limits? */
		if (code >= 0 &&
		    code < sizeof (TokenStrings) / sizeof (TokenStrings[0]))
			fprintf (stderr, "%s\n",
				 TokenStrings[code] == NULL ? "NULL"
				 : TokenStrings[code]);
		else /* no */
			fprintf (stderr, "non-compact token code\n");

		*TokenEnd = tmp;
	}
	return(code);
}

#if defined(__cplusplus) || defined(__STDC__)
int
debugglalex(char *v)
#else
int
debugglalex(v)
char *v;		/* pointer to storage for intrinsic value */
#endif

#else
#if defined(__cplusplus) || defined(__STDC__)
int
glalex(char *v)
#else
int
glalex(v)
char *v;		/* pointer to storage for intrinsic value */
#endif
#endif
{
	/*ASSERT TokenEnd points to first char in buffer */
	/*ASSERT LineNum == number of newlines seen +1 */
#if defined(__cplusplus) || defined(__STDC__)
	char *(*scan)(char *, int);
	void  (*proc)(char *, int, int *, char *);
#else
	char *(*scan)();
	void  (*proc)();
#endif
	register char c;		/* hold current char */
	int extcode;			/* external token repr */

	/* this holds the base in a register */
	register unsigned char *scanTbl = ScanTbl; 

	register char *p = TokenEnd;	/* most current working pointer */

	/* continue/start a new token */
	for(;;) {
		curpos.line = LineNum;	/* beginning of token */
		curpos.col = p - StartLine;
		TokenStart = p;

		switch (CaseTbl[c = *p++]) {
		case 0:			/* sentinel - probably EOB */
			if (c == '\0') {
				--p;	/* backup to null byte */
				refillBuf (p);
				p = TokenEnd;
				StartLine = p-1;
				if (*p == '\0')
					return (EOFTOKEN);
				continue;
			} else {
				/* malloc enough to expand the sprintf below */
				errbufp = (char *) malloc (50);
				if (errbufp == NULL)
					message (FATAL,"malloc fail: CaseTbl0",
						 0, &curpos);
				(void) sprintf (errbufp,
						"char '%c' (ascii:%d) is not a token",
						c, c);
				message (ERROR, errbufp, 0, &curpos);
				continue;
			}
			
		case 1:	/* space */
			while (scanTbl[c= *p++] & 1<<0)
				;
			--p;
			continue;

		case 2:	/* tab */
			/* p was auto incremented, so at most we go 7 */
			/* more cols, modulo-8 gives us this- 0-7 */
			StartLine -= 7 - (p - StartLine - 2) % 8;
			while (scanTbl[c= *p++] & 1<<1)
				StartLine -= 7 - (p - StartLine - 2) % 8;
			--p;
			continue;

		case 3:	/* newline */
			LineNum++;
			while (scanTbl[c= *p++] & 1<<2)
				LineNum++;
			StartLine = --p - 1;
			continue;
			
			/****************************/
			/* generated code goes here */
			/****************************/
#include "xcode.h"
			
			/* xcode.h has the end of the switch statement! */
			
	fallback:	
		if (TokenEnd == TokenStart) {
			/* never passed thru final state */
			errbufp = (char *) malloc (50);
			if (errbufp == NULL)
				message (FATAL,"malloc fail: fallback",
					 0, &curpos);
			(void) sprintf (errbufp,
					"char '%c' (ascii:%d) not complete token",
					*TokenStart, *TokenStart);
			message (ERROR, errbufp, 0, &curpos);
			continue;
		}
		
		if (!(TokenEnd >= TokenStart))
			fprintf (stderr, "Assertion L=%d, C=%d\n",LineNum,
				 p - StartLine);
		/* TokenStart may not exceed TokenEnd */
		assert (TokenEnd >= TokenStart);
		/* we now know that End > Start */
		
		assert (*p != '\0');
		/* we must make progress */
		assert (p > TokenStart);
		/* TokenEnd must never exceed p */
		assert (p >= TokenEnd);
		
		/*
		 * At this point we know we have found a token, but
		 * need to handle the case where, while looking for
		 * a long token, we passed over one or more shorter
		 * tokens - the long token was never found.
		 * Must fallback to shorter final state 
		 */
		if (TokenEnd < p) {
			/* fallback */
			p = TokenEnd;
		}
		
		if (scan != NULL)
			TokenEnd = p = (*scan) (TokenStart,
						TokenEnd - TokenStart);
		
		if (proc != NULL)
			(*proc) (TokenStart, TokenEnd - TokenStart,
				 &extcode, v);
		
		if (extcode == NORETURN)
			continue;
		else
			return (extcode);
		
	} /* end for ever */
}
