#!/bin/sh
#
#  Copyright (c) 1992, Kimura Laboratory, Department of Information Science,
# Tokyo Institute of Technology. All Rights Reserved.
#
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
#!/bin/sh
#
#  Copyright (c) 1992, Kimura Laboratory, Department of Information Science,
# Tokyo Institute of Technology. All Rights Reserved.
#
plink=$bindir/plink
optable=op-table.c
libdirs=-L$libdir
libs_default="-lclu2c -lgc -lm"
verbose=
outfile=

while test \$# -gt 0
do
	case \$1 in
	\$optable)	;;
	*.[co])		args="\$args \$1";;
	-L*)		libdirs="\$libdirs \$1";;
	-l*)		libs="\$libs \$1";;
	-o)		outfile="-o \$2"; shift;;
	-v)		verbose=-v;;
	*)		copts="\$copts \$1";;
	esac
	shift
done
libs="\$libs \$libs_default"
if test \$verbose
then
	set -x
fi
\$plink \$args
$cc -w -I$incdir \$copts \$args \$optable \$libdirs \$libs \$outfile
EOF
echo ' done'
chmod +x $target
