#!/bin/sh
#
#  Copyright (c) 1992, Kimura Laboratory, Department of Information Science,
# Tokyo Institute of Technology. All Rights Reserved.
#
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
#
#  Copyright (c) 1992, Kimura Laboratory, Department of Information Science,
# Tokyo Institute of Technology. All Rights Reserved.
#

BINDIR    = $bindir
TMPBINDIR = ../bin
SCRIPTS   = clulink

all: \$(SCRIPTS)
	cp \$(SCRIPTS) \$(TMPBINDIR)

clulink:  clulink.SH
	./clulink.SH

install: \$(SCRIPTS) \$(BINDIR)
	@for i in \$(SCRIPTS);\\
	do\\
		echo -n 'Installing' \$\$i '...';\\
		install -c \$\$i \$(BINDIR);\\
		echo ' done';\\
	done

\$(BINDIR):
	mkdir \$(BINDIR)
	chmod 755 \$(BINDIR)

clean:
	rm -f \$(SCRIPTS)
	(cd \$(TMPBINDIR); rm -f \$(SCRIPTS))
EOF
echo ' done'
