#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../../config/config.sh
. $config
# cancel optimize option
cflags=`echo $cflags | sed 's/-O[0-9]*//'`
echo -n "Extracting $target ..."
cat >$target <<EOF
CC        = $cc
TMPINCDIR = ../../include
CFLAGS    = $cflags -I../../include -w
LIBDIR    = $libdir
TMPLIBDIR = ../../lib
BINDIR    = $bindir
TMPBINDIR = ../../bin
OBJ       = code.o etc.o p_decl.o plink.o tidtab.o

all: plink
	cp plink \$(TMPBINDIR)

plink: \$(OBJ)
	\$(CC) \$(CFLAGS) \$(OBJ) -L\$(TMPLIBDIR) -lclu2c -lgc -lm -o plink

install: plink \$(BINDIR)
	@echo -n 'Installing plink ... '
	@install -c plink \$(BINDIR)
	@echo 'done'

clean:
	rm -f \$(OBJ) plink \$(TMPBINDIR)/plink
EOF
echo ' done'
