#!/bin/sh
target=`expr $0 : '.*/\(.*\)\.SH' \| $0 : '\(.*\)\.SH'`
config=../../config/config.sh
. $config
echo -n "Extracting $target ..."
cat >$target <<EOF
TMPLIBDIR = ..
TMPINCDIR = ../../include
CC        = $cc
CFLAGS    = $cflags -I\$(TMPINCDIR) -w
AR        = $ar
LIBDIR    = $libdir
ARCHIVE   = libcmp.a
OBJS      =\\
	_all_dir_entries.o\\
	_all_dir_entries_.o\\
	_all_file_names_.o\\
	_change_mode.o\\
	_get_runtime.o\\
	_get_version.o\\
	_match_name_spec.o\\
	_stop.o\\
	_system_root.o\\
	all_file_names.o\\
	file_date.o\\
	file_exists.o\\
	hash.o\\
	hex.o\\
	octal.o\\
	quit_.o\\
	run_time.o\\
	time.o

all: $(ARCHIVE)
	cp \$(ARCHIVE) \$(TMPLIBDIR)

\$(ARCHIVE): \$(OBJS)
	rm -f \$(ARCHIVE)
	\$(AR) ru \$(ARCHIVE) \$(OBJS)
	ranlib \$(ARCHIVE)

_system_root.o: _system_root.c
	\$(CC) \$(CFLAGS) -DLIBDIR=\"$(LIBDIR)\" -c \$<

install: \$(ARCHIVE) \$(LIBDIR)
	rm -f \$(LIBDIR)/\$(ARCHIVE)
	cp \$(ARCHIVE) \$(LIBDIR)

\$(LIBDIR):
	mkdir \$(LIBDIR)
	chmod 755 \$(LIBDIR)

clean:
	rm -f \$(OBJS) \$(ARCHIVE) \$(TMPLIBDIR)/\$(ARCHIVE)
EOF
echo ' done'
