/* 
 * $Id: variant.c,v 2.0 1992/09/23 08:45:58 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/*
 * make_Ni = proc(Ti)returns(variant[N1:T1,...,Nn:Tn])
 */

int variant_make(int tag, elt e)
{
  variant var;

  var = (variant) malloc(sizeof(struct variant_rep));
  var->tag = tag;
  var->value = e;
  retval_area[0] = (elt) var;
  return(RET);
}

/*
 * change = proc(variant[N1:T1,...,Nn:Tn])
 */

int variant_change(int tag, variant var, elt e)
{
  var->tag = tag;
  var->value = e;
  return(RET);
}

/*
 * is_Ni = proc(variant[N1:T1,...,Nn:Tn])returns(bool)
 */

int variant_is_(int tag, variant var)
{
  retval_area[0] = (var->tag == tag) ? TRUE : FALSE;
  return(RET);
}

/*
 * value_Ni = proc(variant[N1:T1,...,Nn:Tn])returns(Tisignals(wrong_tag)
 */

int variant_value(int tag, variant var)
{
  if (var->tag == tag) {
    retval_area[0] = (elt) var->value;
    return(RET);
  }
  else {
    signame = "wrong_tag";
    return(SIG);
  }
}

/*
 * v_gets_v = proc(variant[N1:T1,...,Nn:Tn])returns(variant[N1:T1,...,Nn:Tn])
 */

int variant_v_gets_v(variant var1, variant var2)
{
  var1->tag = var2->tag;
  var1->value = var2->value;
}

/*
 * v_gets_o = proc(variant[N1:T1,...,Nn:Tn])returns(oneof[N1:T1,...,Nn:Tn])
 */

int variant_v_gets_o(variant var, oneof one)
{
  var->tag = one->tag;
  var->value = one->value;
}

/*
 * equal = proc(variant[N1:T1,...,Nn:Tn],variant[N1:T1,...,Nn:Tn])returns(bool)
 */

int variant_equal(variant var1, variant var2)
{
  retval_area[0] = (var1 == var2) ? TRUE: FALSE;
  return(RET);
}

/*
 * copy1 = proc(v: variant[N1:T1,...,Nn:Tn) returns(variant[N1:T1,...,Nn:Tn)
 */

int variant_copy1(variant v)
{
    variant new;

    /* allocate new variant */
    new = (variant) malloc(sizeof(struct variant_rep));

    /* do copy */
    new->tag = v->tag;
    new->value = v->value;

    /* return new variant */
    retval_area[0] = (elt) new;
    return RET;
}

/*
 * print = proc(v: variant[n1: t1, ..., nn: tn], pst: pstream)
 *	where each ti has print: proctype(ti, pstream)
 */

int variant_print(int (*(op_list[]))(), variant v, clus pst)
{
    if ( _cpstream_start(pst, "<") == SIG ) {
	out_handler();
	return SIG;
    }
    if ( int_print(v->tag, pst) == SIG ) {
	out_handler();
	return SIG;
    }
    if ( _cpstream_text(pst, ": ") == SIG ) {
	out_handler();
	return SIG;
    }
    if ( (*(op_list[v->tag - 1]))(v->value, pst) == SIG ) {
	out_handler();
	return SIG;
    }	
    if ( _cpstream_stop(pst, ">") == SIG ) {
	out_handler();
	return SIG;
    }
    return RET;
}

/*
 * _gcd = proc(v: variant[n1: t1, ..., nn: tn], tab: gcd_tab) returns(int)
 *	where each ti has _gcd: proctype(ti, gcd_tab) returns(int)
 */

int variant__gcd(int (*(op_list[]))(), variant v, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "variant$_gcd: not implemented";
    return SIG;
}
