/* 
 * $Id: sequence.c,v 2.0 1992/09/23 08:44:43 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/* define for array$elements */
#define ALLOC_SZ_ELM     4          /* allocate size for iter araay$elements */
#define ARG_S_ELM    ((sequence)(*ivarp)[1]) /* argment s in elements */
#define LV_I_ELM     (*ivarp)[2]    /* local variable i in sequence$elements */
#define LV_SZ_ELM    (*ivarp)[3]    /* local variable sz in araay$elements */

/* define for sequence$indexes */
#define ALLOC_SZ_IND     4          /* allocate size for iter araay$indexes */
#define ARG_A_IND    ((sequence)(*ivarp)[1])     /* argment a in indexes */
#define LV_LO_IND    (*ivarp)[2]    /* local variable lo in sequence$indexes */
#define LV_HI_IND    (*ivarp)[3]    /* local variable hi in araay$indexes */

extern int (*op_table())();
extern string get_subparam();

/*
 * new = proc()returns(sequence[T])
 */

int sequence_new()
{
  sequence res;

  res = (sequence) malloc(sizeof(struct sequence_rep));	/* make rep */
  res->size = 0;

  retval_area[0] = (elt) res;
  return(RET);
}

/*
 * size = proc(sequence[T])returns(int)
 */

int sequence_size(sequence a)
{
  retval_area[0] = (elt) (a->size);
  return(RET);
}

/*
 * empty = proc(sequence[T])returns(bool)
 */

int sequence_empty(sequence a)
{
  retval_area[0] = (elt) (a->size <= 0);
  return(RET);
}

/*
 * subseq = proc(sequence[T],int,int)returns(sequence[T])
 *          signals(bounds,negative_size)
 */

int sequence_subseq(sequence s, int top, int size)
{
  int i,n;
  sequence res;

  if (top < 1 || top > s->size + 1) {
    signame = "bounds";
    return(SIG);
  }
  if (size < 0) {
    signame = "negative_size";
    return(SIG);
  }
  if (size <= s->size - top + 1)
    n = size;
  else
    n = s->size - top + 1;
  
  res = (sequence) malloc(sizeof(struct sequence_rep));
  res->size = n;
  res->buf = (elt*) malloc(n*sizeof(elt));
  for(i = 0; i < n; i++)
/*    res->buf[i] = s->buf[top + i];*/
    res->buf[i] = s->buf[top + i - 1];
  retval_area[0] = (elt) res;
  return(RET);
}

/*
 * fill = proc(int,T)returns(sequence[T])signals(negative_size)
 */

int sequence_fill(int sz, elt e)
{
  sequence res;
  int i;

  if (sz < 0) {
    signame  = "negative_size";
    return(SIG);
  }
     
  res = (sequence) malloc(sizeof(struct sequence_rep));	/* make rep */
  res->size = sz;
  res->buf = (elt *) malloc(sz * sizeof(elt));

  for(i = 0; i < sz; i++)				/* insert to buf */
    res->buf[i] = (elt) e;
	
  retval_area[0] = (elt) res;
  return(RET);
}

/*
 * fetch = proc(sequence[T],int)returns(T)signals(bounds)
 */

int sequence_fetch(sequence s, int i)
{
  if (i < 1 || i > s->size) {
    signame = "bounds";
    return(SIG);
  }
  retval_area[0] = (elt) (s->buf[i-1]);
  return(RET);
}

/*
 * bottom = proc(sequence[T])returns(T)signals(bounds)
 */

int sequence_bottom(sequence s)
{
  if (s->size <= 0) {
    signame = "bounds";
    return(SIG);	
  }
  retval_area[0] = (elt) s->buf[0];
  return(RET);
}

/*
 * top = proc(sequence[T])returns(T)signals(bounds)
 */

int sequence_top(sequence s)
{
  if (s->size <= 0) {
    signame = "bounds";
    return(SIG);	
  }
  retval_area[0] = (elt) s->buf[s->size - 1];
  return(RET);
}

/*
 * replace = proc(sequence[T],int,T)returns(sequence[T])signals(bounds)
 */

int sequence_replace(sequence s, int i, elt e)
{
  int j;
  sequence new;

  if (i < 1 || i > s->size) {
    signame = "bounds";
    return(SIG);
  }
  new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = s->size;
  new->buf = (elt*) malloc(sizeof(elt)*s->size);
  
  for(j = 0; j < s->size; j++)
    new->buf[j] = s->buf[j];
  new->buf[i-1] = e;
  retval_area[0] = (elt) new;
  return(RET);
}

/*
 * addh = proc(sequence[T],T)returns(sequence[T])signals(bounds)
 */

int sequence_addh(sequence s, elt e)
{
  int i;
  sequence new;

  new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = s->size + 1;
  new->buf = (elt*) malloc(sizeof(elt)*(new->size));
  
  for(i = 0; i < s->size; i++)
    new->buf[i] = s->buf[i];
  new->buf[s->size] = e;
  retval_area[0] = (elt) new;
  return(RET);
}

/*
 * remh = proc(sequence[T],T)returns(sequence[T])signals(bounds)
 */

int sequence_addl(sequence s, elt e)
{
  int i;
  sequence new;

  new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = s->size + 1;
  new->buf = (elt*) malloc(sizeof(elt)*(new->size));
  
  new->buf[0] = e;
  for(i = 1; i <= s->size; i++)
    new->buf[i] = s->buf[i-1];

  retval_area[0] = (elt)new;
  return(RET);
}

/*
 * addl = proc(sequence[T],T)returns(sequence[T])signals(bounds)
 */

int sequence_remh(sequence s)
{
  int i;
  sequence new;

  if (s->size <= 0) {
    signame = "bounds";
    return(SIG);	
  }
  new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = s->size - 1;
  new->buf = (elt*) malloc(sizeof(elt)*(new->size));
  
  for(i = 0; i < new->size; i++)
    new->buf[i] = s->buf[i];
  retval_area[0] = (elt) new;
  return(RET);
}

/*
 * reml = proc(sequence[T],T)returns(sequence[T])signals(bounds)
 */

int sequence_reml(sequence s)
{
  int i;
  sequence new;

  if (s->size <= 0) {
    signame = "bounds";
    return(SIG);	
  }
  new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = s->size - 1;
  new->buf = (elt*) malloc(sizeof(elt)*(new->size));
  
  for(i = 1; i < s->size; i++)
    new->buf[i-1] = s->buf[i];
  retval_area[0] = (elt) new;
  return(RET);
}	

/*
 * e2s = proc(T)returns(sequence[T])
 */

int sequence_e2s(elt e)
{
  sequence new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = 1;
  new->buf = (elt*) malloc(sizeof(elt));
  new->buf[new->size - 1] = e;
  retval_area[0] = (elt) new;  
  return(RET);
}

/*
 * concat = proc(sequence[T],sequence[T])returns(sequence[T])
 */

int sequence_concat(sequence s1, sequence s2)
{
  int i, j;
  sequence new;

  new = (sequence) malloc(sizeof(struct sequence_rep));
  new->size = s1->size + s2->size;
  new->buf = (elt*) malloc(sizeof(elt)*(new->size));

  for(i = 0; i < s1->size; i++)
    new->buf[i] = s1->buf[i];
  for(j = 0; j < s2->size; j++)
    new->buf[i+j] = s2->buf[j];
  
  retval_area[0] = (elt) new;
  return(RET);
}

/*
 * a2s = proc(array[T])returns(sequence[T])
 */

int sequence_a2s(array a)
{
  int i;
  sequence s;

  s = (sequence) malloc(sizeof(struct sequence_rep));
  s->size = a->size;
  s->buf = (elt *) malloc(s->size * sizeof(elt));
  
  for(i = 0; i < s->size; i++)
    s->buf[i] = a->buf[a->base + i];

  retval_area[0] = (elt) s;
  return(RET);
}

/*
 * s2a = proc(sequence[T])returns(array[T])
 */

int sequence_s2a(sequence s)
{
  int i;
  array a;

  a = (array) malloc(sizeof(struct array_rep));
  a->low = 1;
  a->size = s->size;
  a->buf_sz = (s->size < 5) ? 10: s->size * 2;
  a->base = a->buf_sz / 3;
  a->buf = (elt*) malloc(sizeof(elt) * a->buf_sz);

  for(i = 0; i < s->size; i++)
    a->buf[a->base + i] = s->buf[i];
  
  retval_area[0] = (elt) a;
  return(RET);
}

/*
 * elements = iter(sequence[T])yields(T)
 */

int sequence_elements(bool init, elt **ivarp, sequence s)
{
  /* local var int i, sz */

  if (init) {               /* initial iterator call */
    *ivarp = (int*) malloc(ALLOC_SZ_ELM*sizeof(elt));
    (*ivarp)[1] = (elt) s;
  }
  else                     /* not initial call, goto previous yield point */
    if ((*ivarp)[0] == 1) goto yield1;

  LV_SZ_ELM = (elt) ARG_S_ELM->size;

  for (LV_I_ELM = 0; LV_I_ELM < LV_SZ_ELM; LV_I_ELM++) {
    retval_area[0] = (elt) ARG_S_ELM->buf[LV_I_ELM];
    (*ivarp)[0] = 1;
    return(RET);
  yield1:
    (0);
  }
  iter_end = TRUE;
  return(RET);
}

/*
 * indexes = iter(sequence[T])returns(T)
 */

int sequence_indexes(bool init, elt **ivarp, sequence s)
{
  if (init) {               /* initial iterator call */
    *ivarp = (int*) malloc((1+2)*sizeof(int));
    (*ivarp)[1] = 1;
    (*ivarp)[2] = s->size;
  }
  else                     /* not initial call, goto previous yield point */
    if ((*ivarp)[0] == 1) goto yield1;

  while ((*ivarp)[1] <= (*ivarp)[2]) {
    retval_area[0] = (elt) (*ivarp)[1];
    (*ivarp)[0] = 1;
    return(RET);
  yield1:
    (*ivarp)[1]++;
  }
  iter_end = TRUE;
  return(RET);
}


/*
 * print = proc (s: sequence[t], pst: pstream)
 *	where t has print: proctype(t, pstream)
 */

int sequence_print(int (*(op_list[]))(), sequence s, clus pst)
{
    int i;

    if ( _cpstream_start(pst, "[") == SIG ) {
	out_handler();
	return SIG;
    }
    for ( i = 0; i < s->size; i++ ) {
	if ( i > 0 ) {
	    if ( _cpstream_pause(pst, ", ") == SIG ) {
		out_handler();
		return SIG;
	    }
	    bool_not((bool) retval_area[0]);
	    if ( (bool) retval_area[0] ) {
		break;
	    }
	}
	(*(op_list[0]))(s->buf[i], pst);	 /* invoke t$print */
    }
    if ( _cpstream_stop(pst, "]") == SIG ) {
	out_handler();
	return(SIG);
    }
    return RET;
}

/*
 * _gcd = proc(s: seq, tab: gcd_tab) returns(int)
 *	where t has _gcd: proctype(t, gcd_tab) returns(int)
 */

/* stub version */

int sequence__gcd(int (*(op_list[]))(), sequence s, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "sequence$_gcd: not implemented";
    return SIG;
}
