/*
 * $Id: delete_file.c,v 2.1 1992/03/16 18:18:33 ushijima Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* delete_file = proc(fn: file_name) signals(not_possible(string))
 *	% Deletes oldfn as newfn. 
 * 	end delete_file
 */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

extern char* sys_errlist[];
extern int errno;

int _pdelete_file(clus fn)
{
    int except_level;
    string name;

    /*
     *	begin body
     */

    except_level = 0;

    /* fn := file_name_fill(fn, "") */
    if (_pfile_name_fill(fn, "") == SIG)
	goto sighandler;
    fn = (clus) retval_area[0];

    /* name: string := file_name$unparse(fn) */
    if (file_name_unparse(fn) == SIG)
	goto sighandler;
    name = (string) retval_area[0];

    if (unlink(name) < 0) {
	/* signal not_possible(...) */
	sigarg_area[0] = (elt) sys_errlist[errno];
	signame = "not_possible";
	return SIG;
    }

    return RET;

    /*
     *	end body
     */

    /*
     *	signal handler (exception handler)
     */

 sighandler:
    switch (except_level) {
    case -1:
	string_concat("unhandle exception: ", signame);
	sigarg_area[0] = retval_area[0];
	signame = "failure";
	return (SIG);
    case 0:
	if (!strcmp(signame, "failure"))
	    return (SIG);
	else {
	    string_concat("unhandle exception: ", signame);
	    sigarg_area[0] = retval_area[0];
	    signame = "failure";
	    return (SIG);
	}
    }
}
