/* 
 * $Id: char.c,v 2.0 1992/09/23 08:39:49 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* fully implemented */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

#define CHAR_TOP 255

/*
 * i2c = proc(int)returns(char)signals(illegal_char)
 */

int char_i2c(int i)
{
	if (i < 0 || i > CHAR_TOP) {
	  signame = "illegal_char";
	  return(SIG);
	}
	retval_area[0] = i;
	return(RET);
}

/*
 * c2i = proc(char)returns(int)
 */

int char_c2i(char c)
{
	retval_area[0] = c;
	return(RET);
}

/*
 * lt = proc(char,char)returns(bool)
 */

int char_lt(char c1, char c2)
{
	retval_area[0] = (c1 < c2);
	return(RET);
}

/*
 * le = proc(char,char)returns(bool)
 */

int char_le(char c1, char c2)
{
	retval_area[0] = (c1 <= c2);
	return(RET);
}

/*
 * gt = proc(char,char)returns(bool)
 */

int char_gt(char c1, char c2)
{
	retval_area[0] = (c1 > c2);
	return(RET);
}

/*
 * ge = proc(char,char)returns(bool)
 */

int char_ge(char c1, char c2)
{
	retval_area[0] = (c1 >= c2);
	return(RET);
}

/*
 * equal = proc(char,char)returns(bool)
 */

int char_equal(char c1, char c2)
{
	retval_area[0] = (c1 == c2);
	return(RET);
}

/*
 * similar = proc(char,char)returns(bool)
 */

int char_similar(char c1, char c2)
{
	retval_area[0] = (c1 == c2);
	return(RET);
}

/*
 * copy = proc(char,char)returns(bool)
 */

int char_copy(char c)
{
	retval_area[0] = c;
	return(RET);
}

/*
 * print = proc(c: char, pst: pstream)
 */

int char_print(char c, clus pst) 
{
    static string text;

    if ( _cpstream_text(pst, "\'") == SIG ) {
	out_handler();
	return(SIG);
    }
    if ( 32 <= c && c <= 127 ) {
	/* printable character */
	string_c2s(c);
	if ( _cpstream_text(pst, retval_area[0]) == SIG ) {
	    out_handler();
	    return(SIG);
	}
    } else {
	/* unprintable character */
	text = (string) malloc_atomic(5 * sizeof(char));
	sprintf(text, "\\%03o", (unsigned) c);
	if ( _cpstream_text(pst, text) == SIG ) {
	    out_handler();
	    return(SIG);
	}
    }
    if ( _cpstream_text(pst, "\'") == SIG ) {
	out_handler();
	return(SIG);
    }
    return(RET);
}

/*
 *  encode = proc(c: char, s: istream) signals(not_possible(string))
 *	modifies  s.
 *	effects  Writes an encoding of c onto the istream s.
 */

int char_encode(char c, istream s)
{
    return(istream_putc(s, c));
}

/*
 *  decode = proc(s: istream) returns(char)
 *			      signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 */

int char_decode(istream s)
{
    return(istream_getc(s));
}

/*
 * _gcd = proc(c: char, tab: gcd_tab) returns(int)
 */

int char__gcd(char c, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "char$_gcd: not implemented";
    return(SIG);
}
