/* 
 * $Id: bool.c,v 2.0 1992/09/23 08:39:14 toh-hei Exp $
 *
 * Copyright (c) 1992 Kimura Laboratory, Department of Information Science,
 * Tokyo Institute of Technology.  All Rights Reserved.
 *
 */

/* fully implemented */

#include <clu2c.h>
#include <type.h>
#include <glo.h>

/*
 * and = proc(bool,bool)returns(bool)
 */

int bool_and(bool b1, bool b2)
{
	retval_area[0] = b1 && b2;
	return(RET);
}

/*
 * or = proc(bool,bool)returns(bool)
 */

int bool_or(bool b1, bool b2)
{
	retval_area[0] = b1 || b2;
	return(RET);
}

/*
 * not = proc(bool)returns(bool)
 */

int bool_not(bool b)
{
	retval_area[0] = ! b;
	return(RET);
}

/*
 * equal = proc(bool,bool)returns(bool)
 */

int bool_equal(bool b1, bool b2)
{
	retval_area[0] = (b1 == b2);
	return(RET);
}

/*
 * similar = proc(bool,bool)returns(bool)
 */

int bool_similar(bool b1, bool b2)
{
	retval_area[0] = (b1 == b2);
	return(RET);
}

/*
 * copy = proc(bool)returns(bool)
 */

int bool_copy(bool b)
{
	retval_area[0] = b;
	return(RET);
}

/*
 * print = proc(b: bool, pst: pstream)
 */

int bool_print(bool b, clus pst) 
{
    string text = "false";

    if ( b ) {
	text = "true";
    }
    if ( _cpstream_text(pst, text) == SIG ) {
	out_handler();
	return(SIG);
    }
    return(RET);
}

/*
 *  encode = proc(b: bool, s: istream) signals(not_possible(string))
 *	modifies  s.
 *	effects  Writes an encoding of b onto the istream s.
 */

int bool_encode(bool b, istream s)
{
    return(istream_puti(s, (int) b));
}

/*
 *  decode = proc(s: istream) returns(bool)
 *			      signals(end_of_file, not_possible(string))
 *	modifies  s.
 *	effects  Decodes the information written by encode operations
 *	    and return an object "similar" to the one encoded.
 */

int bool_decode(istream s)
{
    bool b;

    if (istream_geti(s) == SIG) {
	return(SIG);
    }
    b = (bool) retval_area[0];
    if (b != TRUE && b != FALSE) {
	sigarg_area[0] = (elt) "bad format";
	signame = "not_possible";
	return(SIG);
    }
    return(RET);
}

/*
 * _gcd = proc(b: bool, tab: gcd_tab) returns(int)
 */

int bool__gcd(bool b, clus tab)
{
    signame = "failure";
    sigarg_area[0] = (elt) "bool$_gcd: not implemented";
    return(SIG);
}
